/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.WritableAggregate;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;

final class TranslateCommand
extends CommandRunner {
    TranslateCommand(int commandIndex, Object[] arguments) throws InvalidOptionException {
        super(commandIndex, arguments, EnumSet.of(Option.METADATA, Option.OUTPUT, Option.FORMAT, Option.HELP, Option.DEBUG));
    }

    @Override
    public int run() throws Exception {
        if (this.hasUnexpectedFileCount(1, Integer.MAX_VALUE)) {
            return 3;
        }
        Object output = this.getMandatoryOption(Option.OUTPUT);
        String format = this.getOptionAsString(Option.FORMAT);
        StorageConnector connector = new StorageConnector(output);
        connector.setOption(OptionKey.OPEN_OPTIONS, (Object)new StandardOpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE});
        try (DataStore target = DataStores.openWritable((Object)connector, (String)format);){
            for (Object file : this.files) {
                DataStore source = DataStores.open((Object)this.inputConnector(file));
                try {
                    if (target instanceof WritableAggregate) {
                        ((WritableAggregate)target).add((Resource)source);
                        continue;
                    }
                    if (!(target instanceof WritableGridCoverageResource)) continue;
                    this.write((Resource)source, (WritableGridCoverageResource)target);
                }
                finally {
                    if (source == null) continue;
                    source.close();
                }
            }
        }
        return 0;
    }

    private void write(Resource source, WritableGridCoverageResource target) throws DataStoreException {
        if (source instanceof GridCoverageResource) {
            target.write(((GridCoverageResource)source).read(null, null), new WritableGridCoverageResource.Option[0]);
        } else if (source instanceof Aggregate) {
            for (Resource component : ((Aggregate)source).components()) {
                this.write(component, target);
            }
        } else {
            String id = source.getIdentifier().orElse(null);
            if (id == null) {
                id = Classes.getShortClassName((Object)source);
            }
            this.err.println(Errors.format((short)13, (Object)id));
        }
    }
}

