/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Map;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.MapProjectionParameters;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

@XmlTransient
final class MapProjectionDescriptor
extends DefaultParameterDescriptorGroup {
    private static final long serialVersionUID = -9142116135803309453L;
    final boolean hasStandardParallels;

    MapProjectionDescriptor(Map<String, ?> properties, ParameterDescriptor<?>[] parameters) {
        super(properties, (GeneralParameterDescriptor[])MapProjectionDescriptor.addAxisLengths(parameters));
        boolean hasP1 = false;
        boolean hasP2 = false;
        for (ParameterDescriptor<?> param : parameters) {
            switch (param.getName().getCode()) {
                case "standard_parallel_1": {
                    hasP1 = true;
                    break;
                }
                case "standard_parallel_2": {
                    hasP2 = true;
                    break;
                }
                default: {
                    for (GenericName alias : param.getAlias()) {
                        switch (alias.tip().toString()) {
                            case "standard_parallel_1": {
                                hasP1 = true;
                                break;
                            }
                            case "standard_parallel_2": {
                                hasP2 = true;
                            }
                        }
                    }
                }
            }
            if (hasP1 & hasP2) break;
        }
        this.hasStandardParallels = hasP1 & hasP2;
    }

    private static ParameterDescriptor<?>[] addAxisLengths(ParameterDescriptor<?>[] parameters) {
        ParameterDescriptor[] ext = new ParameterDescriptor[parameters.length + 2];
        ext[0] = MapProjection.SEMI_MAJOR;
        ext[1] = MapProjection.SEMI_MINOR;
        System.arraycopy(parameters, 0, ext, 2, parameters.length);
        return ext;
    }

    static boolean isHeuristicMatchForName(String n1, String n2) {
        return CharSequences.equalsFiltered((CharSequence)n1, (CharSequence)n2, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true);
    }

    @Override
    public GeneralParameterDescriptor descriptor(String name) throws ParameterNotFoundException {
        if (MapProjectionDescriptor.isHeuristicMatchForName(name, "earth_radius")) {
            return MapProjectionParameters.EarthRadius.DESCRIPTOR;
        }
        if (MapProjectionDescriptor.isHeuristicMatchForName(name, "inverse_flattening")) {
            return MapProjectionParameters.InverseFlattening.DESCRIPTOR;
        }
        if (MapProjectionDescriptor.isHeuristicMatchForName(name, "is_ivf_definitive")) {
            return MapProjectionParameters.IsIvfDefinitive.DESCRIPTOR;
        }
        if (this.hasStandardParallels && MapProjectionDescriptor.isHeuristicMatchForName(name, "standard_parallel")) {
            return MapProjectionParameters.StandardParallel.DESCRIPTOR;
        }
        return super.descriptor(name);
    }

    @Override
    public ParameterValueGroup createValue() {
        return new MapProjectionParameters(this);
    }
}

