/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Transformation;

enum TableInfo {
    CRS(CoordinateReferenceSystem.class, "\"Coordinate Reference System\"", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME", "COORD_REF_SYS_KIND", new Class[]{ProjectedCRS.class, GeographicCRS.class, GeocentricCRS.class, VerticalCRS.class, CompoundCRS.class, EngineeringCRS.class, DerivedCRS.class, TemporalCRS.class, DefaultParametricCRS.class}, new String[]{"projected", "geographic 2D", "geocentric", "vertical", "compound", "engineering", "derived", "temporal", "parametric"}, "SHOW_CRS", true),
    DATUM(Datum.class, "\"Datum\"", "DATUM_CODE", "DATUM_NAME", "DATUM_TYPE", new Class[]{DefaultDatumEnsemble.class, GeodeticDatum.class, VerticalDatum.class, EngineeringDatum.class, TemporalDatum.class, DefaultParametricDatum.class}, new String[]{"ensemble", "geodetic", "vertical", "engineering", "temporal", "parametric"}, null, true),
    CONVENTIONAL_RS(IdentifiedObject.class, "\"Conventional RS\"", "CONVENTIONAL_RS_CODE", "CONVENTIONAL_RS_NAME", null, null, null, null, false),
    ELLIPSOID(Ellipsoid.class, "\"Ellipsoid\"", "ELLIPSOID_CODE", "ELLIPSOID_NAME", null, null, null, null, false),
    PRIME_MERIDIAN(PrimeMeridian.class, "\"Prime Meridian\"", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME", null, null, null, null, false),
    OPERATION(CoordinateOperation.class, "\"Coordinate_Operation\"", "COORD_OP_CODE", "COORD_OP_NAME", "COORD_OP_TYPE", new Class[]{Conversion.class, Transformation.class}, new String[]{"conversion", "transformation"}, "SHOW_OPERATION", true),
    METHOD(OperationMethod.class, "\"Coordinate_Operation Method\"", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME", null, null, null, null, false),
    PARAMETER(ParameterDescriptor.class, "\"Coordinate_Operation Parameter\"", "PARAMETER_CODE", "PARAMETER_NAME", null, null, null, null, false),
    EXTENT(Extent.class, "\"Extent\"", "EXTENT_CODE", "EXTENT_NAME", null, null, null, null, false),
    CS(CoordinateSystem.class, "\"Coordinate System\"", "COORD_SYS_CODE", "COORD_SYS_NAME", "COORD_SYS_TYPE", new Class[]{CartesianCS.class, EllipsoidalCS.class, VerticalCS.class, LinearCS.class, SphericalCS.class, PolarCS.class, CylindricalCS.class, TimeCS.class, DefaultParametricCS.class, AffineCS.class}, new String[]{"Cartesian", "ellipsoidal", "vertical", "linear", "spherical", "polar", "cylindrical", "temporal", "parametric", "affine"}, null, false),
    AXIS(CoordinateSystemAxis.class, "\"Coordinate Axis\" AS CA INNER JOIN \"Coordinate Axis Name\" AS CAN ON CA.COORD_AXIS_NAME_CODE=CAN.COORD_AXIS_NAME_CODE", "COORD_AXIS_CODE", "COORD_AXIS_NAME", null, null, null, null, false),
    UNIT(Unit.class, "\"Unit of Measure\"", "UOM_CODE", "UNIT_OF_MEAS_NAME", null, null, null, null, false);

    private static final Map<String, String[]> SYNONYMOUS_TYPES;
    private static final Map<String, String> DYNAMIC_TYPES;
    final Class<?> type;
    final String table;
    final String fromClause;
    final String codeColumn;
    final String nameColumn;
    private final String typeColumn;
    private final Class<?>[] subTypes;
    private final String[] typeNames;
    final String showColumn;
    final boolean areaOfUse;

    private TableInfo(Class<?> type, String fromClause, String codeColumn, String nameColumn, String typeColumn, Class<?>[] subTypes, String[] typeNames, String showColumn, boolean areaOfUse) {
        this.type = type;
        this.fromClause = fromClause;
        this.codeColumn = codeColumn;
        this.nameColumn = nameColumn;
        this.typeColumn = typeColumn;
        this.subTypes = subTypes;
        this.typeNames = typeNames;
        this.showColumn = showColumn;
        this.areaOfUse = areaOfUse;
        int start = fromClause.indexOf(34) + 1;
        this.table = fromClause.substring(start, fromClause.indexOf(34, start)).intern();
    }

    final boolean isSpecificEnough() {
        return this.type != IdentifiedObject.class;
    }

    static Object toCacheKey(IdentifiedObject object) {
        CoordinateSystem cs;
        if (object instanceof GeodeticCRS && (cs = ((GeodeticCRS)object).getCoordinateSystem()) instanceof EllipsoidalCS) {
            return cs.getDimension();
        }
        return object.getClass();
    }

    static Class<?> typeOfCacheKey(Object object) {
        if (object instanceof Integer) {
            return GeographicCRS.class;
        }
        return (Class)object;
    }

    final Object appendWhere(EPSGDataAccess factory, Object object, StringBuilder buffer) {
        Class<Object> userType;
        int dimension;
        if (object instanceof Integer) {
            dimension = (Integer)object;
            userType = GeographicCRS.class;
        } else if (object instanceof Class) {
            userType = (Class<?>)object;
            dimension = 0;
        } else if (object instanceof GeodeticCRS) {
            CoordinateSystem cs = ((GeodeticCRS)object).getCoordinateSystem();
            if (cs instanceof EllipsoidalCS) {
                userType = GeographicCRS.class;
                dimension = cs.getDimension();
            } else {
                userType = cs instanceof CartesianCS || cs instanceof SphericalCS ? GeocentricCRS.class : object.getClass();
                dimension = 0;
            }
        } else {
            userType = object.getClass();
            dimension = 0;
        }
        buffer.append(" WHERE ");
        if (this.typeColumn != null) {
            for (int i = 0; i < this.subTypes.length; ++i) {
                String[] synonymous;
                Class<?> subType = this.subTypes[i];
                if (!subType.isAssignableFrom(userType)) continue;
                String typeName = this.typeNames[i];
                if (DefaultGeodeticDatum.Dynamic.class.isAssignableFrom(userType)) {
                    typeName = DYNAMIC_TYPES.getOrDefault(typeName, typeName);
                }
                if ((synonymous = SYNONYMOUS_TYPES.get(typeName)) != null && dimension > 0 && dimension <= 9) {
                    String suffix = "2D".replace('2', (char)(48 + dimension));
                    if (typeName.endsWith(suffix)) {
                        synonymous = null;
                    } else {
                        String[] stringArray = synonymous;
                        int n = stringArray.length;
                        for (int j = 0; j < n; ++j) {
                            String alternative = stringArray[j];
                            if (!alternative.endsWith(suffix)) continue;
                            typeName = alternative;
                            synonymous = null;
                            break;
                        }
                    }
                }
                buffer.append('(').append(this.typeColumn).append(" = '").append(typeName).append('\'');
                if (synonymous != null) {
                    for (String alternative : synonymous) {
                        buffer.append(" OR ").append(this.typeColumn).append(" = '").append(alternative).append('\'');
                    }
                }
                buffer.append(") AND ");
                return subType;
            }
        }
        return dimension != 0 ? Integer.valueOf(dimension) : this.type;
    }

    final boolean validate(String sql) {
        if (sql.contains(this.table)) {
            if (this.type.isAssignableFrom(IdentifiedObject.class)) {
                if (!sql.contains(this.codeColumn)) {
                    throw new AssertionError((Object)this.codeColumn);
                }
                if (!sql.contains(this.nameColumn)) {
                    throw new AssertionError((Object)this.nameColumn);
                }
            }
            return true;
        }
        return false;
    }

    static {
        SYNONYMOUS_TYPES = Map.of("geodetic", new String[]{"dynamic geodetic", "ensemble"}, "geographic 2D", new String[]{"geographic 3D"});
        DYNAMIC_TYPES = Map.of("geodetic", "dynamic geodetic");
    }
}

