/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Objects;
import java.util.Optional;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.Classes;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public abstract class MathTransformBuilder {
    protected final MathTransformFactory factory;
    protected OperationMethod provider;

    protected MathTransformBuilder(MathTransformFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public final Optional<OperationMethod> getMethod() {
        return Optional.ofNullable(this.provider);
    }

    public abstract ParameterValueGroup parameters();

    public void setSourceAxes(CoordinateSystem cs, Ellipsoid ellipsoid) {
    }

    public void setTargetAxes(CoordinateSystem cs, Ellipsoid ellipsoid) {
    }

    public abstract MathTransform create() throws FactoryException;

    protected MathTransform unique(MathTransform result) {
        if (this.factory instanceof DefaultMathTransformFactory) {
            DefaultMathTransformFactory df = (DefaultMathTransformFactory)this.factory;
            df.lastMethod.set(this.getMethod().orElse(null));
            result = df.unique(result);
        }
        return result;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"factory", Classes.getShortClassName((Object)this.factory), "method", IdentifiedObjects.getDisplayName((IdentifiedObject)this.provider, null)});
    }
}

