/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.property;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.shared.common.error.StandardException;

public class PropertyValidation
implements PropertyFactory {
    private Vector<PropertySetCallback> notifyOnSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable doValidateApplyAndMap(TransactionController transactionController, String string, Serializable serializable, Dictionary dictionary, boolean bl) throws StandardException {
        Serializable serializable2 = null;
        if (this.notifyOnSet != null) {
            PropertyValidation propertyValidation = this;
            synchronized (propertyValidation) {
                for (int i = 0; i < this.notifyOnSet.size(); ++i) {
                    Serviceable serviceable;
                    PropertySetCallback propertySetCallback = this.notifyOnSet.get(i);
                    if (!propertySetCallback.validate(string, serializable, dictionary)) continue;
                    if (serializable2 == null) {
                        serializable2 = propertySetCallback.map(string, serializable, dictionary);
                    }
                    if (!bl && string.startsWith("derby.") && PropertyUtil.whereSet(string, dictionary) == 0 || (serviceable = propertySetCallback.apply(string, serializable, dictionary)) == null) continue;
                    ((TransactionManager)transactionController).addPostCommitWork(serviceable);
                }
            }
        }
        return serializable2;
    }

    @Override
    public Serializable doMap(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        Serializable serializable2 = null;
        if (this.notifyOnSet != null) {
            for (int i = 0; i < this.notifyOnSet.size() && serializable2 == null; ++i) {
                PropertySetCallback propertySetCallback = this.notifyOnSet.get(i);
                serializable2 = propertySetCallback.map(string, serializable, dictionary);
            }
        }
        if (serializable2 == null) {
            return serializable;
        }
        return serializable2;
    }

    @Override
    public void validateSingleProperty(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (string.equals("logDevice")) {
            throw StandardException.newException((String)"XSRS8.S", (Object[])new Object[0]);
        }
        if (this.notifyOnSet != null) {
            for (int i = 0; i < this.notifyOnSet.size(); ++i) {
                PropertySetCallback propertySetCallback = this.notifyOnSet.get(i);
                propertySetCallback.validate(string, serializable, dictionary);
            }
        }
    }

    @Override
    public synchronized void addPropertySetNotification(PropertySetCallback propertySetCallback) {
        if (this.notifyOnSet == null) {
            this.notifyOnSet = new Vector(1, 1);
        }
        this.notifyOnSet.add(propertySetCallback);
    }

    @Override
    public synchronized void verifyPropertySet(Properties properties, Properties properties2) throws StandardException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (properties2.getProperty(string) != null) continue;
            String string2 = properties.getProperty(string);
            this.validateSingleProperty(string, (Serializable)((Object)string2), properties);
        }
    }
}

