/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Properties;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherFactoryBuilder;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.UndoHandler;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.iapi.store.replication.slave.SlaveFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.services.monitor.UpdateServiceProperties;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public final class RawStore
implements RawStoreFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction<Object> {
    private static final String BACKUP_HISTORY = "BACKUP.HISTORY";
    protected TransactionFactory xactFactory;
    protected DataFactory dataFactory;
    protected LogFactory logFactory;
    private SlaveFactory slaveFactory;
    private StorageFactory storageFactory;
    private SecureRandom random;
    private boolean isEncryptedDatabase;
    private CipherProvider encryptionEngine;
    private CipherProvider decryptionEngine;
    private CipherProvider newEncryptionEngine;
    private CipherProvider newDecryptionEngine;
    private CipherFactory currentCipherFactory;
    private CipherFactory newCipherFactory = null;
    private int counter_encrypt;
    private int counter_decrypt;
    private int encryptionBlockSize = 8;
    protected DaemonService rawStoreDaemon;
    private int actionCode;
    private static final int FILE_WRITER_ACTION = 1;
    private StorageFile actionStorageFile;
    private StorageFile actionToStorageFile;
    private boolean actionAppend;
    private static final int REGULAR_FILE_EXISTS_ACTION = 2;
    private File actionRegularFile;
    private static final int STORAGE_FILE_EXISTS_ACTION = 3;
    private static final int REGULAR_FILE_DELETE_ACTION = 4;
    private static final int REGULAR_FILE_MKDIRS_ACTION = 5;
    private static final int REGULAR_FILE_IS_DIRECTORY_ACTION = 6;
    private static final int REGULAR_FILE_REMOVE_DIRECTORY_ACTION = 7;
    private static final int REGULAR_FILE_RENAME_TO_ACTION = 8;
    private File actionRegularFile2;
    private static final int COPY_STORAGE_DIRECTORY_TO_REGULAR_ACTION = 9;
    private byte[] actionBuffer;
    private String[] actionFilter;
    private boolean actionCopySubDirs;
    private static final int COPY_REGULAR_DIRECTORY_TO_STORAGE_ACTION = 10;
    private static final int COPY_REGULAR_FILE_TO_STORAGE_ACTION = 11;
    private static final int REGULAR_FILE_LIST_DIRECTORY_ACTION = 12;
    private static final int STORAGE_FILE_LIST_DIRECTORY_ACTION = 13;
    private static final int COPY_STORAGE_FILE_TO_REGULAR_ACTION = 14;
    private static final int REGULAR_FILE_GET_CANONICALPATH_ACTION = 15;
    private static final int STORAGE_FILE_GET_CANONICALPATH_ACTION = 16;
    private static final int COPY_STORAGE_FILE_TO_STORAGE_ACTION = 17;
    private static final int STORAGE_FILE_DELETE_ACTION = 18;
    private static final int README_FILE_OUTPUTSTREAM_WRITER_ACTION = 19;
    public static final String TEST_REENCRYPT_CRASH_BEFORE_COMMT = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_COMMT = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE = null;
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY = null;
    public static final String TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP = null;

    @Override
    public boolean canSupport(Properties properties) {
        return true;
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        String string;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = properties.getProperty("replication.slave.mode");
        if (string2 != null && string2.equals("slavemode")) {
            bl3 = true;
        }
        DaemonFactory daemonFactory = (DaemonFactory)RawStore.startSystemModule("org.apache.derby.iapi.services.daemon.DaemonFactory");
        this.rawStoreDaemon = daemonFactory.createNewDaemon("rawStoreDaemon");
        this.xactFactory = (TransactionFactory)RawStore.bootServiceModule(bl, this, this.getTransactionFactoryModule(), properties);
        this.dataFactory = (DataFactory)RawStore.bootServiceModule(bl, this, this.getDataFactoryModule(), properties);
        this.storageFactory = this.dataFactory.getStorageFactory();
        String string3 = null;
        if (properties != null) {
            string3 = properties.getProperty("createFrom");
            if (string3 == null) {
                string3 = properties.getProperty("restoreFrom");
            }
            if (string3 == null) {
                string3 = properties.getProperty("rollForwardRecoveryFrom");
            }
        }
        if (bl) {
            bl2 = this.setupEncryptionEngines(bl, properties);
        }
        this.dataFactory.setRawStoreFactory(this, bl, properties);
        this.xactFactory.setRawStoreFactory(this);
        if (properties instanceof UpdateServiceProperties && this.storageFactory instanceof WritableStorageFactory) {
            ((UpdateServiceProperties)properties).setStorageFactory((WritableStorageFactory)this.storageFactory);
        }
        this.logFactory = (LogFactory)RawStore.findServiceModule(this, this.getLogFactoryModule());
        if (string3 != null) {
            this.restoreRemainingFromBackup(string3);
        }
        if ((string = properties.getProperty("logDevice")) != null) {
            if (!(this.isReadOnly() || !bl && string.equals(this.logFactory.getCanonicalLogPath()) && string3 == null)) {
                properties.put("logDevice", this.logFactory.getCanonicalLogPath());
                properties.put("derby.storage.logDeviceWhenBackedUp", this.logFactory.getCanonicalLogPath());
            }
        } else if (string3 != null && this.logFactory.getCanonicalLogPath() != null) {
            properties.put("logDevice", this.logFactory.getCanonicalLogPath());
        } else {
            properties.remove("derby.storage.logDeviceWhenBackedUp");
        }
        if (string3 != null) {
            ((UpdateServiceProperties)properties).saveServiceProperties();
        }
        if (!bl) {
            if (properties.getProperty("derby.storage.databaseEncryptionStatus") != null) {
                this.handleIncompleteDbCryptoOperation(properties);
            }
            bl2 = this.setupEncryptionEngines(bl, properties);
        }
        if (this.isEncryptedDatabase) {
            this.logFactory.setDatabaseEncrypted(true, false);
            this.dataFactory.setDatabaseEncrypted(true);
        }
        this.logFactory.setRawStoreFactory(this);
        if (bl3) {
            this.slaveFactory = (SlaveFactory)RawStore.bootServiceModule(bl, this, this.getSlaveFactoryModule(), properties);
            this.slaveFactory.startSlave(this, this.logFactory);
        }
        this.logFactory.recover(this.dataFactory, this.xactFactory);
        if (bl2) {
            this.applyBulkCryptoOperation(properties, this.newCipherFactory);
        }
    }

    @Override
    public void stop() {
        if (this.rawStoreDaemon != null) {
            this.rawStoreDaemon.stop();
        }
        if (this.logFactory == null) {
            return;
        }
        try {
            if (this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, false) && this.dataFactory != null) {
                this.dataFactory.removeStubsOK();
            }
        }
        catch (StandardException standardException) {
            this.markCorrupt(standardException);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.dataFactory.isReadOnly();
    }

    @Override
    public LockFactory getLockFactory() {
        return this.xactFactory.getLockFactory();
    }

    @Override
    public TransactionFactory getXactFactory() {
        return this.xactFactory;
    }

    @Override
    public void setUndoInsertEventHandler(UndoHandler undoHandler) throws StandardException {
        this.dataFactory.setUndoInsertEventHandler(undoHandler);
    }

    @Override
    public Object getXAResourceManager() throws StandardException {
        return this.xactFactory.getXAResourceManager();
    }

    @Override
    public Transaction startGlobalTransaction(ContextManager contextManager, int n, byte[] byArray, byte[] byArray2) throws StandardException {
        return this.xactFactory.startGlobalTransaction(this, contextManager, n, byArray, byArray2);
    }

    @Override
    public Transaction startTransaction(ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.startTransaction(this, contextManager, string);
    }

    @Override
    public Transaction startNestedReadOnlyUserTransaction(Transaction transaction, CompatibilitySpace compatibilitySpace, ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.startNestedReadOnlyUserTransaction(this, (RawTransaction)transaction, compatibilitySpace, contextManager, string);
    }

    @Override
    public Transaction startNestedUpdateUserTransaction(Transaction transaction, ContextManager contextManager, String string, boolean bl) throws StandardException {
        return this.xactFactory.startNestedUpdateUserTransaction(this, (RawTransaction)transaction, contextManager, string, bl);
    }

    @Override
    public Transaction findUserTransaction(ContextManager contextManager, String string) throws StandardException {
        return this.xactFactory.findUserTransaction(this, contextManager, string);
    }

    @Override
    public Transaction startInternalTransaction(ContextManager contextManager) throws StandardException {
        return this.xactFactory.startInternalTransaction(this, contextManager);
    }

    @Override
    public void checkpoint() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
    }

    @Override
    public void startReplicationMaster(String string, String string2, int n, String string3) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException((String)"XRE00", (Object[])new Object[0]);
        }
        RawTransaction rawTransaction = this.xactFactory.findUserTransaction(this, RawStore.getContextService().getCurrentContextManager(), "UserTransaction");
        if (rawTransaction.isBlockingBackup()) {
            throw StandardException.newException((String)"XRE23", (Object[])new Object[0]);
        }
        Properties properties = new Properties();
        properties.setProperty("derby.__rt.replication.master.mode", string3);
        MasterFactory masterFactory = (MasterFactory)RawStore.bootServiceModule(true, this, this.getMasterFactoryModule(), properties);
        masterFactory.startMaster(this, this.dataFactory, this.logFactory, string2, n, string);
    }

    @Override
    public void stopReplicationMaster() throws StandardException {
        MasterFactory masterFactory = null;
        if (this.isReadOnly()) {
            throw StandardException.newException((String)"XRE00", (Object[])new Object[0]);
        }
        try {
            masterFactory = (MasterFactory)RawStore.findServiceModule(this, this.getMasterFactoryModule());
        }
        catch (StandardException standardException) {
            throw StandardException.newException((String)"XRE07", (Object[])new Object[0]);
        }
        masterFactory.stopMaster();
    }

    @Override
    public void failover(String string) throws StandardException {
        MasterFactory masterFactory = null;
        if (this.isReadOnly()) {
            throw StandardException.newException((String)"XRE00", (Object[])new Object[0]);
        }
        try {
            masterFactory = (MasterFactory)RawStore.findServiceModule(this, this.getMasterFactoryModule());
        }
        catch (StandardException standardException) {
            throw StandardException.newException((String)"XRE07", (Object[])new Object[0]);
        }
        masterFactory.startFailover();
    }

    @Override
    public void freeze() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.dataFactory.freezePersistentStore();
        this.logFactory.freezePersistentStore();
    }

    @Override
    public void unfreeze() throws StandardException {
        this.logFactory.unfreezePersistentStore();
        this.dataFactory.unfreezePersistentStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backup(String string, boolean bl) throws StandardException {
        Object object;
        if (string == null || string.equals("")) {
            throw StandardException.newException((String)"XSRS6.S", (Object[])new Object[]{null});
        }
        String string2 = null;
        try {
            object = new URL(string);
            string2 = ((URL)object).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2 != null) {
            string = string2;
        }
        object = this.xactFactory.findUserTransaction(this, RawStore.getContextService().getCurrentContextManager(), "UserTransaction");
        try {
            if (((RawTransaction)object).isBlockingBackup()) {
                throw StandardException.newException((String)"XSRSB.S", (Object[])new Object[0]);
            }
            if (!this.xactFactory.blockBackupBlockingOperations(bl)) {
                throw StandardException.newException((String)"XSRSA.S", (Object[])new Object[0]);
            }
            this.backup((Transaction)object, new File(string));
        }
        finally {
            this.xactFactory.unblockBackupBlockingOperations();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void backup(Transaction transaction, File file) throws StandardException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!this.privExists(file)) {
            this.createBackupDirectory(file);
        } else {
            if (!this.privIsDirectory(file)) {
                throw StandardException.newException((String)"XSRS1.S", (Object[])new Object[]{file});
            }
            if (this.privExists(new File(file, "service.properties"))) {
                throw StandardException.newException((String)"XSRSC.S", (Object[])new Object[]{file});
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        File file2 = null;
        File file3 = null;
        OutputStreamWriter outputStreamWriter = null;
        StorageFile storageFile2 = null;
        File file4 = null;
        LogInstant logInstant = this.logFactory.getFirstUnflushedInstant();
        try {
            StorageFile storageFile;
            StorageFile storageFile3 = this.storageFactory.newStorageFile(null);
            String string = this.storageFactory.getCanonicalName();
            String string2 = StringUtil.shortDBName(string, this.storageFactory.getSeparator());
            outputStreamWriter = this.privFileWriter(this.storageFactory.newStorageFile(BACKUP_HISTORY), true);
            file3 = new File(file, string2);
            this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D004", (Object[])new Object[]{string, this.getFilePath(file3)}));
            if (this.privExists(file3)) {
                file2 = new File(file, string2 + ".OLD");
                if (this.privExists(file2)) {
                    if (this.privIsDirectory(file2)) {
                        this.privRemoveDirectory(file2);
                    } else {
                        this.privDelete(file2);
                    }
                }
                if (!this.privRenameTo(file3, file2)) {
                    bl3 = true;
                    throw StandardException.newException((String)"XSRS4.S", (Object[])new Object[]{file3, file2});
                }
                this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D005", (Object[])new Object[]{this.getFilePath(file3), this.getFilePath(file2)}));
                bl2 = true;
            }
            this.createBackupDirectory(file3);
            storageFile2 = this.storageFactory.newStorageFile(BACKUP_HISTORY);
            file4 = new File(file3, BACKUP_HISTORY);
            if (!this.privCopyFile(storageFile2, file4)) {
                throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile2, file4});
            }
            StorageFile storageFile4 = this.storageFactory.newStorageFile("jar");
            if (this.privExists(storageFile4)) {
                int n;
                object4 = this.privList(storageFile4);
                object3 = new File(file3, "jar");
                this.createBackupDirectory((File)object3);
                object2 = (LanguageConnectionContext)RawStore.getContextOrNull("LanguageConnectionContext");
                boolean bl4 = object2.getDataDictionary().checkVersion(210, null);
                if (bl4) {
                    for (n = 0; n < ((String[])object4).length; ++n) {
                        storageFile = this.storageFactory.newStorageFile(storageFile4, (String)object4[n]);
                        File file5 = new File((File)object3, (String)object4[n]);
                        if (this.privIsDirectory(new File(storageFile.getPath())) || this.privCopyFile(storageFile, file5)) continue;
                        throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile, file5});
                    }
                } else {
                    for (n = 0; n < ((String[])object4).length; ++n) {
                        File file6;
                        storageFile = this.storageFactory.newStorageFile(storageFile4, (String)object4[n]);
                        if (this.privCopyDirectory(storageFile, file6 = new File((File)object3, (String)object4[n]), null, null, false)) continue;
                        throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile, file6});
                    }
                }
            }
            object4 = this.logFactory.getLogDirectory();
            try {
                object3 = RawStore.getServiceName(this);
                object2 = RawStore.getMonitor().getServiceType(this);
                object = object2.getCanonicalServiceName((String)object3);
                Properties properties = object2.getServiceProperties((String)object, null);
                storageFile = this.storageFactory.newStorageFile("log");
                if (!object4.equals(storageFile)) {
                    properties.remove("logDevice");
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D007", (Object[])new Object[0]));
                }
                object2.saveServiceProperties(file3.getPath(), properties);
            }
            catch (StandardException standardException) {
                this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D008", (Object[])new Object[0]) + standardException);
                try {
                    if (bl) {
                        this.logFactory.abortLogBackup();
                        if (!bl3) {
                            this.privRemoveDirectory(file3);
                        }
                        if (bl2) {
                            this.privRenameTo(file2, file3);
                        }
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D010", (Object[])new Object[0]));
                    } else {
                        if (bl2 && this.privExists(file2)) {
                            this.privRemoveDirectory(file2);
                            this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D011", (Object[])new Object[]{this.getFilePath(file2)}));
                        }
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D012", (Object[])new Object[]{logInstant}));
                        if (!this.privCopyFile(storageFile2, file4)) {
                            throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile2, file4});
                        }
                    }
                    outputStreamWriter.close();
                    return;
                }
                catch (IOException iOException) {
                    try {
                        outputStreamWriter.close();
                        throw StandardException.newException((String)"XSRS7.S", (Throwable)iOException, (Object[])new Object[0]);
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    throw StandardException.newException((String)"XSRS7.S", (Throwable)iOException, (Object[])new Object[0]);
                }
            }
        }
        catch (IOException iOException) {
            try {
                throw StandardException.newException((String)"XSRS7.S", (Throwable)iOException, (Object[])new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (bl) {
                        this.logFactory.abortLogBackup();
                        if (!bl3) {
                            this.privRemoveDirectory(file3);
                        }
                        if (bl2) {
                            this.privRenameTo(file2, file3);
                        }
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D010", (Object[])new Object[0]));
                    } else {
                        if (bl2 && this.privExists(file2)) {
                            this.privRemoveDirectory(file2);
                            this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D011", (Object[])new Object[]{this.getFilePath(file2)}));
                        }
                        this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D012", (Object[])new Object[]{logInstant}));
                        if (!this.privCopyFile(storageFile2, file4)) {
                            throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile2, file4});
                        }
                    }
                    outputStreamWriter.close();
                    throw throwable;
                }
                catch (IOException iOException4) {
                    try {
                        outputStreamWriter.close();
                        throw StandardException.newException((String)"XSRS7.S", (Throwable)iOException4, (Object[])new Object[0]);
                    }
                    catch (IOException iOException5) {
                        // empty catch block
                    }
                    throw StandardException.newException((String)"XSRS7.S", (Throwable)iOException4, (Object[])new Object[0]);
                }
            }
        }
        {
            object3 = this.storageFactory.newStorageFile("verifyKey.dat");
            if (this.privExists((StorageFile)object3) && !this.privCopyFile((StorageFile)object3, (File)(object2 = new File(file3, "verifyKey.dat")))) {
                throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{object3, object2});
            }
            object2 = new File(file3, "log");
            if (this.privExists((File)object2)) {
                this.privRemoveDirectory((File)object2);
            }
            this.createBackupDirectory((File)object2);
            this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
            this.logFactory.startLogBackup((File)object2);
            object = new File(file3, "seg0");
            this.createBackupDirectory((File)object);
            this.dataFactory.backupDataFiles(transaction, (File)object);
            this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D006", (Object[])new Object[]{this.getFilePath((File)object)}));
            this.logFactory.endLogBackup((File)object2);
            this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D009", (Object[])new Object[]{this.getFilePath((StorageFile)object4), this.getFilePath((File)object2)}));
            bl = false;
        }
        try {
            if (bl) {
                this.logFactory.abortLogBackup();
                if (!bl3) {
                    this.privRemoveDirectory(file3);
                }
                if (bl2) {
                    this.privRenameTo(file2, file3);
                }
                this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D010", (Object[])new Object[0]));
            } else {
                if (bl2 && this.privExists(file2)) {
                    this.privRemoveDirectory(file2);
                    this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D011", (Object[])new Object[]{this.getFilePath(file2)}));
                }
                this.logHistory(outputStreamWriter, MessageService.getTextMessage((String)"D012", (Object[])new Object[]{logInstant}));
                if (!this.privCopyFile(storageFile2, file4)) {
                    throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile2, file4});
                }
            }
            outputStreamWriter.close();
            return;
        }
        catch (IOException iOException) {
            try {
                outputStreamWriter.close();
                throw StandardException.newException((String)"XSRS7.S", (Throwable)iOException, (Object[])new Object[0]);
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            throw StandardException.newException((String)"XSRS7.S", (Throwable)iOException, (Object[])new Object[0]);
        }
    }

    private void createBackupDirectory(File file) throws StandardException {
        boolean bl = false;
        IOException iOException = null;
        try {
            bl = this.privMkdirs(file);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (!bl) {
            throw StandardException.newException((String)"XSRS6.S", (Throwable)iOException, (Object[])new Object[]{file});
        }
    }

    @Override
    public void backupAndEnableLogArchiveMode(String string, boolean bl, boolean bl2) throws StandardException {
        boolean bl3 = false;
        try {
            if (!this.logFactory.logArchived()) {
                this.logFactory.enableLogArchiveMode();
                bl3 = true;
            }
            this.backup(string, bl2);
            if (bl) {
                this.logFactory.deleteOnlineArchivedLogFiles();
            }
        }
        catch (Throwable throwable) {
            if (bl3) {
                this.logFactory.disableLogArchiveMode();
            }
            throw StandardException.plainWrapException((Throwable)throwable);
        }
    }

    @Override
    public void disableLogArchiveMode(boolean bl) throws StandardException {
        this.logFactory.disableLogArchiveMode();
        if (bl) {
            this.logFactory.deleteOnlineArchivedLogFiles();
        }
    }

    private void restoreRemainingFromBackup(String string) throws StandardException {
        File file = new File(string, "jar");
        StorageFile storageFile = this.storageFactory.newStorageFile("jar");
        if (!this.privExists(storageFile) && this.privExists(file) && !this.privCopyDirectory(file, storageFile)) {
            throw StandardException.newException((String)"XBM0Z.D", (Object[])new Object[]{file, storageFile});
        }
        StorageFile storageFile2 = this.storageFactory.newStorageFile(BACKUP_HISTORY);
        File file2 = new File(string, BACKUP_HISTORY);
        if (this.privExists(file2) && !this.privExists(storageFile2) && !this.privCopyFile(file2, storageFile2)) {
            throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{file2, storageFile2});
        }
    }

    @Override
    public void idle() throws StandardException {
        this.dataFactory.idle();
    }

    @Override
    public TransactionInfo[] getTransactionInfo() {
        return this.xactFactory.getTransactionInfo();
    }

    @Override
    public ScanHandle openFlushedScan(DatabaseInstant databaseInstant, int n) throws StandardException {
        return this.logFactory.openFlushedScan(databaseInstant, n);
    }

    @Override
    public DaemonService getDaemon() {
        return this.rawStoreDaemon;
    }

    @Override
    public void createFinished() throws StandardException {
        this.xactFactory.createFinished();
        this.dataFactory.createFinished();
    }

    @Override
    public void getRawStoreProperties(PersistentSet persistentSet) throws StandardException {
        this.logFactory.getLogFactoryProperties(persistentSet);
    }

    @Override
    public void freezePersistentStore() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.logFactory.freezePersistentStore();
    }

    @Override
    public void unfreezePersistentStore() throws StandardException {
        this.logFactory.unfreezePersistentStore();
    }

    private boolean setupEncryptionEngines(boolean bl, Properties properties) throws StandardException {
        Object object;
        boolean bl2 = RawStore.isTrue(properties, "decryptDatabase");
        boolean bl3 = RawStore.isTrue(properties, "dataEncryption");
        boolean bl4 = false;
        if (!bl) {
            String string = RawStore.getServiceName(this);
            object = RawStore.getMonitor().getServiceType(this);
            String string2 = object.getCanonicalServiceName(string);
            Properties properties2 = object.getServiceProperties(string2, null);
            this.isEncryptedDatabase = RawStore.isTrue(properties2, "dataEncryption");
            if (this.isEncryptedDatabase) {
                bl3 = bl4 = RawStore.isSet(properties, "newBootPassword") || RawStore.isSet(properties, "newEncryptionKey");
            } else if (bl3 && bl2) {
                throw StandardException.newException((String)"XJ048.C", (Object[])new Object[]{"decryptDatabase, dataEncryption"});
            }
            if ((bl3 || bl2) && this.isReadOnly()) {
                throw StandardException.newException((String)"XBCXQ.S", (Object[])new Object[0]);
            }
        }
        if (this.isEncryptedDatabase || bl3) {
            boolean bl5 = bl || bl3 && !bl4;
            object = (CipherFactoryBuilder)RawStore.startSystemModule("org.apache.derby.iapi.services.crypto.CipherFactoryBuilder");
            this.currentCipherFactory = object.createCipherFactory(bl5, properties, false);
            this.currentCipherFactory.verifyKey(bl5, this.storageFactory, properties);
            this.encryptionEngine = this.currentCipherFactory.createNewCipher(1);
            if (bl5) {
                this.encryptionBlockSize = this.encryptionEngine.getEncryptionBlockSize();
                if (bl) {
                    properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
                }
            } else {
                this.encryptionBlockSize = RawStore.isSet(properties, "derby.encryptionBlockSize") ? Integer.parseInt(properties.getProperty("derby.encryptionBlockSize")) : this.encryptionEngine.getEncryptionBlockSize();
            }
            this.decryptionEngine = this.currentCipherFactory.createNewCipher(2);
            this.random = this.currentCipherFactory.getSecureRandom();
            if (bl3) {
                if (bl4) {
                    this.newCipherFactory = object.createCipherFactory(bl5, properties, true);
                    this.newDecryptionEngine = this.newCipherFactory.createNewCipher(2);
                    this.newEncryptionEngine = this.newCipherFactory.createNewCipher(1);
                } else {
                    this.newDecryptionEngine = this.decryptionEngine;
                    this.newEncryptionEngine = this.encryptionEngine;
                }
            }
            if (bl) {
                this.currentCipherFactory.saveProperties(properties);
                this.isEncryptedDatabase = true;
            }
        }
        return !bl && (bl3 || this.isEncryptedDatabase && bl2);
    }

    @Override
    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws StandardException {
        if (this.encryptionEngine == null && this.newEncryptionEngine == null) {
            throw StandardException.newException((String)"XSAI3.S", (Object[])new Object[0]);
        }
        ++this.counter_encrypt;
        if (bl) {
            return this.newEncryptionEngine.encrypt(byArray, n, n2, byArray2, n3);
        }
        return this.encryptionEngine.encrypt(byArray, n, n2, byArray2, n3);
    }

    @Override
    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        if (!this.isEncryptedDatabase || this.decryptionEngine == null) {
            throw StandardException.newException((String)"XSAI3.S", (Object[])new Object[0]);
        }
        ++this.counter_decrypt;
        return this.decryptionEngine.decrypt(byArray, n, n2, byArray2, n3);
    }

    @Override
    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }

    @Override
    public int random() {
        return this.isEncryptedDatabase ? this.random.nextInt() : 0;
    }

    @Override
    public Serializable changeBootPassword(Properties properties, Serializable serializable) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException((String)"XBCX9.S", (Object[])new Object[0]);
        }
        if (!this.isEncryptedDatabase) {
            throw StandardException.newException((String)"XBCX8.S", (Object[])new Object[0]);
        }
        if (serializable == null) {
            throw StandardException.newException((String)"XBCX5.S", (Object[])new Object[0]);
        }
        if (!(serializable instanceof String)) {
            throw StandardException.newException((String)"XBCX6.S", (Object[])new Object[0]);
        }
        String string = (String)((Object)serializable);
        return this.currentCipherFactory.changeBootPassword((String)((Object)serializable), properties, this.encryptionEngine);
    }

    private void crashOnDebugFlag(String string, boolean bl) throws StandardException {
    }

    private void applyBulkCryptoOperation(Properties properties, CipherFactory cipherFactory) throws StandardException {
        boolean bl = this.isEncryptedDatabase && RawStore.isTrue(properties, "decryptDatabase");
        boolean bl2 = this.isEncryptedDatabase && (RawStore.isSet(properties, "newBootPassword") || RawStore.isSet(properties, "newEncryptionKey"));
        this.cryptoOperationAllowed(bl2, bl);
        boolean bl3 = RawStore.isSet(properties, "encryptionKey");
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        RawTransaction rawTransaction = this.xactFactory.startTransaction(this, RawStore.getContextService().getCurrentContextManager(), "UserTransaction");
        try {
            Object object;
            if (bl) {
                this.dataFactory.decryptAllContainers(rawTransaction);
            } else {
                this.dataFactory.encryptAllContainers(rawTransaction);
            }
            if (!this.logFactory.isCheckpointInLastLogFile()) {
                this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
            }
            if (bl) {
                this.isEncryptedDatabase = false;
                this.logFactory.setDatabaseEncrypted(false, true);
                this.dataFactory.setDatabaseEncrypted(false);
            } else {
                this.logFactory.setDatabaseEncrypted(true, true);
                if (bl2) {
                    this.decryptionEngine = this.newDecryptionEngine;
                    this.encryptionEngine = this.newEncryptionEngine;
                    this.currentCipherFactory = cipherFactory;
                } else {
                    this.isEncryptedDatabase = true;
                    this.dataFactory.setDatabaseEncrypted(true);
                }
            }
            this.logFactory.startNewLogFile();
            properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(1));
            if (bl2) {
                if (bl3) {
                    StorageFile storageFile;
                    object = this.storageFactory.newStorageFile("verifyKey.dat");
                    if (!this.privCopyFile((StorageFile)object, storageFile = this.storageFactory.newStorageFile("verifyOldKey.dat"))) {
                        throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{object, storageFile});
                    }
                    this.currentCipherFactory.verifyKey(bl2, this.storageFactory, properties);
                } else {
                    object = properties.getProperty("encryptedBootPassword");
                    if (object != null) {
                        properties.put("OldEncryptedBootPassword", object);
                    }
                }
            } else if (bl) {
                properties.put("dataEncryption", "false");
            } else {
                properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
            }
            this.currentCipherFactory.saveProperties(properties);
            rawTransaction.commit();
            this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
            properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(3));
            this.dataFactory.removeOldVersionOfContainers();
            if (bl) {
                this.removeCryptoProperties(properties);
            } else if (bl2) {
                if (bl3) {
                    object = this.storageFactory.newStorageFile("verifyOldKey.dat");
                    if (!this.privDelete((StorageFile)object)) {
                        throw StandardException.newException((String)"XBM0R.D", (Object[])new Object[]{object});
                    }
                } else {
                    properties.remove("OldEncryptedBootPassword");
                }
            }
            properties.remove("derby.storage.databaseEncryptionStatus");
            rawTransaction.close();
        }
        catch (StandardException standardException) {
            throw StandardException.newException((String)"XBCXU.S", (Throwable)standardException, (Object[])new Object[]{standardException.getMessage()});
        }
        finally {
            this.newDecryptionEngine = null;
            this.newEncryptionEngine = null;
        }
    }

    public void handleIncompleteDbCryptoOperation(Properties properties) throws StandardException {
        StorageFile storageFile;
        boolean bl;
        int n = 0;
        String string = properties.getProperty("derby.storage.databaseEncryptionStatus");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        boolean bl2 = false;
        boolean bl3 = bl = RawStore.isSet(properties, "dataEncryption") && !RawStore.isTrue(properties, "dataEncryption");
        if (n == 1) {
            if (this.logFactory.isCheckpointInLastLogFile()) {
                n = 3;
            } else {
                n = 2;
                properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(n));
            }
        }
        if (n == 2) {
            this.logFactory.deleteLogFileAfterCheckpointLogFile();
            storageFile = this.storageFactory.newStorageFile("verifyKey.dat");
            if (this.privExists(storageFile)) {
                StorageFile storageFile2 = this.storageFactory.newStorageFile("verifyOldKey.dat");
                if (this.privExists(storageFile2)) {
                    if (!this.privCopyFile(storageFile2, storageFile)) {
                        throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile2, storageFile});
                    }
                    bl2 = true;
                } else if (!bl && !this.privDelete(storageFile)) {
                    throw StandardException.newException((String)"XBM0R.D", (Object[])new Object[]{storageFile});
                }
            } else {
                String string2 = properties.getProperty("OldEncryptedBootPassword");
                if (string2 != null) {
                    properties.put("encryptedBootPassword", string2);
                    bl2 = true;
                }
            }
            if (!bl && !bl2) {
                this.removeCryptoProperties(properties);
            }
        }
        if (n == 3) {
            this.dataFactory.removeOldVersionOfContainers();
        }
        if (this.privExists(storageFile = this.storageFactory.newStorageFile("verifyOldKey.dat"))) {
            if (!this.privDelete(storageFile)) {
                throw StandardException.newException((String)"XBM0R.D", (Object[])new Object[]{storageFile});
            }
        } else {
            properties.remove("OldEncryptedBootPassword");
        }
        if (bl) {
            if (n == 2) {
                properties.setProperty("dataEncryption", "true");
            } else {
                this.removeCryptoProperties(properties);
            }
        }
        properties.remove("derby.storage.databaseEncryptionStatus");
    }

    private void cryptoOperationAllowed(boolean bl, boolean bl2) throws StandardException {
        String string = bl2 ? "decryptDatabase attribute" : (bl ? "newBootPassword/newEncryptionKey attribute" : "dataEncryption attribute on an existing database");
        int n = bl2 ? 10 : 2;
        this.logFactory.checkVersion(10, n, string);
        if (this.xactFactory.hasPreparedXact()) {
            throw StandardException.newException((String)"XBCXO.S", (Object[])new Object[0]);
        }
        if (this.logFactory.logArchived()) {
            throw StandardException.newException((String)"XBCXS.S", (Object[])new Object[0]);
        }
    }

    @Override
    public StandardException markCorrupt(StandardException standardException) {
        this.logFactory.markCorrupt(standardException);
        this.dataFactory.markCorrupt(standardException);
        this.xactFactory.markCorrupt(standardException);
        return standardException;
    }

    @Override
    public String getTransactionFactoryModule() {
        return "org.apache.derby.iapi.store.raw.xact.TransactionFactory";
    }

    public String getSlaveFactoryModule() {
        return "org.apache.derby.iapi.store.replication.slave.SlaveFactory";
    }

    public String getMasterFactoryModule() {
        return "org.apache.derby.iapi.store.replication.master.MasterFactory";
    }

    @Override
    public String getDataFactoryModule() {
        return "org.apache.derby.iapi.store.raw.data.DataFactory";
    }

    @Override
    public String getLogFactoryModule() {
        return "org.apache.derby.iapi.store.raw.log.LogFactory";
    }

    private void logHistory(OutputStreamWriter outputStreamWriter, String string) throws IOException {
        Date date = new Date();
        outputStreamWriter.write(date.toString() + ":" + string + "\n");
        outputStreamWriter.flush();
    }

    private String getFilePath(StorageFile storageFile) {
        String string = this.privGetCanonicalPath(storageFile);
        if (string != null) {
            return string;
        }
        return storageFile.getPath();
    }

    private String getFilePath(File file) {
        String string = this.privGetCanonicalPath(file);
        if (string != null) {
            return string;
        }
        return file.getPath();
    }

    protected boolean privCopyDirectory(StorageFile storageFile, File file) throws StandardException {
        return this.privCopyDirectory(storageFile, file, null, null, true);
    }

    protected boolean privCopyDirectory(File file, StorageFile storageFile) {
        return this.privCopyDirectory(file, storageFile, null, null);
    }

    @Override
    public long getMaxContainerId() throws StandardException {
        return this.dataFactory.getMaxContainerId();
    }

    @Override
    public boolean checkVersion(int n, int n2, String string) throws StandardException {
        return this.logFactory.checkVersion(n, n2, string);
    }

    private void removeCryptoProperties(Properties properties) {
        properties.remove("dataEncryption");
        properties.remove("log_encrypt_algorithm_version");
        properties.remove("data_encrypt_algorithm_version");
        properties.remove("derby.encryptionBlockSize");
        properties.remove("encryptionKeyLength");
        properties.remove("encryptionProvider");
        properties.remove("encryptionAlgorithm");
        properties.remove("encryptedBootPassword");
    }

    private synchronized OutputStreamWriter privFileWriter(StorageFile storageFile, boolean bl) throws IOException {
        this.actionCode = 1;
        this.actionStorageFile = storageFile;
        this.actionAppend = bl;
        try {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)AccessController.doPrivileged(this);
            return outputStreamWriter;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(File file) {
        this.actionCode = 2;
        this.actionRegularFile = file;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(StorageFile storageFile) {
        this.actionCode = 3;
        this.actionStorageFile = storageFile;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized OutputStreamWriter privGetOutputStreamWriter(StorageFile storageFile) throws IOException {
        this.actionCode = 19;
        this.actionStorageFile = storageFile;
        try {
            return (OutputStreamWriter)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(File file) {
        this.actionCode = 4;
        this.actionRegularFile = file;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(StorageFile storageFile) {
        this.actionCode = 18;
        this.actionStorageFile = storageFile;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized boolean privMkdirs(File file) throws IOException {
        this.actionCode = 5;
        this.actionRegularFile = file;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privIsDirectory(File file) {
        this.actionCode = 6;
        this.actionRegularFile = file;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRemoveDirectory(File file) {
        this.actionCode = 7;
        this.actionRegularFile = file;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRenameTo(File file, File file2) {
        this.actionCode = 8;
        this.actionRegularFile = file;
        this.actionRegularFile2 = file2;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionRegularFile = null;
            this.actionRegularFile2 = null;
        }
    }

    private synchronized boolean privCopyDirectory(StorageFile storageFile, File file, byte[] byArray, String[] stringArray, boolean bl) throws StandardException {
        this.actionCode = 9;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        this.actionBuffer = byArray;
        this.actionFilter = stringArray;
        this.actionCopySubDirs = bl;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl2 = (Boolean)object;
            return bl2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getCause();
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyDirectory(File file, StorageFile storageFile, byte[] byArray, String[] stringArray) {
        this.actionCode = 10;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        this.actionBuffer = byArray;
        this.actionFilter = stringArray;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(File file, StorageFile storageFile) {
        this.actionCode = 11;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
        }
    }

    private synchronized boolean privCopyFile(StorageFile storageFile, File file) throws StandardException {
        this.actionCode = 14;
        this.actionStorageFile = storageFile;
        this.actionRegularFile = file;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getCause();
        }
        finally {
            this.actionStorageFile = null;
            this.actionRegularFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(StorageFile storageFile, StorageFile storageFile2) {
        this.actionCode = 17;
        this.actionStorageFile = storageFile;
        this.actionToStorageFile = storageFile2;
        try {
            Object object = AccessController.doPrivileged(this);
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
            this.actionToStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] privList(StorageFile storageFile) {
        this.actionCode = 13;
        this.actionStorageFile = storageFile;
        try {
            String[] stringArray = (String[])AccessController.doPrivileged(this);
            return stringArray;
        }
        catch (PrivilegedActionException privilegedActionException) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String privGetCanonicalPath(StorageFile storageFile) {
        this.actionCode = 16;
        this.actionStorageFile = storageFile;
        try {
            String string = (String)AccessController.doPrivileged(this);
            return string;
        }
        catch (PrivilegedActionException privilegedActionException) {
            String string = null;
            return string;
        }
        catch (SecurityException securityException) {
            String string = null;
            return string;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String privGetCanonicalPath(File file) {
        this.actionCode = 15;
        this.actionRegularFile = file;
        try {
            String string = (String)AccessController.doPrivileged(this);
            return string;
        }
        catch (PrivilegedActionException privilegedActionException) {
            String string = null;
            return string;
        }
        catch (SecurityException securityException) {
            String string = null;
            return string;
        }
        finally {
            this.actionRegularFile = null;
        }
    }

    @Override
    public final Object run() throws IOException, StandardException {
        switch (this.actionCode) {
            case 1: {
                return new OutputStreamWriter(this.actionStorageFile.getOutputStream(this.actionAppend));
            }
            case 2: {
                return this.actionRegularFile.exists();
            }
            case 3: {
                return this.actionStorageFile.exists();
            }
            case 4: {
                return this.actionRegularFile.delete();
            }
            case 18: {
                return this.actionStorageFile.delete();
            }
            case 5: {
                boolean bl = this.actionRegularFile.mkdirs();
                FileUtil.limitAccessToOwner(this.actionRegularFile);
                return bl;
            }
            case 6: {
                return this.actionRegularFile.isDirectory();
            }
            case 7: {
                return FileUtil.removeDirectory(this.actionRegularFile);
            }
            case 8: {
                return this.actionRegularFile.renameTo(this.actionRegularFile2);
            }
            case 9: {
                return FileUtil.copyDirectory(this.storageFactory, this.actionStorageFile, this.actionRegularFile, this.actionBuffer, this.actionFilter, this.actionCopySubDirs);
            }
            case 10: {
                return FileUtil.copyDirectory((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile, this.actionBuffer, this.actionFilter);
            }
            case 11: {
                return FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile);
            }
            case 12: {
                return this.actionRegularFile.list();
            }
            case 13: {
                return this.actionStorageFile.list();
            }
            case 14: {
                return FileUtil.copyFile((StorageFactory)((WritableStorageFactory)this.storageFactory), this.actionStorageFile, this.actionRegularFile);
            }
            case 17: {
                return FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionStorageFile, this.actionToStorageFile);
            }
            case 15: {
                return this.actionRegularFile.getCanonicalPath();
            }
            case 16: {
                return this.actionStorageFile.getCanonicalPath();
            }
            case 19: {
                return new OutputStreamWriter(this.actionStorageFile.getOutputStream(), "UTF8");
            }
        }
        return null;
    }

    private static boolean isSet(Properties properties, String string) {
        return properties.getProperty(string) != null;
    }

    private static boolean isTrue(Properties properties, String string) {
        return Boolean.valueOf(properties.getProperty(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataWarningFile() throws StandardException {
        StorageFile storageFile = this.storageFactory.newStorageFile("seg0", "README_DO_NOT_TOUCH_FILES.txt");
        OutputStreamWriter outputStreamWriter = null;
        if (!this.privExists(storageFile)) {
            try {
                outputStreamWriter = this.privGetOutputStreamWriter(storageFile);
                outputStreamWriter.write(MessageService.getTextMessage((String)"M007", (Object[])new Object[0]));
            }
            catch (IOException iOException) {
            }
            finally {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static ContextService getContextService() {
        if (System.getSecurityManager() == null) {
            return ContextService.getFactory();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Context getContextOrNull(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(string);
            }
        });
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static String getServiceName(final Object object) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Monitor.getServiceName(object);
            }
        });
    }

    private static Object startSystemModule(final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.startSystemModule(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static Object bootServiceModule(final boolean bl, final Object object, final String string, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.bootServiceModule(bl, object, string, properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(object, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }
}

