/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.tag;

import java.util.Objects;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;

public abstract class AbstractTag<T> {
    private int id;
    private boolean canOverwrite;
    protected final String key;

    public AbstractTag(int id, String tagKey, boolean canOverwrite) {
        this.id = id;
        this.key = tagKey;
        this.canOverwrite = canOverwrite;
    }

    public AbstractTag(String key) {
        this(-1, key, false);
    }

    protected abstract void set(AbstractSpan var1, T var2);

    public String key() {
        return this.key;
    }

    public boolean sameWith(AbstractTag<T> tag) {
        return this.canOverwrite && this.id == tag.id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isCanOverwrite() {
        return this.canOverwrite;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractTag)) {
            return false;
        }
        AbstractTag that = (AbstractTag)o;
        return this.getId() == that.getId() && this.isCanOverwrite() == that.isCanOverwrite() && this.key.equals(that.key);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.isCanOverwrite(), this.key);
    }
}

