/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.util;

import org.apache.skywalking.apm.agent.core.conf.Config;

public enum ThrowableTransformer {
    INSTANCE;

    private static final String LINE_SEPARATOR;

    public String convert2String(Throwable throwable, final int maxLength) {
        final StringBuilder stackMessage = new StringBuilder();
        Throwable causeException = throwable;
        for (int depth = Config.Agent.CAUSE_EXCEPTION_DEPTH; causeException != null && depth != 0; causeException = causeException.getCause(), --depth) {
            stackMessage.append(this.printExceptionInfo(causeException));
            boolean isLookDeeper = this.printStackElement(causeException.getStackTrace(), new AppendListener(){

                @Override
                public void append(String value) {
                    stackMessage.append(value);
                }

                @Override
                public boolean overMaxLength() {
                    return stackMessage.length() > maxLength;
                }
            });
            if (isLookDeeper) break;
        }
        return stackMessage.toString();
    }

    private String printExceptionInfo(Throwable causeException) {
        return causeException.toString() + LINE_SEPARATOR;
    }

    private boolean printStackElement(StackTraceElement[] stackTrace, AppendListener printListener) {
        if (stackTrace.length == 0) {
            return true;
        }
        for (StackTraceElement traceElement : stackTrace) {
            printListener.append("at " + traceElement + LINE_SEPARATOR);
            if (!printListener.overMaxLength()) continue;
            return true;
        }
        return false;
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
    }

    private static interface AppendListener {
        public void append(String var1);

        public boolean overMaxLength();
    }
}

