/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.remote.AgentIDDecorator;
import org.apache.skywalking.apm.agent.core.remote.AuthenticationDecorator;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannel;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.agent.core.remote.StandardChannelBuilder;
import org.apache.skywalking.apm.agent.core.remote.TLSChannelBuilder;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.Status;
import org.apache.skywalking.apm.dependencies.io.grpc.StatusRuntimeException;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;
import org.apache.skywalking.apm.util.StringUtil;

@DefaultImplementor
public class GRPCChannelManager
implements BootService,
Runnable {
    private static final ILog LOGGER = LogManager.getLogger(GRPCChannelManager.class);
    private volatile GRPCChannel managedChannel = null;
    private volatile ScheduledFuture<?> connectCheckFuture;
    private volatile boolean reconnect = true;
    private final Random random = new Random();
    private final List<GRPCChannelListener> listeners = Collections.synchronizedList(new LinkedList());
    private volatile List<String> grpcServers;
    private volatile int selectedIdx = -1;
    private volatile int reconnectCount = 0;

    @Override
    public void prepare() {
    }

    @Override
    public void boot() {
        if (Config.Collector.BACKEND_SERVICE.trim().length() == 0) {
            LOGGER.error("Collector server addresses are not set.");
            LOGGER.error("Agent will not uplink any data.");
            return;
        }
        this.grpcServers = Arrays.asList(Config.Collector.BACKEND_SERVICE.split(","));
        this.connectCheckFuture = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("GRPCChannelManager")).scheduleAtFixedRate(new RunnableWithExceptionProtection(this, t -> LOGGER.error("unexpected exception.", t)), 0L, Config.Collector.GRPC_CHANNEL_CHECK_INTERVAL, TimeUnit.SECONDS);
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void shutdown() {
        if (this.connectCheckFuture != null) {
            this.connectCheckFuture.cancel(true);
        }
        if (this.managedChannel != null) {
            this.managedChannel.shutdownNow();
        }
        LOGGER.debug("Selected collector grpc service shutdown.");
    }

    @Override
    public void run() {
        LOGGER.debug("Selected collector grpc service running, reconnect:{}.", this.reconnect);
        if (Config.Collector.IS_RESOLVE_DNS_PERIODICALLY && this.reconnect) {
            this.grpcServers = Arrays.stream(Config.Collector.BACKEND_SERVICE.split(",")).filter(StringUtil::isNotBlank).map(eachBackendService -> eachBackendService.split(":")).filter(domainPortPairs -> {
                if (((String[])domainPortPairs).length < 2) {
                    LOGGER.debug("Service address [{}] format error. The expected format is IP:port", domainPortPairs[0]);
                    return false;
                }
                return true;
            }).flatMap(domainPortPairs -> {
                try {
                    return Arrays.stream(InetAddress.getAllByName(domainPortPairs[0])).map(InetAddress::getHostAddress).map(ip -> String.format("%s:%s", ip, domainPortPairs[1]));
                }
                catch (Throwable t) {
                    LOGGER.error(t, "Failed to resolve {} of backend service.", domainPortPairs[0]);
                    return Stream.empty();
                }
            }).distinct().collect(Collectors.toList());
        }
        if (this.reconnect) {
            if (this.grpcServers.size() > 0) {
                String server = "";
                try {
                    int index = Math.abs(this.random.nextInt()) % this.grpcServers.size();
                    if (index != this.selectedIdx) {
                        this.selectedIdx = index;
                        server = this.grpcServers.get(index);
                        String[] ipAndPort = server.split(":");
                        if (this.managedChannel != null) {
                            this.managedChannel.shutdownNow();
                        }
                        this.managedChannel = GRPCChannel.newBuilder(ipAndPort[0], Integer.parseInt(ipAndPort[1])).addManagedChannelBuilder(new StandardChannelBuilder()).addManagedChannelBuilder(new TLSChannelBuilder()).addChannelDecorator(new AgentIDDecorator()).addChannelDecorator(new AuthenticationDecorator()).build();
                        this.reconnectCount = 0;
                        this.reconnect = false;
                        this.notify(GRPCChannelStatus.CONNECTED);
                    } else if (this.managedChannel.isConnected((long)(++this.reconnectCount) > Config.Agent.FORCE_RECONNECTION_PERIOD)) {
                        this.reconnectCount = 0;
                        this.reconnect = false;
                        this.notify(GRPCChannelStatus.CONNECTED);
                    }
                    return;
                }
                catch (Throwable t) {
                    LOGGER.error(t, "Create channel to {} fail.", server);
                }
            }
            LOGGER.debug("Selected collector grpc service is not available. Wait {} seconds to retry", Config.Collector.GRPC_CHANNEL_CHECK_INTERVAL);
        }
    }

    public void addChannelListener(GRPCChannelListener listener) {
        this.listeners.add(listener);
    }

    public Channel getChannel() {
        return this.managedChannel.getChannel();
    }

    public void reportError(Throwable throwable) {
        if (this.isNetworkError(throwable)) {
            this.reconnect = true;
            this.notify(GRPCChannelStatus.DISCONNECT);
        }
    }

    private void notify(GRPCChannelStatus status) {
        for (GRPCChannelListener listener : this.listeners) {
            try {
                listener.statusChanged(status);
            }
            catch (Throwable t) {
                LOGGER.error(t, "Fail to notify {} about channel connected.", listener.getClass().getName());
            }
        }
    }

    private boolean isNetworkError(Throwable throwable) {
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            return this.statusEquals(statusRuntimeException.getStatus(), Status.UNAVAILABLE, Status.PERMISSION_DENIED, Status.UNAUTHENTICATED, Status.RESOURCE_EXHAUSTED, Status.UNKNOWN);
        }
        return false;
    }

    private boolean statusEquals(Status sourceStatus, Status ... potentialStatus) {
        for (Status status : potentialStatus) {
            if (sourceStatus.getCode() != status.getCode()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int priority() {
        return Integer.MAX_VALUE;
    }
}

