/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.hbase;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.util.CollectionUtil;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.util.StringUtil;

public class HTableInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    private static final String PREFIX_OPERATION_NAME = "/HTable/";
    private static final String HBASE_DB_TYPE = "hbase";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        AbstractSpan span;
        boolean canTracingServer = false;
        List operations = null;
        OperationWithAttributes operation = null;
        if (allArguments != null && allArguments.length > 0) {
            if (allArguments[0] instanceof List) {
                List list = (List)allArguments[0];
                if (!CollectionUtil.isEmpty((Collection)list) && list.get(0) instanceof OperationWithAttributes) {
                    operations = list;
                    canTracingServer = true;
                }
            } else if (allArguments[0] instanceof OperationWithAttributes) {
                operation = (OperationWithAttributes)allArguments[0];
                canTracingServer = true;
            }
        }
        if (canTracingServer) {
            ContextCarrier contextCarrier = new ContextCarrier();
            span = ContextManager.createExitSpan((String)(PREFIX_OPERATION_NAME + method.getName()), (ContextCarrier)contextCarrier, (String)((String)objInst.getSkyWalkingDynamicField()));
            CarrierItem next = contextCarrier.items();
            while (next.hasNext()) {
                next = next.next();
                if (operation != null) {
                    operation.setAttribute(next.getHeadKey(), next.getHeadValue().getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                for (OperationWithAttributes o : operations) {
                    o.setAttribute(next.getHeadKey(), next.getHeadValue().getBytes(StandardCharsets.UTF_8));
                }
            }
        } else {
            span = ContextManager.createExitSpan((String)(PREFIX_OPERATION_NAME + method.getName()), (String)((String)objInst.getSkyWalkingDynamicField()));
        }
        span.setComponent((Component)ComponentsDefine.HBASE);
        Tags.DB_TYPE.set(span, HBASE_DB_TYPE);
        Tags.DB_INSTANCE.set(span, ((HTable)objInst).getName().getNameAsString());
        SpanLayer.asDB((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws Throwable {
        Configuration connection = ((ClusterConnection)allArguments[1]).getConfiguration();
        this.tryGetZookeeperQuorum(objInst, connection);
    }

    protected void tryGetZookeeperQuorum(EnhancedInstance objInst, Configuration configuration) throws Exception {
        Method method = configuration.getClass().getDeclaredMethod("getProps", new Class[0]);
        method.setAccessible(true);
        Properties props = (Properties)method.invoke((Object)configuration, new Object[0]);
        String value = (String)props.get("hbase.zookeeper.quorum");
        if (StringUtil.isNotBlank((String)value)) {
            objInst.setSkyWalkingDynamicField((Object)value);
        }
    }
}

