/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.solrj;

import java.lang.reflect.Method;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;

public class SolrConnectorInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (ContextManager.isActive()) {
            HttpRequestBase request = (HttpRequestBase)allArguments[0];
            ContextCarrier carrier = new ContextCarrier();
            ContextManager.inject((ContextCarrier)carrier);
            CarrierItem items = carrier.items();
            while (items.hasNext()) {
                items = items.next();
                request.setHeader(items.getHeadKey(), items.getHeadValue());
            }
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

