/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.wrapper;

import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class SwRunnableWrapper
implements Runnable {
    private Runnable runnable;
    private ContextSnapshot contextSnapshot;

    public SwRunnableWrapper(Runnable runnable, ContextSnapshot contextSnapshot) {
        this.runnable = runnable;
        this.contextSnapshot = contextSnapshot;
    }

    @Override
    public void run() {
        AbstractSpan span = ContextManager.createLocalSpan((String)this.getOperationName());
        span.setComponent((Component)ComponentsDefine.JDK_THREADING);
        ContextManager.continued((ContextSnapshot)this.contextSnapshot);
        try {
            this.runnable.run();
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    private String getOperationName() {
        return "SwRunnableWrapper/" + Thread.currentThread().getName();
    }
}

