/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spymemcached.v2;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class MemcachedMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String SPY_MEMCACHE = "SpyMemcached/";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String peer = String.valueOf(objInst.getSkyWalkingDynamicField());
        AbstractSpan span = ContextManager.createExitSpan((String)(SPY_MEMCACHE + method.getName()), (String)peer);
        span.setComponent((Component)ComponentsDefine.SPYMEMCACHED);
        Tags.DB_TYPE.set(span, ComponentsDefine.SPYMEMCACHED.getName());
        SpanLayer.asCache((AbstractSpan)span);
        Tags.DB_STATEMENT.set(span, this.getStatement(method, allArguments));
    }

    private String getStatement(Method method, Object[] allArguments) {
        if (allArguments != null && allArguments.length > 0) {
            return method.getName() + ' ' + allArguments[0];
        }
        return method.getName();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }
}

