/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.trace;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.plugin.jdbc.JDBCPluginConfig;
import org.apache.skywalking.apm.plugin.jdbc.PreparedStatementParameterBuilder;
import org.apache.skywalking.apm.plugin.jdbc.define.StatementEnhanceInfos;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class PreparedStatementTracing {
    public static <R> R execute(PreparedStatement realStatement, ConnectionInfo connectInfo, String method, String sql, Executable<R> exec, StatementEnhanceInfos statementEnhanceInfos) throws SQLException {
        AbstractSpan span = ContextManager.createExitSpan((String)(connectInfo.getDBType() + "/JDBC/PreparedStatement/" + method), (String)connectInfo.getDatabasePeer());
        try {
            Object parameters;
            Tags.DB_TYPE.set(span, connectInfo.getDBType());
            Tags.DB_INSTANCE.set(span, connectInfo.getDatabaseName());
            Tags.DB_STATEMENT.set(span, sql);
            span.setComponent((Component)connectInfo.getComponent());
            SpanLayer.asDB((AbstractSpan)span);
            if (JDBCPluginConfig.Plugin.JDBC.TRACE_SQL_PARAMETERS && Objects.nonNull(statementEnhanceInfos) && (parameters = statementEnhanceInfos.getParameters()) != null && ((R)parameters).length > 0) {
                int maxIndex = statementEnhanceInfos.getMaxIndex();
                Tags.SQL_PARAMETERS.set(span, PreparedStatementTracing.getParameterString(parameters, maxIndex));
            }
            parameters = exec.exe(realStatement, sql);
            return parameters;
        }
        catch (SQLException e) {
            span.log((Throwable)e);
            throw e;
        }
        finally {
            ContextManager.stopSpan((AbstractSpan)span);
        }
    }

    private static String getParameterString(Object[] parameters, int maxIndex) {
        return new PreparedStatementParameterBuilder().setParameters(parameters).setMaxIndex(maxIndex).build();
    }

    public static interface Executable<R> {
        public R exe(PreparedStatement var1, String var2) throws SQLException;
    }
}

