/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.baidu.brpc;

import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ClientInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Request request = (Request)allArguments[0];
        InetSocketAddress remoteAddress = (InetSocketAddress)request.getChannel().remoteAddress();
        InetAddress address = remoteAddress.getAddress();
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan span = ContextManager.createExitSpan((String)this.generateOperationName(request), (ContextCarrier)contextCarrier, (String)(address.getHostAddress() + ":" + remoteAddress.getPort()));
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            if (request.getKvAttachment() == null) {
                request.setKvAttachment(new HashMap());
            }
            request.getKvAttachment().put(next.getHeadKey(), next.getHeadValue());
        }
        span.setComponent((Component)ComponentsDefine.BRPC_JAVA);
        SpanLayer.asRPCFramework((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Response response = (Response)allArguments[1];
        if (response != null && response.getException() != null) {
            this.dealException(response.getException());
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        this.dealException(t);
    }

    private void dealException(Throwable throwable) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(throwable);
    }

    private String generateOperationName(Request request) {
        StringBuilder operationName = new StringBuilder();
        operationName.append(request.getServiceName() + "." + request.getMethodName());
        return operationName.toString();
    }
}

