/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.avro;

import java.lang.reflect.Method;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Responder;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.avro.SWServerRPCPlugin;

public class ResponderInterceptor
implements InstanceConstructorInterceptor,
InstanceMethodsAroundInterceptor {
    public void onConstruct(EnhancedInstance enhancedInstance, Object[] objects) {
        Responder responder = (Responder)enhancedInstance;
        Protocol protocol = responder.getLocal();
        String prefix = protocol.getNamespace() + "." + protocol.getName() + ".";
        responder.addRPCPlugin((RPCPlugin)new SWServerRPCPlugin(prefix));
    }

    public void beforeMethod(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, Object result) throws Throwable {
        if (ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        return result;
    }

    public void handleMethodException(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, Throwable throwable) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(throwable);
        }
    }
}

