/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grizzly.v2;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.glassfish.grizzly.http.server.Request;

public class HttpHandlerInterceptor
implements InstanceMethodsAroundInterceptorV2 {
    public static final String GRIZZLY_CONTEXT = "SW_GRIZZLY_CONTEXT";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInvocationContext context) throws Throwable {
        Request request = (Request)allArguments[0];
        request.getHeaderNames();
        ContextCarrier carrier = new ContextCarrier();
        CarrierItem items = carrier.items();
        while (items.hasNext()) {
            items = items.next();
            items.setHeadValue(request.getHeader(items.getHeadKey()));
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)(request.getMethod().getMethodString() + ":" + request.getRequestURI()), (ContextCarrier)carrier);
        Tags.URL.set(span, request.getRequestURL().toString());
        Tags.HTTP.METHOD.set(span, request.getMethod().getMethodString());
        span.setComponent((Component)ComponentsDefine.GRIZZLY);
        SpanLayer.asHttp((AbstractSpan)span);
        span.prepareForAsync();
        Object[] grizzlyContext = new Object[]{span, ContextManager.capture()};
        request.setAttribute(GRIZZLY_CONTEXT, (Object)grizzlyContext);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret, MethodInvocationContext context) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t, MethodInvocationContext context) {
        ContextManager.activeSpan().log(t);
    }
}

