/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.customize.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.AbstractClassEnhancePluginDefine;
import org.apache.skywalking.apm.agent.core.plugin.loader.AgentClassLoader;
import org.apache.skywalking.apm.agent.core.plugin.loader.InstrumentationLoader;
import org.apache.skywalking.apm.plugin.customize.conf.CustomizeConfiguration;
import org.apache.skywalking.apm.plugin.customize.define.CustomizeInstanceInstrumentation;
import org.apache.skywalking.apm.plugin.customize.define.CustomizeStaticInstrumentation;
import org.apache.skywalking.apm.plugin.customize.util.CustomizeUtil;

public class CustomizeInstrumentationLoader
implements InstrumentationLoader {
    private static final ILog LOGGER = LogManager.getLogger(CustomizeInstrumentationLoader.class);

    public List<AbstractClassEnhancePluginDefine> load(AgentClassLoader classLoader) {
        ArrayList<AbstractClassEnhancePluginDefine> instrumentations = new ArrayList<AbstractClassEnhancePluginDefine>();
        CustomizeConfiguration.INSTANCE.loadForEnhance();
        Set<String> enhanceClasses = CustomizeConfiguration.INSTANCE.getInstrumentations();
        try {
            for (String enhanceClass : enhanceClasses) {
                String[] classDesc = CustomizeUtil.getClassDesc(enhanceClass);
                AbstractClassEnhancePluginDefine plugin = (AbstractClassEnhancePluginDefine)Class.forName(Boolean.valueOf(classDesc[1]) != false ? CustomizeStaticInstrumentation.class.getName() : CustomizeInstanceInstrumentation.class.getName(), true, (ClassLoader)classLoader).getConstructor(String.class).newInstance(classDesc[0]);
                instrumentations.add(plugin);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "InstrumentationLoader loader is error, spi loader is {}", new Object[]{CustomizeInstrumentationLoader.class.getName()});
        }
        return instrumentations;
    }
}

