/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;
import org.apache.skywalking.apm.dependencies.org.slf4j.LoggerFactory;

public abstract class AbstractStickyAssignor
extends AbstractPartitionAssignor {
    private static final Logger log = LoggerFactory.getLogger(AbstractStickyAssignor.class);
    public static final int DEFAULT_GENERATION = -1;
    private PartitionMovements partitionMovements;

    protected abstract MemberData memberData(ConsumerPartitionAssignor.Subscription var1);

    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        HashMap<String, List<TopicPartition>> currentAssignment = new HashMap<String, List<TopicPartition>>();
        HashMap<TopicPartition, ConsumerGenerationPair> prevAssignment = new HashMap<TopicPartition, ConsumerGenerationPair>();
        this.partitionMovements = new PartitionMovements();
        this.prepopulateCurrentAssignments(subscriptions, currentAssignment, prevAssignment);
        boolean isFreshAssignment = currentAssignment.isEmpty();
        HashMap<TopicPartition, List<String>> partition2AllPotentialConsumers = new HashMap<TopicPartition, List<String>>();
        HashMap<String, List<TopicPartition>> consumer2AllPotentialPartitions = new HashMap<String, List<TopicPartition>>();
        for (Map.Entry<String, Integer> entry : partitionsPerTopic.entrySet()) {
            for (int i = 0; i < entry.getValue(); ++i) {
                partition2AllPotentialConsumers.put(new TopicPartition(entry.getKey(), i), new ArrayList());
            }
        }
        for (Map.Entry<String, Object> entry : subscriptions.entrySet()) {
            String string = entry.getKey();
            consumer2AllPotentialPartitions.put(string, new ArrayList());
            ((ConsumerPartitionAssignor.Subscription)entry.getValue()).topics().stream().filter(topic -> partitionsPerTopic.get(topic) != null).forEach(topic -> {
                for (int i = 0; i < (Integer)partitionsPerTopic.get(topic); ++i) {
                    TopicPartition topicPartition = new TopicPartition((String)topic, i);
                    ((List)consumer2AllPotentialPartitions.get(consumerId)).add(topicPartition);
                    ((List)partition2AllPotentialConsumers.get(topicPartition)).add(consumerId);
                }
            });
            if (currentAssignment.containsKey(string)) continue;
            currentAssignment.put(string, new ArrayList());
        }
        HashMap<TopicPartition, String> currentPartitionConsumer = new HashMap<TopicPartition, String>();
        for (Map.Entry entry : currentAssignment.entrySet()) {
            for (TopicPartition topicPartition : (List)entry.getValue()) {
                currentPartitionConsumer.put(topicPartition, (String)entry.getKey());
            }
        }
        List<TopicPartition> list = this.sortPartitions(currentAssignment, prevAssignment.keySet(), isFreshAssignment, partition2AllPotentialConsumers, consumer2AllPotentialPartitions);
        ArrayList<TopicPartition> arrayList = new ArrayList<TopicPartition>(list);
        boolean revocationRequired = false;
        Iterator it = currentAssignment.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!subscriptions.containsKey(entry.getKey())) {
                for (TopicPartition topicPartition : (List)entry.getValue()) {
                    currentPartitionConsumer.remove(topicPartition);
                }
                it.remove();
                continue;
            }
            Iterator partitionIter = ((List)entry.getValue()).iterator();
            while (partitionIter.hasNext()) {
                TopicPartition partition = (TopicPartition)partitionIter.next();
                if (!partition2AllPotentialConsumers.containsKey(partition)) {
                    partitionIter.remove();
                    currentPartitionConsumer.remove(partition);
                    continue;
                }
                if (!subscriptions.get(entry.getKey()).topics().contains(partition.topic())) {
                    partitionIter.remove();
                    revocationRequired = true;
                    continue;
                }
                arrayList.remove(partition);
            }
        }
        TreeSet<String> sortedCurrentSubscriptions = new TreeSet<String>(new SubscriptionComparator(currentAssignment));
        sortedCurrentSubscriptions.addAll(currentAssignment.keySet());
        this.balance(currentAssignment, prevAssignment, list, arrayList, sortedCurrentSubscriptions, consumer2AllPotentialPartitions, partition2AllPotentialConsumers, currentPartitionConsumer, revocationRequired);
        return currentAssignment;
    }

    private void prepopulateCurrentAssignments(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> currentAssignment, Map<TopicPartition, ConsumerGenerationPair> prevAssignment) {
        HashMap sortedPartitionConsumersByGeneration = new HashMap();
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> entry : subscriptions.entrySet()) {
            String consumer = entry.getKey();
            MemberData memberData = this.memberData(entry.getValue());
            for (TopicPartition partition : memberData.partitions) {
                if (sortedPartitionConsumersByGeneration.containsKey(partition)) {
                    Map consumers = (Map)sortedPartitionConsumersByGeneration.get(partition);
                    if (memberData.generation.isPresent() && consumers.containsKey(memberData.generation.get())) {
                        log.warn("Partition '{}' is assigned to multiple consumers following sticky assignment generation {}.", (Object)partition, (Object)memberData.generation);
                        continue;
                    }
                    consumers.put(memberData.generation.orElse(-1), consumer);
                    continue;
                }
                TreeMap<Integer, String> sortedConsumers = new TreeMap<Integer, String>();
                sortedConsumers.put(memberData.generation.orElse(-1), consumer);
                sortedPartitionConsumersByGeneration.put(partition, sortedConsumers);
            }
        }
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> entry : sortedPartitionConsumersByGeneration.entrySet()) {
            TopicPartition partition = (TopicPartition)((Object)entry.getKey());
            TreeMap consumers = (TreeMap)((Object)entry.getValue());
            Iterator it = consumers.descendingKeySet().iterator();
            String consumer = (String)consumers.get(it.next());
            currentAssignment.computeIfAbsent(consumer, k -> new ArrayList());
            currentAssignment.get(consumer).add(partition);
            if (!it.hasNext()) continue;
            int generation = (Integer)it.next();
            prevAssignment.put(partition, new ConsumerGenerationPair((String)consumers.get(generation), generation));
        }
    }

    private boolean isBalanced(Map<String, List<TopicPartition>> currentAssignment, TreeSet<String> sortedCurrentSubscriptions, Map<String, List<TopicPartition>> allSubscriptions) {
        int max;
        int min = currentAssignment.get(sortedCurrentSubscriptions.first()).size();
        if (min >= (max = currentAssignment.get(sortedCurrentSubscriptions.last()).size()) - 1) {
            return true;
        }
        HashMap<TopicPartition, String> allPartitions = new HashMap<TopicPartition, String>();
        Set<Map.Entry<String, List<TopicPartition>>> assignments = currentAssignment.entrySet();
        for (Map.Entry<String, List<TopicPartition>> entry : assignments) {
            List<TopicPartition> topicPartitions = entry.getValue();
            for (TopicPartition topicPartition : topicPartitions) {
                if (allPartitions.containsKey(topicPartition)) {
                    log.error("{} is assigned to more than one consumer.", (Object)topicPartition);
                }
                allPartitions.put(topicPartition, entry.getKey());
            }
        }
        for (String consumer : sortedCurrentSubscriptions) {
            List<TopicPartition> consumerPartitions = currentAssignment.get(consumer);
            int consumerPartitionCount = consumerPartitions.size();
            if (consumerPartitionCount == allSubscriptions.get(consumer).size()) continue;
            List<TopicPartition> potentialTopicPartitions = allSubscriptions.get(consumer);
            for (TopicPartition topicPartition : potentialTopicPartitions) {
                String otherConsumer;
                int otherConsumerPartitionCount;
                if (currentAssignment.get(consumer).contains(topicPartition) || consumerPartitionCount >= (otherConsumerPartitionCount = currentAssignment.get(otherConsumer = (String)allPartitions.get(topicPartition)).size())) continue;
                log.debug("{} can be moved from consumer {} to consumer {} for a more balanced assignment.", topicPartition, otherConsumer, consumer);
                return false;
            }
        }
        return true;
    }

    private int getBalanceScore(Map<String, List<TopicPartition>> assignment) {
        int score = 0;
        HashMap<String, Integer> consumer2AssignmentSize = new HashMap<String, Integer>();
        for (Map.Entry<String, List<TopicPartition>> entry : assignment.entrySet()) {
            consumer2AssignmentSize.put(entry.getKey(), entry.getValue().size());
        }
        Iterator it = consumer2AssignmentSize.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<TopicPartition>> entry;
            entry = it.next();
            int consumerAssignmentSize = (Integer)((Object)entry.getValue());
            it.remove();
            for (Map.Entry otherEntry : consumer2AssignmentSize.entrySet()) {
                score += Math.abs(consumerAssignmentSize - (Integer)otherEntry.getValue());
            }
        }
        return score;
    }

    private List<TopicPartition> sortPartitions(Map<String, List<TopicPartition>> currentAssignment, Set<TopicPartition> partitionsWithADifferentPreviousAssignment, boolean isFreshAssignment, Map<TopicPartition, List<String>> partition2AllPotentialConsumers, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions) {
        ArrayList<TopicPartition> sortedPartitions = new ArrayList<TopicPartition>();
        if (!isFreshAssignment && this.areSubscriptionsIdentical(partition2AllPotentialConsumers, consumer2AllPotentialPartitions)) {
            Map<String, List<TopicPartition>> assignments = this.deepCopy(currentAssignment);
            for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
                ArrayList<TopicPartition> toRemove = new ArrayList<TopicPartition>();
                for (TopicPartition partition : entry.getValue()) {
                    if (partition2AllPotentialConsumers.keySet().contains(partition)) continue;
                    toRemove.add(partition);
                }
                for (TopicPartition partition : toRemove) {
                    entry.getValue().remove(partition);
                }
            }
            TreeSet<String> sortedConsumers = new TreeSet<String>(new SubscriptionComparator(assignments));
            sortedConsumers.addAll(assignments.keySet());
            while (!sortedConsumers.isEmpty()) {
                String consumer = sortedConsumers.pollLast();
                List<TopicPartition> remainingPartitions = assignments.get(consumer);
                ArrayList<TopicPartition> prevPartitions = new ArrayList<TopicPartition>(partitionsWithADifferentPreviousAssignment);
                prevPartitions.retainAll(remainingPartitions);
                if (!prevPartitions.isEmpty()) {
                    TopicPartition partition;
                    partition = (TopicPartition)prevPartitions.remove(0);
                    remainingPartitions.remove(partition);
                    sortedPartitions.add(partition);
                    sortedConsumers.add(consumer);
                    continue;
                }
                if (remainingPartitions.isEmpty()) continue;
                sortedPartitions.add(remainingPartitions.remove(0));
                sortedConsumers.add(consumer);
            }
            for (TopicPartition partition : partition2AllPotentialConsumers.keySet()) {
                if (sortedPartitions.contains(partition)) continue;
                sortedPartitions.add(partition);
            }
        } else {
            TreeSet<TopicPartition> sortedAllPartitions = new TreeSet<TopicPartition>(new PartitionComparator(partition2AllPotentialConsumers));
            sortedAllPartitions.addAll(partition2AllPotentialConsumers.keySet());
            while (!sortedAllPartitions.isEmpty()) {
                sortedPartitions.add(sortedAllPartitions.pollFirst());
            }
        }
        return sortedPartitions;
    }

    private boolean areSubscriptionsIdentical(Map<TopicPartition, List<String>> partition2AllPotentialConsumers, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions) {
        if (!this.hasIdenticalListElements(partition2AllPotentialConsumers.values())) {
            return false;
        }
        return this.hasIdenticalListElements(consumer2AllPotentialPartitions.values());
    }

    private void assignPartition(TopicPartition partition, TreeSet<String> sortedCurrentSubscriptions, Map<String, List<TopicPartition>> currentAssignment, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions, Map<TopicPartition, String> currentPartitionConsumer) {
        for (String consumer : sortedCurrentSubscriptions) {
            if (!consumer2AllPotentialPartitions.get(consumer).contains(partition)) continue;
            sortedCurrentSubscriptions.remove(consumer);
            currentAssignment.get(consumer).add(partition);
            currentPartitionConsumer.put(partition, consumer);
            sortedCurrentSubscriptions.add(consumer);
            break;
        }
    }

    private boolean canParticipateInReassignment(TopicPartition partition, Map<TopicPartition, List<String>> partition2AllPotentialConsumers) {
        return partition2AllPotentialConsumers.get(partition).size() >= 2;
    }

    private boolean canParticipateInReassignment(String consumer, Map<String, List<TopicPartition>> currentAssignment, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions, Map<TopicPartition, List<String>> partition2AllPotentialConsumers) {
        int maxAssignmentSize;
        List<TopicPartition> currentPartitions = currentAssignment.get(consumer);
        int currentAssignmentSize = currentPartitions.size();
        if (currentAssignmentSize > (maxAssignmentSize = consumer2AllPotentialPartitions.get(consumer).size())) {
            log.error("The consumer {} is assigned more partitions than the maximum possible.", (Object)consumer);
        }
        if (currentAssignmentSize < maxAssignmentSize) {
            return true;
        }
        for (TopicPartition partition : currentPartitions) {
            if (!this.canParticipateInReassignment(partition, partition2AllPotentialConsumers)) continue;
            return true;
        }
        return false;
    }

    private void balance(Map<String, List<TopicPartition>> currentAssignment, Map<TopicPartition, ConsumerGenerationPair> prevAssignment, List<TopicPartition> sortedPartitions, List<TopicPartition> unassignedPartitions, TreeSet<String> sortedCurrentSubscriptions, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions, Map<TopicPartition, List<String>> partition2AllPotentialConsumers, Map<TopicPartition, String> currentPartitionConsumer, boolean revocationRequired) {
        boolean initializing = currentAssignment.get(sortedCurrentSubscriptions.last()).isEmpty();
        boolean reassignmentPerformed = false;
        for (TopicPartition topicPartition : unassignedPartitions) {
            if (partition2AllPotentialConsumers.get(topicPartition).isEmpty()) continue;
            this.assignPartition(topicPartition, sortedCurrentSubscriptions, currentAssignment, consumer2AllPotentialPartitions, currentPartitionConsumer);
        }
        HashSet<TopicPartition> fixedPartitions = new HashSet<TopicPartition>();
        for (TopicPartition topicPartition : partition2AllPotentialConsumers.keySet()) {
            if (this.canParticipateInReassignment(topicPartition, partition2AllPotentialConsumers)) continue;
            fixedPartitions.add(topicPartition);
        }
        sortedPartitions.removeAll(fixedPartitions);
        unassignedPartitions.removeAll(fixedPartitions);
        HashMap<String, List<TopicPartition>> hashMap = new HashMap<String, List<TopicPartition>>();
        for (String consumer : consumer2AllPotentialPartitions.keySet()) {
            if (this.canParticipateInReassignment(consumer, currentAssignment, consumer2AllPotentialPartitions, partition2AllPotentialConsumers)) continue;
            sortedCurrentSubscriptions.remove(consumer);
            hashMap.put(consumer, currentAssignment.remove(consumer));
        }
        Map<String, List<TopicPartition>> map = this.deepCopy(currentAssignment);
        HashMap<TopicPartition, String> preBalancePartitionConsumers = new HashMap<TopicPartition, String>(currentPartitionConsumer);
        if (!revocationRequired) {
            this.performReassignments(unassignedPartitions, currentAssignment, prevAssignment, sortedCurrentSubscriptions, consumer2AllPotentialPartitions, partition2AllPotentialConsumers, currentPartitionConsumer);
        }
        reassignmentPerformed = this.performReassignments(sortedPartitions, currentAssignment, prevAssignment, sortedCurrentSubscriptions, consumer2AllPotentialPartitions, partition2AllPotentialConsumers, currentPartitionConsumer);
        if (!initializing && reassignmentPerformed && this.getBalanceScore(currentAssignment) >= this.getBalanceScore(map)) {
            this.deepCopy(map, currentAssignment);
            currentPartitionConsumer.clear();
            currentPartitionConsumer.putAll(preBalancePartitionConsumers);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String consumer = (String)entry.getKey();
            currentAssignment.put(consumer, (List<TopicPartition>)entry.getValue());
            sortedCurrentSubscriptions.add(consumer);
        }
        hashMap.clear();
    }

    private boolean performReassignments(List<TopicPartition> reassignablePartitions, Map<String, List<TopicPartition>> currentAssignment, Map<TopicPartition, ConsumerGenerationPair> prevAssignment, TreeSet<String> sortedCurrentSubscriptions, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions, Map<TopicPartition, List<String>> partition2AllPotentialConsumers, Map<TopicPartition, String> currentPartitionConsumer) {
        boolean modified;
        boolean reassignmentPerformed = false;
        do {
            modified = false;
            Iterator<TopicPartition> partitionIterator = reassignablePartitions.iterator();
            block1: while (partitionIterator.hasNext() && !this.isBalanced(currentAssignment, sortedCurrentSubscriptions, consumer2AllPotentialPartitions)) {
                String consumer;
                TopicPartition partition = partitionIterator.next();
                if (partition2AllPotentialConsumers.get(partition).size() <= 1) {
                    log.error("Expected more than one potential consumer for partition '{}'", (Object)partition);
                }
                if ((consumer = currentPartitionConsumer.get(partition)) == null) {
                    log.error("Expected partition '{}' to be assigned to a consumer", (Object)partition);
                }
                if (prevAssignment.containsKey(partition) && currentAssignment.get(consumer).size() > currentAssignment.get(prevAssignment.get((Object)partition).consumer).size() + 1) {
                    this.reassignPartition(partition, currentAssignment, sortedCurrentSubscriptions, currentPartitionConsumer, prevAssignment.get((Object)partition).consumer);
                    reassignmentPerformed = true;
                    modified = true;
                    continue;
                }
                for (String otherConsumer : partition2AllPotentialConsumers.get(partition)) {
                    if (currentAssignment.get(consumer).size() <= currentAssignment.get(otherConsumer).size() + 1) continue;
                    this.reassignPartition(partition, currentAssignment, sortedCurrentSubscriptions, currentPartitionConsumer, consumer2AllPotentialPartitions);
                    reassignmentPerformed = true;
                    modified = true;
                    continue block1;
                }
            }
        } while (modified);
        return reassignmentPerformed;
    }

    private void reassignPartition(TopicPartition partition, Map<String, List<TopicPartition>> currentAssignment, TreeSet<String> sortedCurrentSubscriptions, Map<TopicPartition, String> currentPartitionConsumer, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions) {
        String newConsumer = null;
        for (String anotherConsumer : sortedCurrentSubscriptions) {
            if (!consumer2AllPotentialPartitions.get(anotherConsumer).contains(partition)) continue;
            newConsumer = anotherConsumer;
            break;
        }
        assert (newConsumer != null);
        this.reassignPartition(partition, currentAssignment, sortedCurrentSubscriptions, currentPartitionConsumer, newConsumer);
    }

    private void reassignPartition(TopicPartition partition, Map<String, List<TopicPartition>> currentAssignment, TreeSet<String> sortedCurrentSubscriptions, Map<TopicPartition, String> currentPartitionConsumer, String newConsumer) {
        String consumer = currentPartitionConsumer.get(partition);
        TopicPartition partitionToBeMoved = this.partitionMovements.getTheActualPartitionToBeMoved(partition, consumer, newConsumer);
        this.processPartitionMovement(partitionToBeMoved, newConsumer, currentAssignment, sortedCurrentSubscriptions, currentPartitionConsumer);
    }

    private void processPartitionMovement(TopicPartition partition, String newConsumer, Map<String, List<TopicPartition>> currentAssignment, TreeSet<String> sortedCurrentSubscriptions, Map<TopicPartition, String> currentPartitionConsumer) {
        String oldConsumer = currentPartitionConsumer.get(partition);
        sortedCurrentSubscriptions.remove(oldConsumer);
        sortedCurrentSubscriptions.remove(newConsumer);
        this.partitionMovements.movePartition(partition, oldConsumer, newConsumer);
        currentAssignment.get(oldConsumer).remove(partition);
        currentAssignment.get(newConsumer).add(partition);
        currentPartitionConsumer.put(partition, newConsumer);
        sortedCurrentSubscriptions.add(newConsumer);
        sortedCurrentSubscriptions.add(oldConsumer);
    }

    public boolean isSticky() {
        return this.partitionMovements.isSticky();
    }

    private <T> boolean hasIdenticalListElements(Collection<List<T>> col) {
        Iterator<List<T>> it = col.iterator();
        if (!it.hasNext()) {
            return true;
        }
        List<T> cur = it.next();
        while (it.hasNext()) {
            List<T> next = it.next();
            if (!cur.containsAll(next) || !next.containsAll(cur)) {
                return false;
            }
            cur = next;
        }
        return true;
    }

    private void deepCopy(Map<String, List<TopicPartition>> source, Map<String, List<TopicPartition>> dest) {
        dest.clear();
        for (Map.Entry<String, List<TopicPartition>> entry : source.entrySet()) {
            dest.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
    }

    private Map<String, List<TopicPartition>> deepCopy(Map<String, List<TopicPartition>> assignment) {
        HashMap<String, List<TopicPartition>> copy = new HashMap<String, List<TopicPartition>>();
        this.deepCopy(assignment, copy);
        return copy;
    }

    private static class ConsumerPair {
        private final String srcMemberId;
        private final String dstMemberId;

        ConsumerPair(String srcMemberId, String dstMemberId) {
            this.srcMemberId = srcMemberId;
            this.dstMemberId = dstMemberId;
        }

        public String toString() {
            return this.srcMemberId + "->" + this.dstMemberId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.srcMemberId == null ? 0 : this.srcMemberId.hashCode());
            result = 31 * result + (this.dstMemberId == null ? 0 : this.dstMemberId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            ConsumerPair otherPair = (ConsumerPair)obj;
            return this.srcMemberId.equals(otherPair.srcMemberId) && this.dstMemberId.equals(otherPair.dstMemberId);
        }

        private boolean in(Set<ConsumerPair> pairs) {
            for (ConsumerPair pair : pairs) {
                if (!this.equals(pair)) continue;
                return true;
            }
            return false;
        }
    }

    private static class PartitionMovements {
        private Map<String, Map<ConsumerPair, Set<TopicPartition>>> partitionMovementsByTopic = new HashMap<String, Map<ConsumerPair, Set<TopicPartition>>>();
        private Map<TopicPartition, ConsumerPair> partitionMovements = new HashMap<TopicPartition, ConsumerPair>();

        private PartitionMovements() {
        }

        private ConsumerPair removeMovementRecordOfPartition(TopicPartition partition) {
            ConsumerPair pair = this.partitionMovements.remove(partition);
            String topic = partition.topic();
            Map<ConsumerPair, Set<TopicPartition>> partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic);
            partitionMovementsForThisTopic.get(pair).remove(partition);
            if (partitionMovementsForThisTopic.get(pair).isEmpty()) {
                partitionMovementsForThisTopic.remove(pair);
            }
            if (this.partitionMovementsByTopic.get(topic).isEmpty()) {
                this.partitionMovementsByTopic.remove(topic);
            }
            return pair;
        }

        private void addPartitionMovementRecord(TopicPartition partition, ConsumerPair pair) {
            Map<ConsumerPair, Set<TopicPartition>> partitionMovementsForThisTopic;
            this.partitionMovements.put(partition, pair);
            String topic = partition.topic();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                this.partitionMovementsByTopic.put(topic, new HashMap());
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(pair)) {
                partitionMovementsForThisTopic.put(pair, new HashSet());
            }
            partitionMovementsForThisTopic.get(pair).add(partition);
        }

        private void movePartition(TopicPartition partition, String oldConsumer, String newConsumer) {
            ConsumerPair pair = new ConsumerPair(oldConsumer, newConsumer);
            if (this.partitionMovements.containsKey(partition)) {
                ConsumerPair existingPair = this.removeMovementRecordOfPartition(partition);
                assert (existingPair.dstMemberId.equals(oldConsumer));
                if (!existingPair.srcMemberId.equals(newConsumer)) {
                    this.addPartitionMovementRecord(partition, new ConsumerPair(existingPair.srcMemberId, newConsumer));
                }
            } else {
                this.addPartitionMovementRecord(partition, pair);
            }
        }

        private TopicPartition getTheActualPartitionToBeMoved(TopicPartition partition, String oldConsumer, String newConsumer) {
            ConsumerPair reversePair;
            Map<ConsumerPair, Set<TopicPartition>> partitionMovementsForThisTopic;
            String topic = partition.topic();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                return partition;
            }
            if (this.partitionMovements.containsKey(partition)) {
                assert (oldConsumer.equals(this.partitionMovements.get(partition).dstMemberId));
                oldConsumer = this.partitionMovements.get(partition).srcMemberId;
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(reversePair = new ConsumerPair(newConsumer, oldConsumer))) {
                return partition;
            }
            return partitionMovementsForThisTopic.get(reversePair).iterator().next();
        }

        private boolean isLinked(String src, String dst, Set<ConsumerPair> pairs, List<String> currentPath) {
            if (src.equals(dst)) {
                return false;
            }
            if (pairs.isEmpty()) {
                return false;
            }
            if (new ConsumerPair(src, dst).in(pairs)) {
                currentPath.add(src);
                currentPath.add(dst);
                return true;
            }
            for (ConsumerPair pair : pairs) {
                if (!pair.srcMemberId.equals(src)) continue;
                HashSet<ConsumerPair> reducedSet = new HashSet<ConsumerPair>(pairs);
                reducedSet.remove(pair);
                currentPath.add(pair.srcMemberId);
                return this.isLinked(pair.dstMemberId, dst, reducedSet, currentPath);
            }
            return false;
        }

        private boolean in(List<String> cycle, Set<List<String>> cycles) {
            ArrayList<String> superCycle = new ArrayList<String>(cycle);
            superCycle.remove(superCycle.size() - 1);
            superCycle.addAll(cycle);
            for (List<String> foundCycle : cycles) {
                if (foundCycle.size() != cycle.size() || Collections.indexOfSubList(superCycle, foundCycle) == -1) continue;
                return true;
            }
            return false;
        }

        private boolean hasCycles(Set<ConsumerPair> pairs) {
            HashSet<List<String>> cycles = new HashSet<List<String>>();
            for (ConsumerPair consumerPair : pairs) {
                HashSet<ConsumerPair> reducedPairs = new HashSet<ConsumerPair>(pairs);
                reducedPairs.remove(consumerPair);
                ArrayList<String> path = new ArrayList<String>(Collections.singleton(consumerPair.srcMemberId));
                if (!this.isLinked(consumerPair.dstMemberId, consumerPair.srcMemberId, reducedPairs, path) || this.in(path, cycles)) continue;
                cycles.add(new ArrayList<String>(path));
                log.error("A cycle of length {} was found: {}", (Object)(path.size() - 1), (Object)((Object)path).toString());
            }
            for (List list : cycles) {
                if (list.size() != 3) continue;
                return true;
            }
            return false;
        }

        private boolean isSticky() {
            for (Map.Entry<String, Map<ConsumerPair, Set<TopicPartition>>> topicMovements : this.partitionMovementsByTopic.entrySet()) {
                Set<ConsumerPair> topicMovementPairs = topicMovements.getValue().keySet();
                if (!this.hasCycles(topicMovementPairs)) continue;
                log.error("Stickiness is violated for topic {}\nPartition movements for this topic occurred among the following consumer pairs:\n{}", (Object)topicMovements.getKey(), (Object)topicMovements.getValue().toString());
                return false;
            }
            return true;
        }
    }

    private static class SubscriptionComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, List<TopicPartition>> map;

        SubscriptionComparator(Map<String, List<TopicPartition>> map) {
            this.map = map;
        }

        @Override
        public int compare(String o1, String o2) {
            int ret = this.map.get(o1).size() - this.map.get(o2).size();
            if (ret == 0) {
                ret = o1.compareTo(o2);
            }
            return ret;
        }
    }

    private static class PartitionComparator
    implements Comparator<TopicPartition>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<TopicPartition, List<String>> map;

        PartitionComparator(Map<TopicPartition, List<String>> map) {
            this.map = map;
        }

        @Override
        public int compare(TopicPartition o1, TopicPartition o2) {
            int ret = this.map.get(o1).size() - this.map.get(o2).size();
            if (ret == 0 && (ret = o1.topic().compareTo(o2.topic())) == 0) {
                ret = o1.partition() - o2.partition();
            }
            return ret;
        }
    }

    public static final class MemberData {
        public final List<TopicPartition> partitions;
        public final Optional<Integer> generation;

        public MemberData(List<TopicPartition> partitions, Optional<Integer> generation) {
            this.partitions = partitions;
            this.generation = generation;
        }
    }

    static final class ConsumerGenerationPair {
        final String consumer;
        final int generation;

        ConsumerGenerationPair(String consumer, int generation) {
            this.consumer = consumer;
            this.generation = generation;
        }
    }
}

