/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.broadcast;

import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.zip.Adler32;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.TorrentBroadcast$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockResult;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.BroadcastBlockId$;
import org.apache.spark.storage.ByteBufferBlockData;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t}d!B\u00193\u0001QR\u0004\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0013y\u0003!\u0011!Q\u0001\n}\u0013\u0007\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011\u001d\u0004!1!Q\u0001\f!DQA\u001c\u0001\u0005\u0002=D\u0011B\u001e\u0001A\u0002\u0003\u0007I\u0011B<\t\u0017\u0005\u0005\u0001\u00011AA\u0002\u0013%\u00111\u0001\u0005\u000b\u0003\u001f\u0001\u0001\u0019!A!B\u0013A\bbCA\r\u0001\u0001\u0007\t\u0019!C\u0005\u00037A1\"!\f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020!Y\u00111\u0007\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000f\u0011-\t9\u0004\u0001a\u0001\u0002\u0004%I!!\u000f\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013%\u00111\t\u0005\f\u0003\u000f\u0002\u0001\u0019!A!B\u0013\tY\u0004C\u0006\u0002L\u0001\u0001\r\u00111A\u0005\n\u00055\u0003bCA(\u0001\u0001\u0007\t\u0019!C\u0005\u0003#B!\"!\u0016\u0001\u0001\u0004\u0005\t\u0015)\u0003e\u0011%\tI\u0006\u0001a\u0001\n\u0013\ti\u0005C\u0005\u0002\\\u0001\u0001\r\u0011\"\u0003\u0002^!9\u0011\u0011\r\u0001!B\u0013!\u0007bBA2\u0001\u0011%\u0011Q\r\u0005\n\u0003g\u0002!\u0019!C\u0005\u0003kB\u0001\"a!\u0001A\u0003%\u0011q\u000f\u0005\n\u0003\u000b\u0003!\u0019!C\u0005\u0003sA\u0001\"a\"\u0001A\u0003%\u00111\b\u0005\f\u0003\u0013\u0003\u0001\u0019!a\u0001\n\u0013\tY\tC\u0006\u0002\u0014\u0002\u0001\r\u00111A\u0005\n\u0005U\u0005bCAM\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001bCq!a'\u0001\t#\ni\nC\u0004\u0002 \u0002!I!!)\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006bBAd\u0001\u0011E\u0013\u0011\u001a\u0005\b\u0003\u001f\u0004A\u0011KAi\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!a9\u0001\t\u0013\ti\nC\u0004\u0002f\u0002!I!a:\t\u0011\u0005M\b\u0001\"\u00015\u0003\u001bBQ\"!>\u0001!\u0003\r\t\u0011!C\u0005\u0003o\u0014waBA}e!%\u00111 \u0004\u0007cIBI!!@\t\r9LC\u0011\u0001B\u0005\u0011%\u0011Y!\u000bb\u0001\n\u0013\u0011i\u0001\u0003\u0005\u0003\u001c%\u0002\u000b\u0011\u0002B\b\u0011\u001d\u0011i\"\u000bC\u0001\u0005?AqA!\u0012*\t\u0003\u00119\u0005C\u0004\u0003h%\"\tA!\u001b\t\u0013\tM\u0014&!A\u0005\n\tU$\u0001\u0005+peJ,g\u000e\u001e\"s_\u0006$7-Y:u\u0015\t\u0019D'A\u0005ce>\fGmY1ti*\u0011QGN\u0001\u0006gB\f'o\u001b\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014x-\u0006\u0002<\u0005N!\u0001\u0001P(V!\rid\bQ\u0007\u0002e%\u0011qH\r\u0002\n\u0005J|\u0017\rZ2bgR\u0004\"!\u0011\"\r\u0001\u0011)1\t\u0001b\u0001\u000b\n\tAk\u0001\u0001\u0012\u0005\u0019c\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%a\u0002(pi\"Lgn\u001a\t\u0003\u000f6K!A\u0014%\u0003\u0007\u0005s\u0017\u0010\u0005\u0002Q'6\t\u0011K\u0003\u0002Si\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002U#\n9Aj\\4hS:<\u0007C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\tIwNC\u0001[\u0003\u0011Q\u0017M^1\n\u0005q;&\u0001D*fe&\fG.\u001b>bE2,\u0017aA8cU\u0006\u0011\u0011\u000e\u001a\t\u0003\u000f\u0002L!!\u0019%\u0003\t1{gnZ\u0005\u0003=z\nab]3sS\u0006d\u0017N_3e\u001f:d\u0017\u0010\u0005\u0002HK&\u0011a\r\u0013\u0002\b\u0005>|G.Z1o\u0003))g/\u001b3f]\u000e,G%\r\t\u0004S2\u0004U\"\u00016\u000b\u0005-D\u0015a\u0002:fM2,7\r^\u0005\u0003[*\u0014\u0001b\u00117bgN$\u0016mZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\tA\u001cH/\u001e\u000b\u0003cJ\u00042!\u0010\u0001A\u0011\u00159W\u0001q\u0001i\u0011\u0015iV\u00011\u0001A\u0011\u0015qV\u00011\u0001`\u0011\u0015\u0019W\u00011\u0001e\u0003\u0019yf/\u00197vKV\t\u0001\u0010E\u0002z}\u0002k\u0011A\u001f\u0006\u0003wr\f1A]3g\u0015\ti\u0018,\u0001\u0003mC:<\u0017BA@{\u0005%\u0011VMZ3sK:\u001cW-\u0001\u0006`m\u0006dW/Z0%KF$B!!\u0002\u0002\fA\u0019q)a\u0002\n\u0007\u0005%\u0001J\u0001\u0003V]&$\b\u0002CA\u0007\u000f\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0013'A\u0004`m\u0006dW/\u001a\u0011)\u0007!\t\u0019\u0002E\u0002H\u0003+I1!a\u0006I\u0005%!(/\u00198tS\u0016tG/\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGV\u0011\u0011Q\u0004\t\u0006\u000f\u0006}\u00111E\u0005\u0004\u0003CA%AB(qi&|g\u000e\u0005\u0003\u0002&\u0005%RBAA\u0014\u0015\tAF'\u0003\u0003\u0002,\u0005\u001d\"\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0003Q\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7m\u0018\u0013fcR!\u0011QAA\u0019\u0011%\tiACA\u0001\u0002\u0004\ti\"A\td_6\u0004(/Z:tS>t7i\u001c3fG\u0002B3aCA\n\u0003%\u0011Gn\\2l'&TX-\u0006\u0002\u0002<A\u0019q)!\u0010\n\u0007\u0005}\u0002JA\u0002J]R\fQB\u00197pG.\u001c\u0016N_3`I\u0015\fH\u0003BA\u0003\u0003\u000bB\u0011\"!\u0004\u000e\u0003\u0003\u0005\r!a\u000f\u0002\u0015\tdwnY6TSj,\u0007\u0005K\u0002\u000f\u0003'\tQ\"[:M_\u000e\fG.T1ti\u0016\u0014X#\u00013\u0002#%\u001cHj\\2bY6\u000b7\u000f^3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005M\u0003\u0002CA\u0007!\u0005\u0005\t\u0019\u00013\u0002\u001d%\u001cHj\\2bY6\u000b7\u000f^3sA!\u001a\u0011#a\u0005\u0002\u001f\rDWmY6tk6,e.\u00192mK\u0012\f1c\u00195fG.\u001cX/\\#oC\ndW\rZ0%KF$B!!\u0002\u0002`!A\u0011QB\n\u0002\u0002\u0003\u0007A-\u0001\tdQ\u0016\u001c7n];n\u000b:\f'\r\\3eA\u000591/\u001a;D_:4G\u0003BA\u0003\u0003OBq!!\u001b\u0016\u0001\u0004\tY'\u0001\u0003d_:4\u0007\u0003BA7\u0003_j\u0011\u0001N\u0005\u0004\u0003c\"$!C*qCJ\\7i\u001c8g\u0003-\u0011'o\\1eG\u0006\u001cH/\u00133\u0016\u0005\u0005]\u0004\u0003BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005uD'A\u0004ti>\u0014\u0018mZ3\n\t\u0005\u0005\u00151\u0010\u0002\u0011\u0005J|\u0017\rZ2bgR\u0014En\\2l\u0013\u0012\fAB\u0019:pC\u0012\u001c\u0017m\u001d;JI\u0002\n\u0011B\\;n\u00052|7m[:\u0002\u00159,XN\u00117pG.\u001c\b%A\u0005dQ\u0016\u001c7n];ngV\u0011\u0011Q\u0012\t\u0006\u000f\u0006=\u00151H\u0005\u0004\u0003#C%!B!se\u0006L\u0018!D2iK\u000e\\7/^7t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005]\u0005\"CA\u00077\u0005\u0005\t\u0019AAG\u0003)\u0019\u0007.Z2lgVl7\u000fI\u0001\tO\u0016$h+\u00197vKR\t\u0001)\u0001\u0007dC2\u001c7\t[3dWN,X\u000e\u0006\u0003\u0002<\u0005\r\u0006bBAS=\u0001\u0007\u0011qU\u0001\u0006E2|7m\u001b\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019\u0011QV-\u0002\u00079Lw.\u0003\u0003\u00022\u0006-&A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006YqO]5uK\ncwnY6t)\u0011\tY$a.\t\r\u0005ev\u00041\u0001A\u0003\u00151\u0018\r\\;f\u0003)\u0011X-\u00193CY>\u001c7n\u001d\u000b\u0003\u0003\u007f\u0003RaRAH\u0003\u0003\u0004B!!\u001f\u0002D&!\u0011QYA>\u0005%\u0011En\\2l\t\u0006$\u0018-A\u0006e_Vs\u0007/\u001a:tSN$H\u0003BA\u0003\u0003\u0017Da!!4\"\u0001\u0004!\u0017\u0001\u00032m_\u000e\\\u0017N\\4\u0002\u0013\u0011|G)Z:ue>LH\u0003BA\u0003\u0003'Da!!4#\u0001\u0004!\u0017aC<sSR,wJ\u00196fGR$B!!\u0002\u0002Z\"9\u00111\\\u0012A\u0002\u0005u\u0017aA8viB\u0019a+a8\n\u0007\u0005\u0005xK\u0001\nPE*,7\r^(viB,Ho\u0015;sK\u0006l\u0017A\u0005:fC\u0012\u0014%o\\1eG\u0006\u001cHO\u00117pG.\fqC]3mK\u0006\u001cXM\u00117pG.l\u0015M\\1hKJdunY6\u0015\t\u0005\u0015\u0011\u0011\u001e\u0005\b\u0003W,\u0003\u0019AAw\u0003\u001d\u0011Gn\\2l\u0013\u0012\u0004B!!\u001f\u0002p&!\u0011\u0011_A>\u0005\u001d\u0011En\\2l\u0013\u0012\fa\u0002[1t\u0007\u0006\u001c\u0007.\u001a3WC2,X-\u0001\u0005tkB,'\u000fJ5e+\u0005y\u0016\u0001\u0005+peJ,g\u000e\u001e\"s_\u0006$7-Y:u!\ti\u0014f\u0005\u0004*\u0003\u007f|%Q\u0001\t\u0004\u000f\n\u0005\u0011b\u0001B\u0002\u0011\n1\u0011I\\=SK\u001a\u00042a\u0012B\u0004\u0013\ta\u0006\n\u0006\u0002\u0002|\u0006!Bo\u001c:sK:$(I]8bI\u000e\f7\u000f\u001e'pG.,\"Aa\u0004\u0011\r\tE!qCA<\u001b\t\u0011\u0019BC\u0002\u0003\u0016Q\nA!\u001e;jY&!!\u0011\u0004B\n\u0005\u001dYU-\u001f'pG.\fQ\u0003^8se\u0016tGO\u0011:pC\u0012\u001c\u0017m\u001d;M_\u000e\\\u0007%\u0001\bcY>\u001c7.\u001b4z\u001f\nTWm\u0019;\u0016\t\t\u0005\"q\u0006\u000b\u000b\u0005G\u0011\tDa\r\u00036\t\rC\u0003\u0002B\u0013\u0005O\u0001RaRAH\u0003OC\u0011B!\u000b.\u0003\u0003\u0005\u001dAa\u000b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0003jY\n5\u0002cA!\u00030\u0011)1)\fb\u0001\u000b\"1Q,\fa\u0001\u0005[Aq!a\u000e.\u0001\u0004\tY\u0004C\u0004\u000385\u0002\rA!\u000f\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0003\u0003<\t}RB\u0001B\u001f\u0015\r\u00119\u0004N\u0005\u0005\u0005\u0003\u0012iD\u0001\u0006TKJL\u0017\r\\5{KJDq!!\u0007.\u0001\u0004\ti\"\u0001\tv]\ncwnY6jMf|%M[3diV!!\u0011\nB()!\u0011YEa\u0016\u0003d\t\u0015D\u0003\u0002B'\u0005#\u00022!\u0011B(\t\u0015\u0019eF1\u0001F\u0011%\u0011\u0019FLA\u0001\u0002\b\u0011)&\u0001\u0006fm&$WM\\2fIM\u0002B!\u001b7\u0003N!9!\u0011\f\u0018A\u0002\tm\u0013A\u00022m_\u000e\\7\u000fE\u0003H\u0003\u001f\u0013i\u0006E\u0002W\u0005?J1A!\u0019X\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\t]b\u00061\u0001\u0003:!9\u0011\u0011\u0004\u0018A\u0002\u0005u\u0011!C;oa\u0016\u00148/[:u)!\t)Aa\u001b\u0003n\tE\u0004\"\u000200\u0001\u0004y\u0006B\u0002B8_\u0001\u0007A-\u0001\tsK6|g/\u001a$s_6$%/\u001b<fe\"1\u0011QZ\u0018A\u0002\u0011\f1B]3bIJ+7o\u001c7wKR\u0011!q\u000f\t\u0005\u0005s\u0012Y(D\u0001}\u0013\r\u0011i\b \u0002\u0007\u001f\nTWm\u0019;")
public class TorrentBroadcast<T>
extends Broadcast<T> {
    private final boolean serializedOnly;
    private final ClassTag<T> evidence$1;
    private transient Reference<T> _value;
    private transient Option<CompressionCodec> compressionCodec;
    private transient int blockSize;
    private transient boolean isLocalMaster;
    private boolean checksumEnabled;
    private final BroadcastBlockId broadcastId;
    private final int numBlocks;
    private int[] checksums;

    public static <T> T unBlockifyObject(InputStream[] inputStreamArray, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.unBlockifyObject(inputStreamArray, serializer, option, classTag);
    }

    public static <T> ByteBuffer[] blockifyObject(T t, int n, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.blockifyObject(t, n, serializer, option, classTag);
    }

    private /* synthetic */ long super$id() {
        return super.id();
    }

    private Reference<T> _value() {
        return this._value;
    }

    private void _value_$eq(Reference<T> x$1) {
        this._value = x$1;
    }

    private Option<CompressionCodec> compressionCodec() {
        return this.compressionCodec;
    }

    private void compressionCodec_$eq(Option<CompressionCodec> x$1) {
        this.compressionCodec = x$1;
    }

    private int blockSize() {
        return this.blockSize;
    }

    private void blockSize_$eq(int x$1) {
        this.blockSize = x$1;
    }

    private boolean isLocalMaster() {
        return this.isLocalMaster;
    }

    private void isLocalMaster_$eq(boolean x$1) {
        this.isLocalMaster = x$1;
    }

    private boolean checksumEnabled() {
        return this.checksumEnabled;
    }

    private void checksumEnabled_$eq(boolean x$1) {
        this.checksumEnabled = x$1;
    }

    private void setConf(SparkConf conf) {
        this.compressionCodec_$eq((Option<CompressionCodec>)(BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.BROADCAST_COMPRESS())) ? new Some((Object)CompressionCodec$.MODULE$.createCodec(conf)) : None$.MODULE$));
        this.blockSize_$eq((int)BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.BROADCAST_BLOCKSIZE())) * 1024);
        this.checksumEnabled_$eq(BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.BROADCAST_CHECKSUM())));
        this.isLocalMaster_$eq(Utils$.MODULE$.isLocalMaster(conf));
    }

    private BroadcastBlockId broadcastId() {
        return this.broadcastId;
    }

    private int numBlocks() {
        return this.numBlocks;
    }

    private int[] checksums() {
        return this.checksums;
    }

    private void checksums_$eq(int[] x$1) {
        this.checksums = x$1;
    }

    @Override
    public synchronized T getValue() {
        T memoized;
        T t = memoized = this._value() == null ? null : (T)this._value().get();
        if (memoized != null) {
            return memoized;
        }
        T newlyRead = this.readBroadcastBlock();
        this._value_$eq(this.serializedOnly ? new WeakReference<T>(newlyRead) : new SoftReference<T>(newlyRead));
        return newlyRead;
    }

    private int calcChecksum(ByteBuffer block) {
        Adler32 adler = new Adler32();
        if (block.hasArray()) {
            adler.update(block.array(), block.arrayOffset() + block.position(), block.limit() - block.position());
        } else {
            byte[] bytes = new byte[block.remaining()];
            block.duplicate().get(bytes);
            adler.update(bytes);
        }
        return (int)adler.getValue();
    }

    private int writeBlocks(T value) {
        int n;
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        if (this.serializedOnly && !this.isLocalMaster()) {
            this._value_$eq(new WeakReference<T>(value));
        } else if (!blockManager.putSingle(this.broadcastId(), value, StorageLevel$.MODULE$.MEMORY_AND_DISK(), false, this.evidence$1)) {
            throw SparkException$.MODULE$.internalError(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString(), "BROADCAST");
        }
        try {
            ByteBuffer[] blocks = TorrentBroadcast$.MODULE$.blockifyObject(value, this.blockSize(), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), this.evidence$1);
            if (this.checksumEnabled()) {
                this.checksums_$eq(new int[blocks.length]);
            }
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TorrentBroadcast.$anonfun$writeBlocks$1(this, blockManager, x0$1);
                return BoxedUnit.UNIT;
            });
            n = blocks.length;
        }
        catch (Throwable t) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Store broadcast ").append(this.broadcastId()).append(" fail, remove all pieces of the broadcast").toString());
            blockManager.removeBroadcast(super.id(), true);
            throw t;
        }
        return n;
    }

    private BlockData[] readBlocks() {
        BlockData[] blocks = new BlockData[this.numBlocks()];
        BlockManager bm = SparkEnv$.MODULE$.get().blockManager();
        ((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.numBlocks()), (Integral)Numeric.IntIsIntegral$.MODULE$), Seq$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pid -> {
            BroadcastBlockId pieceId = new BroadcastBlockId(this.super$id(), new StringBuilder(5).append("piece").append(pid).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Reading piece ").append(pieceId).append(" of ").append(this.broadcastId()).toString());
            Option<BlockData> option = bm.getLocalBytes(pieceId);
            if (option instanceof Some) {
                BlockData block;
                Some some = (Some)option;
                blocks$1[pid] = block = (BlockData)some.value();
                this.releaseBlockManagerLock(pieceId);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                ChunkedByteBuffer b;
                Option<ChunkedByteBuffer> option2 = bm.getRemoteBytes(pieceId);
                if (option2 instanceof Some) {
                    int sum;
                    Some some = (Some)option2;
                    b = (ChunkedByteBuffer)some.value();
                    if (this.checksumEnabled() && (sum = this.calcChecksum(b.chunks()[0])) != this.checksums()[pid]) {
                        throw SparkException$.MODULE$.internalError(new StringBuilder(31).append("corrupt remote block ").append(pieceId).append(" of ").append(this.broadcastId()).append(": ").append(sum).append(" != ").append(this.checksums()[pid]).toString(), "BROADCAST");
                    }
                    if (!bm.putBytes(pieceId, b, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                        throw SparkException$.MODULE$.internalError(new StringBuilder(42).append("Failed to store ").append(pieceId).append(" of ").append(this.broadcastId()).append(" in local BlockManager").toString(), "BROADCAST");
                    }
                } else {
                    if (None$.MODULE$.equals(option2)) {
                        throw SparkException$.MODULE$.internalError(new StringBuilder(18).append("Failed to get ").append(pieceId).append(" of ").append(this.broadcastId()).toString(), "BROADCAST");
                    }
                    throw new MatchError(option2);
                }
                blocks$1[pid] = new ByteBufferBlockData(b, true);
                return;
            }
            throw new MatchError(option);
        });
        return blocks;
    }

    @Override
    public void doUnpersist(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), false, blocking);
    }

    @Override
    public void doDestroy(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), true, blocking);
    }

    private void writeObject(ObjectOutputStream out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertValid();
            out.defaultWriteObject();
        });
    }

    private T readBroadcastBlock() {
        return Utils$.MODULE$.tryOrIOException((Function0 & Serializable & scala.Serializable)() -> TorrentBroadcast$.MODULE$.org$apache$spark$broadcast$TorrentBroadcast$$torrentBroadcastLock().withLock(this.broadcastId(), (Function0 & Serializable & scala.Serializable)() -> {
            Map<Object, Object> broadcastCache = SparkEnv$.MODULE$.get().broadcastManager().cachedValues();
            return Option$.MODULE$.apply(broadcastCache.get(this.broadcastId())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                this.setConf(SparkEnv$.MODULE$.get().conf());
                BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
                Option<BlockResult> option = blockManager.getLocalValues(this.broadcastId());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BlockResult blockResult = (BlockResult)some.value();
                    if (blockResult.data().hasNext()) {
                        Object x = blockResult.data().next();
                        this.releaseBlockManagerLock(this.broadcastId());
                        Object object = x != null ? broadcastCache.put(this.broadcastId(), x) : BoxedUnit.UNIT;
                        return x;
                    }
                    throw SparkException$.MODULE$.internalError(new StringBuilder(45).append("Failed to get locally stored broadcast data: ").append(this.broadcastId()).toString(), "BROADCAST");
                }
                if (None$.MODULE$.equals(option)) {
                    Object t;
                    String estimatedTotalSize = Utils$.MODULE$.bytesToString((long)this.numBlocks() * (long)this.blockSize());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Started reading broadcast variable ").append(this.super$id()).append(" with ").append(this.numBlocks()).append(" pieces ").append("(estimated total size ").append(estimatedTotalSize).append(")").toString());
                    long startTimeNs = System.nanoTime();
                    BlockData[] blocks = this.readBlocks();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Reading broadcast variable ").append(this.super$id()).append(" took ").append(Utils$.MODULE$.getUsedTimeNs(startTimeNs)).toString());
                    try {
                        Object obj = TorrentBroadcast$.MODULE$.unBlockifyObject((InputStream[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toInputStream(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InputStream.class))), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), $this.evidence$1);
                        if (!$this.serializedOnly || this.isLocalMaster() || Utils$.MODULE$.isInRunningSparkTask()) {
                            StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_AND_DISK();
                            if (!blockManager.putSingle(this.broadcastId(), obj, storageLevel, false, $this.evidence$1)) {
                                throw SparkException$.MODULE$.internalError(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString(), "BROADCAST");
                            }
                        }
                        Object object = obj != null ? broadcastCache.put(this.broadcastId(), obj) : BoxedUnit.UNIT;
                        t = obj;
                    }
                    finally {
                        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                            x$3.dispose();
                            return BoxedUnit.UNIT;
                        });
                    }
                    return t;
                }
                throw new MatchError(option);
            });
        }));
    }

    private void releaseBlockManagerLock(BlockId blockId) {
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        Option option = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskContext taskContext = (TaskContext)some.value();
            taskContext.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$4 -> {
                blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean hasCachedValue() {
        return BoxesRunTime.unboxToBoolean(TorrentBroadcast$.MODULE$.org$apache$spark$broadcast$TorrentBroadcast$$torrentBroadcastLock().withLock(this.broadcastId(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Some some;
            BlockResult blockResult;
            this.setConf(SparkEnv$.MODULE$.get().conf());
            BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
            Option<BlockResult> option = blockManager.getLocalValues(this.broadcastId());
            if (option instanceof Some && (blockResult = (BlockResult)(some = (Some)option).value()).data().hasNext()) {
                Object x = blockResult.data().next();
                this.releaseBlockManagerLock(this.broadcastId());
                return x != null;
            }
            return false;
        }));
    }

    public static final /* synthetic */ void $anonfun$writeBlocks$1(TorrentBroadcast $this, BlockManager blockManager$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ChunkedByteBuffer bytes;
            BroadcastBlockId pieceId;
            ByteBuffer block = (ByteBuffer)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if ($this.checksumEnabled()) {
                $this.checksums()[i] = $this.calcChecksum(block);
            }
            if (!blockManager$1.putBytes(pieceId = new BroadcastBlockId($this.super$id(), new StringBuilder(5).append("piece").append(i).toString()), bytes = new ChunkedByteBuffer(block.duplicate()), StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                throw SparkException$.MODULE$.internalError(new StringBuilder(42).append("Failed to store ").append(pieceId).append(" of ").append($this.broadcastId()).append(" ").append("in local BlockManager").toString(), "BROADCAST");
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public TorrentBroadcast(T obj, long id, boolean serializedOnly, ClassTag<T> evidence$1) {
        this.serializedOnly = serializedOnly;
        this.evidence$1 = evidence$1;
        super(id, evidence$1);
        this.checksumEnabled = false;
        this.setConf(SparkEnv$.MODULE$.get().conf());
        this.broadcastId = new BroadcastBlockId(super.id(), BroadcastBlockId$.MODULE$.apply$default$2());
        this.numBlocks = this.writeBlocks(obj);
    }
}

