/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.StreamBlockData;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.storage.ExecutorStreamSummary;
import org.apache.spark.ui.storage.ToolTips$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SortedMap$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e!\u0002\f\u0018\u0001e\t\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011-\u0002!\u0011!Q\u0001\n1BQA\r\u0001\u0005\u0002MBQ\u0001\u000f\u0001\u0005\u0002eBaA\u0017\u0001\u0005\u0002]Y\u0006b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007o\u0002\u0001\u000b\u0011\u00026\t\u000fa\u0004!\u0019!C\u0001s\"1q\u0010\u0001Q\u0001\niDq!!\u0001\u0001\t\u0013\t\u0019\u0001\u0003\u0005\u0002\f\u0001!\taFA\u0007\u0011\u001d\tY\u0002\u0001C\u0005\u0003;A\u0001\"!\t\u0001\u0005\u0004%I!\u001b\u0005\b\u0003G\u0001\u0001\u0015!\u0003k\u0011\u001d\t)\u0003\u0001C\u0005\u0003OAq!!\r\u0001\t\u0013\t\u0019\u0004\u0003\u0005\u0002N\u0001\u0011\r\u0011\"\u0003j\u0011\u001d\ty\u0005\u0001Q\u0001\n)Dq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002Z\u0001!I!a\u0017\t\u0011\u0005]\u0004\u0001\"\u0001\u0018\u0003s\u00121b\u0015;pe\u0006<W\rU1hK*\u0011\u0001$G\u0001\bgR|'/Y4f\u0015\tQ2$\u0001\u0002vS*\u0011A$H\u0001\u0006gB\f'o\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0005\u0002\u0001EA\u00111\u0005J\u0007\u00023%\u0011Q%\u0007\u0002\n/\u0016\u0014W+\u0013)bO\u0016\fa\u0001]1sK:$8\u0001\u0001\t\u0003G%J!AK\r\u0003\u0015M\u0003\u0018M]6V\u0013R\u000b'-A\u0003ti>\u0014X\r\u0005\u0002.a5\taF\u0003\u000207\u000511\u000f^1ukNL!!\r\u0018\u0003\u001d\u0005\u0003\bo\u0015;biV\u001c8\u000b^8sK\u00061A(\u001b8jiz\"2\u0001\u000e\u001c8!\t)\u0004!D\u0001\u0018\u0011\u001513\u00011\u0001)\u0011\u0015Y3\u00011\u0001-\u0003\u0019\u0011XM\u001c3feR\u0011!H\u0014\t\u0004w\u0015CeB\u0001\u001fC\u001d\ti\u0004)D\u0001?\u0015\tyt%\u0001\u0004=e>|GOP\u0005\u0002\u0003\u0006)1oY1mC&\u00111\tR\u0001\ba\u0006\u001c7.Y4f\u0015\u0005\t\u0015B\u0001$H\u0005\r\u0019V-\u001d\u0006\u0003\u0007\u0012\u0003\"!\u0013'\u000e\u0003)S!a\u0013#\u0002\u0007alG.\u0003\u0002N\u0015\n!aj\u001c3f\u0011\u0015yE\u00011\u0001Q\u0003\u001d\u0011X-];fgR\u0004\"!\u0015-\u000e\u0003IS!a\u0015+\u0002\t!$H\u000f\u001d\u0006\u0003+Z\u000bqa]3sm2,GOC\u0001X\u0003\u0015Q\u0017M^1y\u0013\tI&K\u0001\nIiR\u00048+\u001a:wY\u0016$(+Z9vKN$\u0018\u0001\u0003:eIR\u000b'\r\\3\u0015\u0007ibV\fC\u0003P\u000b\u0001\u0007\u0001\u000bC\u0003_\u000b\u0001\u0007q,\u0001\u0003sI\u0012\u001c\bcA\u001eFAB\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\u0003mFR!!\u001a\u0018\u0002\u0007\u0005\u0004\u0018.\u0003\u0002hE\nq!\u000b\u0012#Ti>\u0014\u0018mZ3J]\u001a|\u0017!\u0003:eI\"+\u0017\rZ3s+\u0005Q\u0007cA6o_6\tAN\u0003\u0002n\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0019c\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0011a\u0017M\\4\u000b\u0003Q\fAA[1wC&\u0011a/\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015I$G\rS3bI\u0016\u0014\b%\u0001\u0005u_>dG/\u001b9t+\u0005Q\bcA6owB\u0019A0`8\u000e\u0003\u0011K!A #\u0003\r=\u0003H/[8o\u0003%!xn\u001c7uSB\u001c\b%\u0001\u0004sI\u0012\u0014vn\u001e\u000b\u0006u\u0005\u0015\u0011q\u0001\u0005\u0006\u001f*\u0001\r\u0001\u0015\u0005\u0007\u0003\u0013Q\u0001\u0019\u00011\u0002\u0007I$G-A\nsK\u000e,\u0017N^3s\u00052|7m\u001b+bE2,7\u000fF\u0002;\u0003\u001fAq!!\u0005\f\u0001\u0004\t\u0019\"\u0001\u0004cY>\u001c7n\u001d\t\u0005w\u0015\u000b)\u0002E\u0002.\u0003/I1!!\u0007/\u0005=\u0019FO]3b[\ncwnY6ECR\f\u0017\u0001F3yK\u000e,Ho\u001c:NKR\u0014\u0018nY:UC\ndW\rF\u0002;\u0003?Aq!!\u0005\r\u0001\u0004\t\u0019\"\u0001\u000efq\u0016\u001cW\u000f^8s\u001b\u0016$(/[2t)\u0006\u0014G.\u001a%fC\u0012,'/A\u000efq\u0016\u001cW\u000f^8s\u001b\u0016$(/[2t)\u0006\u0014G.\u001a%fC\u0012,'\u000fI\u0001\u0018Kb,7-\u001e;pe6+GO]5dgR\u000b'\r\\3S_^$2AOA\u0015\u0011\u0019ys\u00021\u0001\u0002,A\u0019Q'!\f\n\u0007\u0005=rCA\u000bFq\u0016\u001cW\u000f^8s'R\u0014X-Y7Tk6l\u0017M]=\u0002!M$(/Z1n\u00052|7m\u001b+bE2,Gc\u0001\u001e\u00026!9\u0011\u0011\u0003\tA\u0002\u0005]\u0002\u0003B\u001eF\u0003s\u0001r\u0001`A\u001e\u0003\u007f\t\u0019\"C\u0002\u0002>\u0011\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BA!\u0003\u0013rA!a\u0011\u0002FA\u0011Q\bR\u0005\u0004\u0003\u000f\"\u0015A\u0002)sK\u0012,g-C\u0002w\u0003\u0017R1!a\u0012E\u0003Y\u0019HO]3b[\ncwnY6UC\ndW\rS3bI\u0016\u0014\u0018aF:ue\u0016\fWN\u00117pG.$\u0016M\u00197f\u0011\u0016\fG-\u001a:!\u0003M\u0019HO]3b[\ncwnY6UC\ndWMU8x)\rQ\u0014Q\u000b\u0005\b\u0003/\u001a\u0002\u0019AA\u001d\u0003\u0015\u0011Gn\\2l\u0003Y\u0019HO]3b[\ncwnY6UC\ndWmU;ce><H#\u0003\u001e\u0002^\u0005\u0005\u00141MA7\u0011\u001d\ty\u0006\u0006a\u0001\u0003\u007f\tqA\u00197pG.LE\rC\u0004\u0002XQ\u0001\r!!\u0006\t\u000f\u0005\u0015D\u00031\u0001\u0002h\u0005Y!/\u001a9mS\u000e\fG/[8o!\ra\u0018\u0011N\u0005\u0004\u0003W\"%aA%oi\"9\u0011q\u000e\u000bA\u0002\u0005E\u0014a\u00034jeN$8+\u001e2s_^\u00042\u0001`A:\u0013\r\t)\b\u0012\u0002\b\u0005>|G.Z1o\u0003%\u001aHO]3b[\ncwnY6Ti>\u0014\u0018mZ3MKZ,G\u000eR3tGJL\u0007\u000f^5p]\u0006sGmU5{KR!\u00111PAB!\u001da\u00181HA \u0003{\u00022\u0001`A@\u0013\r\t\t\t\u0012\u0002\u0005\u0019>tw\rC\u0004\u0002XU\u0001\r!!\u0006")
public class StoragePage
extends WebUIPage {
    private final SparkUITab parent;
    private final AppStatusStore store;
    private final Seq<String> rddHeader;
    private final Seq<Option<String>> tooltips;
    private final Seq<String> executorMetricsTableHeader;
    private final Seq<String> streamBlockTableHeader;

    @Override
    public Seq<Node> render(HttpServletRequest request) {
        Seq content = (Seq)this.rddTable(request, this.store.rddList(this.store.rddList$default$1())).$plus$plus(this.receiverBlockTables(this.store.streamBlocksList()), Seq$.MODULE$.canBuildFrom());
        return UIUtils$.MODULE$.headerSparkPage(request, "Storage", (Function0<Seq<Node>>)(Function0 & Serializable & scala.Serializable)() -> content, this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> rddTable(HttpServletRequest request, Seq<RDDStorageInfo> rdds) {
        void var3_3;
        if (rdds.isEmpty()) {
            return Nil$.MODULE$;
        }
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-rdds','aggregated-rdds')"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-rdds collapse-table"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n            "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md2);
        $buf3.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf3.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("RDDs"));
        $buf3.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-rdds collapsible-table"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Seq<String> x$12 = this.rddHeader();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)x$1 -> this.rddRow(request, (RDDStorageInfo)x$1);
        Seq<RDDStorageInfo> x$3 = rdds;
        Some x$4 = new Some((Object)"storage-by-rdd-table");
        Seq<Option<String>> x$5 = this.tooltips();
        boolean x$6 = UIUtils$.MODULE$.listingTable$default$4();
        Seq<String> x$7 = UIUtils$.MODULE$.listingTable$default$6();
        boolean x$8 = UIUtils$.MODULE$.listingTable$default$7();
        boolean x$9 = UIUtils$.MODULE$.listingTable$default$8();
        $buf5.$amp$plus(UIUtils$.MODULE$.listingTable(x$12, x$2, x$3, x$6, (Option<String>)x$4, x$7, x$8, x$9, x$5));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    private Seq<String> rddHeader() {
        return this.rddHeader;
    }

    public Seq<Option<String>> tooltips() {
        return this.tooltips;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> rddRow(HttpServletRequest request, RDDStorageInfo rdd) {
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)rdd.id()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", new StringOps(Predef$.MODULE$.augmentString("%s/storage/rdd/?id=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), BoxesRunTime.boxToInteger((int)rdd.id())})), (MetaData)$md);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)rdd.name());
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)rdd.storageLevel());
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)Integer.toString(rdd.numCachedPartitions()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new StringOps(Predef$.MODULE$.augmentString("%.2f%%")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)rdd.numCachedPartitions() * 100.0 / (double)rdd.numPartitions()))})));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("sorttable_customkey", Long.toString(rdd.memoryUsed()), (MetaData)$md2);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)Utils$.MODULE$.bytesToString(rdd.memoryUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("sorttable_customkey", Long.toString(rdd.diskUsed()), (MetaData)$md3);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)Utils$.MODULE$.bytesToString(rdd.diskUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> receiverBlockTables(Seq<StreamBlockData> blocks) {
        void var3_3;
        if (blocks.isEmpty()) {
            return Nil$.MODULE$;
        }
        Seq sorted = (Seq)blocks.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._1(), (Ordering)Ordering.String$.MODULE$);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Receiver Blocks"));
        $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus(this.executorMetricsTable(blocks));
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus(this.streamBlockTable((Seq<Tuple2<String, Seq<StreamBlockData>>>)sorted));
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> executorMetricsTable(Seq<StreamBlockData> blocks) {
        void var3_3;
        Iterable blockManagers = (Iterable)SortedMap$.MODULE$.apply(blocks.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.executorId()).toSeq(), (Ordering)Ordering.String$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq blocks = (Seq)tuple2._2();
                return new ExecutorStreamSummary((Seq<StreamBlockData>)blocks);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Aggregated Block Metrics by Executor"));
        $buf.$amp$plus((Object)new Elem(null, "h5", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        Seq<String> x$1 = this.executorMetricsTableHeader();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)status -> this.executorMetricsTableRow((ExecutorStreamSummary)status);
        Iterable x$3 = blockManagers;
        Some x$42 = new Some((Object)"storage-by-executor-stream-blocks");
        boolean x$5 = UIUtils$.MODULE$.listingTable$default$4();
        Seq<String> x$6 = UIUtils$.MODULE$.listingTable$default$6();
        boolean x$7 = UIUtils$.MODULE$.listingTable$default$7();
        boolean x$8 = UIUtils$.MODULE$.listingTable$default$8();
        Seq<Option<String>> x$9 = UIUtils$.MODULE$.listingTable$default$9();
        $buf.$amp$plus(UIUtils$.MODULE$.listingTable(x$1, x$2, x$3, x$5, (Option<String>)x$42, x$6, x$7, x$8, x$9));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    private Seq<String> executorMetricsTableHeader() {
        return this.executorMetricsTableHeader;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> executorMetricsTableRow(ExecutorStreamSummary status) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)status.executorId());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)status.location());
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", Long.toString(status.totalMemSize()), (MetaData)$md);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(status.totalMemSize()));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("sorttable_customkey", Long.toString(status.totalDiskSize()), (MetaData)$md2);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)Utils$.MODULE$.bytesToString(status.totalDiskSize()));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)Integer.toString(status.numStreamBlocks()));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> streamBlockTable(Seq<Tuple2<String, Seq<StreamBlockData>>> blocks) {
        void var2_2;
        void var3_3;
        if (blocks.isEmpty()) {
            return Nil$.MODULE$;
        }
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Blocks"));
        $buf.$amp$plus((Object)new Elem(null, "h5", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n        "));
        Seq<String> x$1 = this.streamBlockTableHeader();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)block -> this.streamBlockTableRow((Tuple2<String, Seq<StreamBlockData>>)block);
        Seq<Tuple2<String, Seq<StreamBlockData>>> x$3 = blocks;
        Some x$4 = new Some((Object)"storage-by-block-table");
        boolean x$5 = false;
        boolean x$6 = UIUtils$.MODULE$.listingTable$default$4();
        Seq<String> x$7 = UIUtils$.MODULE$.listingTable$default$6();
        boolean x$8 = UIUtils$.MODULE$.listingTable$default$7();
        Seq<Option<String>> x$9 = UIUtils$.MODULE$.listingTable$default$9();
        $buf.$amp$plus(UIUtils$.MODULE$.listingTable(x$1, x$2, x$3, x$6, (Option<String>)x$4, x$7, x$8, x$5, x$9));
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    private Seq<String> streamBlockTableHeader() {
        return this.streamBlockTableHeader;
    }

    private Seq<Node> streamBlockTableRow(Tuple2<String, Seq<StreamBlockData>> block) {
        Seq replications = (Seq)block._2();
        Predef$.MODULE$.assert(replications.nonEmpty());
        if (replications.size() == 1) {
            return this.streamBlockTableSubrow((String)block._1(), (StreamBlockData)replications.head(), replications.size(), true);
        }
        return (Seq)this.streamBlockTableSubrow((String)block._1(), (StreamBlockData)replications.head(), replications.size(), true).$plus$plus((GenTraversableOnce)((TraversableLike)replications.tail()).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> this.streamBlockTableSubrow((String)block._1(), (StreamBlockData)x$5, replications.size(), false), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Node> streamBlockTableSubrow(String blockId, StreamBlockData block, int replication, boolean firstSubrow) {
        BoxedUnit boxedUnit;
        Tuple2<String, Object> tuple2 = this.streamBlockStorageLevelDescriptionAndSize(block);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String storageLevel = (String)tuple2._1();
        long size = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)storageLevel, (Object)BoxesRunTime.boxToLong((long)size));
        String storageLevel2 = (String)tuple22._1();
        long size2 = tuple22._2$mcJ$sp();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        if (firstSubrow) {
            NodeBuffer $buf2 = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rowspan", Integer.toString(replication), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)block.name());
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("rowspan", Integer.toString(replication), (MetaData)$md2);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            "));
            $buf4.$amp$plus((Object)Integer.toString(replication));
            $buf4.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            boxedUnit = $buf2;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $buf.$amp$plus((Object)boxedUnit);
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)block.hostPort());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)storageLevel2);
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)Utils$.MODULE$.bytesToString(size2));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public Tuple2<String, Object> streamBlockStorageLevelDescriptionAndSize(StreamBlockData block) {
        if (block.useDisk()) {
            return new Tuple2((Object)"Disk", (Object)BoxesRunTime.boxToLong((long)block.diskSize()));
        }
        if (block.useMemory() && block.deserialized()) {
            return new Tuple2((Object)"Memory", (Object)BoxesRunTime.boxToLong((long)block.memSize()));
        }
        if (block.useMemory() && !block.deserialized()) {
            return new Tuple2((Object)"Memory Serialized", (Object)BoxesRunTime.boxToLong((long)block.memSize()));
        }
        throw new IllegalStateException(new StringBuilder(23).append("Invalid Storage Level: ").append(block.storageLevel()).toString());
    }

    public StoragePage(SparkUITab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("");
        this.rddHeader = (Seq)new .colon.colon((Object)"ID", (List)new .colon.colon((Object)"RDD Name", (List)new .colon.colon((Object)"Storage Level", (List)new .colon.colon((Object)"Cached Partitions", (List)new .colon.colon((Object)"Fraction Cached", (List)new .colon.colon((Object)"Size in Memory", (List)new .colon.colon((Object)"Size on Disk", (List)Nil$.MODULE$)))))));
        this.tooltips = (Seq)new .colon.colon((Object)None$.MODULE$, (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.RDD_NAME()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.STORAGE_LEVEL()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.CACHED_PARTITIONS()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.FRACTION_CACHED()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.SIZE_IN_MEMORY()), (List)new .colon.colon((Object)new Some((Object)ToolTips$.MODULE$.SIZE_ON_DISK()), (List)Nil$.MODULE$)))))));
        this.executorMetricsTableHeader = (Seq)new .colon.colon((Object)"Executor ID", (List)new .colon.colon((Object)"Address", (List)new .colon.colon((Object)"Total Size in Memory", (List)new .colon.colon((Object)"Total Size on Disk", (List)new .colon.colon((Object)"Stream Blocks", (List)Nil$.MODULE$)))));
        this.streamBlockTableHeader = (Seq)new .colon.colon((Object)"Block ID", (List)new .colon.colon((Object)"Replication Level", (List)new .colon.colon((Object)"Location", (List)new .colon.colon((Object)"Storage Level", (List)new .colon.colon((Object)"Size", (List)Nil$.MODULE$)))));
    }
}

