/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.debug;

import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.expressions.codegen.ByteCodeStats;
import org.apache.spark.sql.catalyst.expressions.codegen.ByteCodeStats$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.util.StringConcat;
import org.apache.spark.sql.catalyst.util.StringConcat$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.WholeStageCodegenExec;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.debug.package;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public void org$apache$spark$sql$execution$debug$package$$debugPrint(String msg) {
        Predef$.MODULE$.println((Object)msg);
    }

    public String codegenString(SparkPlan plan) {
        StringConcat concat = new StringConcat(StringConcat$.MODULE$.$lessinit$greater$default$1());
        this.writeCodegen((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        }, plan);
        return concat.toString();
    }

    public void writeCodegen(Function1<String, BoxedUnit> append, SparkPlan plan) {
        Seq<Tuple3<String, String, ByteCodeStats>> codegenSeq = this.codegenStringSeq(plan);
        append.apply((Object)new StringBuilder(35).append("Found ").append(codegenSeq.size()).append(" WholeStageCodegen subtrees.\n").toString());
        ((TraversableLike)codegenSeq.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$writeCodegen$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            package$.$anonfun$writeCodegen$2(append, codegenSeq, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Tuple3<String, String, ByteCodeStats>> codegenStringSeq(SparkPlan plan) {
        HashSet codegenSubtrees = new HashSet();
        package$.findSubtrees$1(plan, codegenSubtrees);
        return (Seq)((TraversableLike)codegenSubtrees.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.codegenStageId()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)subtree -> {
            ByteCodeStats byteCodeStats;
            Tuple2<CodegenContext, CodeAndComment> tuple2 = subtree.doCodeGen();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            CodeAndComment source = (CodeAndComment)tuple2._2();
            CodeAndComment source2 = source;
            try {
                byteCodeStats = (ByteCodeStats)CodeGenerator$.MODULE$.compile(source2)._2();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    byteCodeStats = ByteCodeStats$.MODULE$.UNAVAILABLE();
                }
                throw throwable;
            }
            ByteCodeStats codeStats = byteCodeStats;
            return new Tuple3((Object)subtree.toString(), (Object)CodeFormatter$.MODULE$.format(source2, CodeFormatter$.MODULE$.format$default$2()), (Object)codeStats);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public String codegenString(StreamingQuery query) {
        StreamExecution w = this.asStreamExecution(query);
        if (w.lastExecution() != null) {
            return this.codegenString(w.lastExecution().executedPlan());
        }
        return "No physical plan. Waiting for data.";
    }

    public Seq<Tuple3<String, String, ByteCodeStats>> codegenStringSeq(StreamingQuery query) {
        StreamExecution w = this.asStreamExecution(query);
        if (w.lastExecution() != null) {
            return this.codegenStringSeq(w.lastExecution().executedPlan());
        }
        return (Seq)Nil$.MODULE$;
    }

    private StreamExecution asStreamExecution(StreamingQuery query) {
        StreamingQuery streamingQuery = query;
        if (streamingQuery instanceof StreamingQueryWrapper) {
            StreamingQueryWrapper streamingQueryWrapper = (StreamingQueryWrapper)streamingQuery;
            return streamingQueryWrapper.streamingQuery();
        }
        if (streamingQuery instanceof StreamExecution) {
            StreamExecution streamExecution = (StreamExecution)streamingQuery;
            return streamExecution;
        }
        throw new IllegalArgumentException("Parameter should be an instance of StreamExecution!");
    }

    public package.DebugQuery DebugQuery(Dataset<?> query) {
        return new package.DebugQuery(query);
    }

    public package.DebugStreamQuery DebugStreamQuery(StreamingQuery query) {
        return new package.DebugStreamQuery(query);
    }

    public static final /* synthetic */ boolean $anonfun$writeCodegen$1(Tuple2 check$ifrefutable$1) {
        Tuple3 tuple3;
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null && (tuple3 = (Tuple3)tuple2._1()) != null;
    }

    public static final /* synthetic */ void $anonfun$writeCodegen$2(Function1 append$1, Seq codegenSeq$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (tuple3 != null) {
                String string;
                String subtree = (String)tuple3._1();
                String code = (String)tuple3._2();
                ByteCodeStats codeStats = (ByteCodeStats)tuple3._3();
                if (codeStats.maxConstPoolSize() > 0) {
                    double rt = 100.0 * (double)codeStats.maxConstPoolSize() / (double)65535;
                    string = new StringOps(Predef$.MODULE$.augmentString("(%.2f%% used)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rt)}));
                } else {
                    string = "";
                }
                String usedConstPoolRatio = string;
                String codeStatsStr = new StringBuilder(58).append("maxMethodCodeSize:").append(codeStats.maxMethodCodeSize()).append("; ").append("maxConstantPoolSize:").append(codeStats.maxConstPoolSize()).append(usedConstPoolRatio).append("; ").append("numInnerClasses:").append(codeStats.numInnerClasses()).toString();
                append$1.apply((Object)new StringBuilder(21).append("== Subtree ").append(i + 1).append(" / ").append(codegenSeq$1.size()).append(" (").append(codeStatsStr).append(") ==\n").toString());
                append$1.apply((Object)subtree);
                append$1.apply((Object)"\nGenerated code:\n");
                BoxedUnit cfr_ignored_0 = (BoxedUnit)append$1.apply((Object)new StringBuilder(1).append(code).append("\n").toString());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$codegenStringSeq$1(HashSet codegenSubtrees$1, SparkPlan x0$1) {
        SparkPlan sparkPlan = x0$1;
        if (sparkPlan instanceof WholeStageCodegenExec) {
            WholeStageCodegenExec wholeStageCodegenExec = (WholeStageCodegenExec)sparkPlan;
            codegenSubtrees$1.$plus$eq((Object)wholeStageCodegenExec);
            return;
        }
        if (sparkPlan instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
            package$.findSubtrees$1(adaptiveSparkPlanExec.executedPlan(), codegenSubtrees$1);
            return;
        }
        if (sparkPlan instanceof QueryStageExec) {
            QueryStageExec queryStageExec = (QueryStageExec)sparkPlan;
            package$.findSubtrees$1(queryStageExec.plan(), codegenSubtrees$1);
            return;
        }
        sparkPlan.subqueries().foreach((Function1 & Serializable & scala.Serializable)plan -> {
            package$.findSubtrees$1(plan, codegenSubtrees$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final void findSubtrees$1(SparkPlan plan, HashSet codegenSubtrees$1) {
        plan.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            package$.$anonfun$codegenStringSeq$1(codegenSubtrees$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private package$() {
        MODULE$ = this;
    }
}

