/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.Iterator;
import java.util.TreeMap;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.WatermarkPropagator;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3AAC\u0006\u00011!)1\u0005\u0001C\u0001I!9a\u0005\u0001b\u0001\n\u00139\u0003BB\u001a\u0001A\u0003%\u0001\u0006C\u00035\u0001\u0011%Q\u0007C\u0003<\u0001\u0011\u0005C\bC\u0003J\u0001\u0011%!\nC\u0003O\u0001\u0011\u0005q\nC\u0003S\u0001\u0011\u00051\u000bC\u0003W\u0001\u0011\u0005sK\u0001\u000fVg\u0016\u001c\u0016N\\4mK^\u000bG/\u001a:nCJ\\\u0007K]8qC\u001e\fGo\u001c:\u000b\u00051i\u0011!C:ue\u0016\fW.\u001b8h\u0015\tqq\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001#E\u0001\u0004gFd'B\u0001\n\u0014\u0003\u0015\u0019\b/\u0019:l\u0015\t!R#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0013%D\u0001\f\u0013\t\u00113BA\nXCR,'/\\1sWB\u0013x\u000e]1hCR|'/\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011\u0001\u0005A\u0001\u0013E\u0006$8\r[%e)><\u0016\r^3s[\u0006\u00148.F\u0001)!\u0011Ic\u0006\r\u0019\u000e\u0003)R!a\u000b\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0002[\u0005!!.\u0019<b\u0013\ty#FA\u0004Ue\u0016,W*\u00199\u0011\u0005i\t\u0014B\u0001\u001a\u001c\u0005\u0011auN\\4\u0002'\t\fGo\u00195JIR{w+\u0019;fe6\f'o\u001b\u0011\u0002\u001b%\u001c\u0018J\\5uS\u0006d\u0017N_3e)\t1\u0014\b\u0005\u0002\u001bo%\u0011\u0001h\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015QD\u00011\u00011\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\f\u0011\u0002\u001d:pa\u0006<\u0017\r^3\u0015\tu\u0002\u0015i\u0012\t\u00035yJ!aP\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006u\u0015\u0001\r\u0001\r\u0005\u0006\u0005\u0016\u0001\raQ\u0001\u0005a2\fg\u000e\u0005\u0002E\u000b6\tQ\"\u0003\u0002G\u001b\tI1\u000b]1sWBc\u0017M\u001c\u0005\u0006\u0011\u0016\u0001\r\u0001M\u0001\u0010_JLw-\u001b8XCR,'/\\1sW\u0006\tr-\u001a;J]B,HoV1uKJl\u0017M]6\u0015\u0007AZE\nC\u0003;\r\u0001\u0007\u0001\u0007C\u0003N\r\u0001\u0007\u0001'A\u0005ti\u0006$Xm\u00149JI\u0006qr-\u001a;J]B,HoV1uKJl\u0017M]6G_Jd\u0015\r^3Fm\u0016tGo\u001d\u000b\u0004aA\u000b\u0006\"\u0002\u001e\b\u0001\u0004\u0001\u0004\"B'\b\u0001\u0004\u0001\u0014\u0001H4fi&s\u0007/\u001e;XCR,'/\\1sW\u001a{'/\u0012<jGRLwN\u001c\u000b\u0004aQ+\u0006\"\u0002\u001e\t\u0001\u0004\u0001\u0004\"B'\t\u0001\u0004\u0001\u0014!\u00029ve\u001e,GCA\u001fY\u0011\u0015Q\u0014\u00021\u00011\u0001")
public class UseSingleWatermarkPropagator
implements WatermarkPropagator {
    private final TreeMap<Object, Object> batchIdToWatermark = new TreeMap();

    private TreeMap<Object, Object> batchIdToWatermark() {
        return this.batchIdToWatermark;
    }

    private boolean isInitialized(long batchId) {
        return this.batchIdToWatermark().containsKey(BoxesRunTime.boxToLong((long)batchId));
    }

    @Override
    public void propagate(long batchId, SparkPlan plan, long originWatermark) {
        if (batchId < 0L) {
            return;
        }
        if (this.isInitialized(batchId)) {
            long cached = BoxesRunTime.unboxToLong((Object)this.batchIdToWatermark().get(BoxesRunTime.boxToLong((long)batchId)));
            Predef$.MODULE$.assert(cached == originWatermark, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(93).append("Watermark has been changed for the same batch ID! Batch ID: ").append(batchId).append(", ").append("Value in cache: ").append(cached).append(", value given: ").append(originWatermark).toString());
            return;
        }
        this.batchIdToWatermark().put(BoxesRunTime.boxToLong((long)batchId), BoxesRunTime.boxToLong((long)originWatermark));
    }

    private long getInputWatermark(long batchId, long stateOpId) {
        if (batchId < 0L) {
            return 0L;
        }
        Predef$.MODULE$.assert(this.isInitialized(batchId), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(39).append("Watermark for batch ID ").append(batchId).append(" is not yet set!").toString());
        return BoxesRunTime.unboxToLong((Object)this.batchIdToWatermark().get(BoxesRunTime.boxToLong((long)batchId)));
    }

    @Override
    public long getInputWatermarkForLateEvents(long batchId, long stateOpId) {
        return this.getInputWatermark(batchId, stateOpId);
    }

    @Override
    public long getInputWatermarkForEviction(long batchId, long stateOpId) {
        return this.getInputWatermark(batchId, stateOpId);
    }

    @Override
    public void purge(long batchId) {
        Iterator<Object> keyIter = this.batchIdToWatermark().keySet().iterator();
        boolean stopIter = false;
        while (keyIter.hasNext() && !stopIter) {
            long currKey = BoxesRunTime.unboxToLong((Object)keyIter.next());
            if (currKey <= batchId) {
                keyIter.remove();
                continue;
            }
            stopIter = true;
        }
    }
}

