/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.mesos;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.shuffle.ExternalBlockStoreClient;
import org.apache.spark.network.shuffle.protocol.mesos.RegisterDriver;
import org.apache.spark.network.shuffle.protocol.mesos.ShuffleServiceHeartbeat;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.util.concurrent.ThreadFactoryBuilder;

public class MesosExternalBlockStoreClient
extends ExternalBlockStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(MesosExternalBlockStoreClient.class);
    private final ScheduledExecutorService heartbeaterThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("mesos-external-shuffle-client-heartbeater").build());

    public MesosExternalBlockStoreClient(TransportConf conf, SecretKeyHolder secretKeyHolder, boolean authEnabled, long registrationTimeoutMs) {
        super(conf, secretKeyHolder, authEnabled, registrationTimeoutMs);
    }

    public void registerDriverWithShuffleService(String host, int port, long heartbeatTimeoutMs, long heartbeatIntervalMs) throws IOException, InterruptedException {
        this.checkInit();
        ByteBuffer registerDriver = new RegisterDriver(this.appId, heartbeatTimeoutMs).toByteBuffer();
        TransportClient client = this.clientFactory.createClient(host, port);
        client.sendRpc(registerDriver, (RpcResponseCallback)new RegisterDriverCallback(client, heartbeatIntervalMs));
    }

    public void close() {
        this.heartbeaterThread.shutdownNow();
        super.close();
    }

    private class Heartbeater
    implements Runnable {
        private final TransportClient client;

        private Heartbeater(TransportClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            this.client.send(new ShuffleServiceHeartbeat(MesosExternalBlockStoreClient.this.appId).toByteBuffer());
        }
    }

    private class RegisterDriverCallback
    implements RpcResponseCallback {
        private final TransportClient client;
        private final long heartbeatIntervalMs;

        private RegisterDriverCallback(TransportClient client, long heartbeatIntervalMs) {
            this.client = client;
            this.heartbeatIntervalMs = heartbeatIntervalMs;
        }

        public void onSuccess(ByteBuffer response) {
            MesosExternalBlockStoreClient.this.heartbeaterThread.scheduleAtFixedRate(new Heartbeater(this.client), 0L, this.heartbeatIntervalMs, TimeUnit.MILLISECONDS);
            logger.info("Successfully registered app " + MesosExternalBlockStoreClient.this.appId + " with external shuffle service.");
        }

        public void onFailure(Throwable e) {
            logger.warn("Unable to register app " + MesosExternalBlockStoreClient.this.appId + " with external shuffle service. Please manually remove shuffle data after driver exit. Error: " + e);
        }
    }
}

