/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.model.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.function.BooleanSupplier;

public class SettableBeanPropertyDelegate
extends SettableBeanProperty {
    private final SettableBeanProperty delegate;
    private final SettableAnyProperty anySetter;
    private final transient BooleanSupplier useAnySetter;

    SettableBeanPropertyDelegate(SettableBeanProperty delegate, SettableAnyProperty anySetter, BooleanSupplier useAnySetter) {
        super(delegate);
        this.delegate = delegate;
        this.anySetter = anySetter;
        this.useAnySetter = useAnySetter;
    }

    public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new SettableBeanPropertyDelegate(this.delegate.withValueDeserializer(deser), this.anySetter, this.useAnySetter);
    }

    public SettableBeanProperty withName(PropertyName newName) {
        return new SettableBeanPropertyDelegate(this.delegate.withName(newName), this.anySetter, this.useAnySetter);
    }

    public SettableBeanProperty withNullProvider(NullValueProvider nva) {
        return new SettableBeanPropertyDelegate(this.delegate.withNullProvider(nva), this.anySetter, this.useAnySetter);
    }

    public AnnotatedMember getMember() {
        return this.delegate.getMember();
    }

    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return (A)this.delegate.getAnnotation(acls);
    }

    public void fixAccess(DeserializationConfig config) {
        this.delegate.fixAccess(config);
    }

    public void markAsIgnorable() {
        this.delegate.markAsIgnorable();
    }

    public boolean isIgnorable() {
        return this.delegate.isIgnorable();
    }

    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        try {
            this.delegate.deserializeAndSet(p, ctxt, instance);
        }
        catch (MismatchedInputException ex) {
            if (this.shouldUseAnySetter()) {
                this.anySetter.set(instance, (Object)this.delegate.getName(), (Object)p.getText());
            }
            throw ex;
        }
    }

    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        try {
            return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
        }
        catch (MismatchedInputException ex) {
            this.deserializeAndSet(p, ctxt, instance);
            return null;
        }
    }

    public void set(Object instance, Object value) throws IOException {
        this.delegate.set(instance, value);
    }

    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this.delegate.setAndReturn(instance, value);
    }

    private boolean shouldUseAnySetter() {
        if (this.anySetter == null) {
            return false;
        }
        return this.useAnySetter.getAsBoolean();
    }
}

