/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;

public final class LogisticRegressionWithElasticNetExample$ {
    public static LogisticRegressionWithElasticNetExample$ MODULE$;

    static {
        new LogisticRegressionWithElasticNetExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("LogisticRegressionWithElasticNetExample").getOrCreate();
        Dataset training = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.fit(training);
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("Coefficients: ").append(lrModel.coefficients()).append(" Intercept: ").append(lrModel.intercept()).toString());
        LogisticRegression mlr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8).setFamily("multinomial");
        LogisticRegressionModel mlrModel = (LogisticRegressionModel)mlr.fit(training);
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("Multinomial coefficients: ").append(mlrModel.coefficientMatrix()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("Multinomial intercepts: ").append(mlrModel.interceptVector()).toString());
        spark.stop();
    }

    private LogisticRegressionWithElasticNetExample$() {
        MODULE$ = this;
    }
}

