/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.MultivariateSummarizer;
import org.apache.spark.examples.mllib.MultivariateSummarizer$Params$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class MultivariateSummarizer$ {
    public static MultivariateSummarizer$ MODULE$;

    static {
        new MultivariateSummarizer$();
    }

    public void main(String[] args) {
        MultivariateSummarizer.Params defaultParams = new MultivariateSummarizer.Params(MultivariateSummarizer$Params$.MODULE$.apply$default$1());
        OptionParser<MultivariateSummarizer.Params> parser = new OptionParser<MultivariateSummarizer.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MultivariateSummarizer: an example app for MultivariateOnlineSummarizer"}));
                this.opt("input", Read$.MODULE$.stringRead()).text(new StringBuilder(58).append("Input path to labeled examples in LIBSVM format, default: ").append(defaultParams$1.input()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x));
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n        |For example, the following command runs this app on a synthetic dataset:\n        |\n        | bin/spark-submit --class org.apache.spark.examples.mllib.MultivariateSummarizer \\\n        |  examples/target/scala-*/spark-examples-*.jar \\\n        |  --input data/mllib/sample_linear_regression_data.txt\n        ")).stripMargin());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.mllib.MultivariateSummarizer$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            MultivariateSummarizer.Params params = (MultivariateSummarizer.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(MultivariateSummarizer.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(28).append("MultivariateSummarizer with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
        Predef$.MODULE$.println((Object)new StringBuilder(22).append("Summary of data file: ").append(params.input()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(12).append(examples.count()).append(" data points").toString());
        MultivariateOnlineSummarizer labelSummary = (MultivariateOnlineSummarizer)examples.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2 & Serializable & scala.Serializable)(summary, lp) -> summary.add(Vectors$.MODULE$.dense(lp.label(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (Function2 & Serializable & scala.Serializable)(sum1, sum2) -> sum1.merge(sum2), ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        MultivariateOnlineSummarizer featureSummary = (MultivariateOnlineSummarizer)examples.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2 & Serializable & scala.Serializable)(summary, lp) -> summary.add(lp.features()), (Function2 & Serializable & scala.Serializable)(sum1, sum2) -> sum1.merge(sum2), ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Summary statistics");
        Predef$.MODULE$.println((Object)"\tLabel\tFeatures");
        Predef$.MODULE$.println((Object)new StringBuilder(6).append("mean\t").append(labelSummary.mean().apply(0)).append("\t").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featureSummary.mean().toArray())).mkString("\t")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(5).append("var\t").append(labelSummary.variance().apply(0)).append("\t").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featureSummary.variance().toArray())).mkString("\t")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(5).append("nnz\t").append(labelSummary.numNonzeros().apply(0)).append("\t").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featureSummary.numNonzeros().toArray())).mkString("\t")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(5).append("max\t").append(labelSummary.max().apply(0)).append("\t").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featureSummary.max().toArray())).mkString("\t")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(5).append("min\t").append(labelSummary.min().apply(0)).append("\t").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featureSummary.min().toArray())).mkString("\t")).toString());
        Predef$.MODULE$.println();
        sc.stop();
    }

    private MultivariateSummarizer$() {
        MODULE$ = this;
    }
}

