/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.io.Serializable;
import org.apache.spark.examples.sql.streaming.StructuredNetworkWordCountWindowed$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;

public final class StructuredNetworkWordCountWindowed$ {
    public static StructuredNetworkWordCountWindowed$ MODULE$;

    static {
        new StructuredNetworkWordCountWindowed$();
    }

    public void main(String[] args) {
        int slideSize;
        if (args.length < 3) {
            System.err.println("Usage: StructuredNetworkWordCountWindowed <hostname> <port> <window duration in seconds> [<slide duration in seconds>]");
            System.exit(1);
        }
        String host = args[0];
        int port = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        int windowSize = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        int n = slideSize = args.length == 3 ? windowSize : new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt();
        if (slideSize > windowSize) {
            System.err.println("<slide duration> must be less than or equal to <window duration>");
        }
        String windowDuration = new StringBuilder(8).append(windowSize).append(" seconds").toString();
        String slideDuration = new StringBuilder(8).append(slideSize).append(" seconds").toString();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("StructuredNetworkWordCountWindowed").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).option("includeTimestamp", true).load();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_streaming_StructuredNetworkWordCountWindowed$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_examples_sql_streaming_StructuredNetworkWordCountWindowed$$typecreator5$1() {
            }
        }
        public final class Org_apache_spark_examples_sql_streaming_StructuredNetworkWordCountWindowed$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_examples_sql_streaming_StructuredNetworkWordCountWindowed$$typecreator6$1() {
            }
        }
        Dataset words = lines.as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_streaming_StructuredNetworkWordCountWindowed$$typecreator5$1()))).flatMap((Function1 & Serializable & scala.Serializable)line -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)line._1()).split(" "))).map((Function1 & Serializable & scala.Serializable)word -> new Tuple2(word, line._2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))), spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_sql_streaming_StructuredNetworkWordCountWindowed$$typecreator6$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "timestamp"}));
        Dataset windowedCounts = words.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.window((Column)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp"}))).$((Seq)Nil$.MODULE$), windowDuration, slideDuration), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word"}))).$((Seq)Nil$.MODULE$)})).count().orderBy("window", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        StreamingQuery query = windowedCounts.writeStream().outputMode("complete").format("console").option("truncate", "false").start();
        query.awaitTermination();
    }

    private StructuredNetworkWordCountWindowed$() {
        MODULE$ = this;
    }
}

