/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.List;
import java.util.Locale;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeScope;

@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
@InterfaceStability.Evolving
public class HivePrivilege
implements Comparable<HivePrivilege> {
    private final String name;
    private final List<String> columns;
    private final List<String> supportedScope;

    public String toString() {
        return "Privilege [name=" + this.name + ", columns=" + this.columns + "]";
    }

    public HivePrivilege(String name, List<String> columns) {
        this(name, columns, null);
    }

    public HivePrivilege(String name, List<String> columns, List<String> supportedScope) {
        this.name = name.toUpperCase(Locale.US);
        this.columns = columns;
        this.supportedScope = supportedScope;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getSupportedScope() {
        return this.supportedScope;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HivePrivilege other = (HivePrivilege)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean supportsScope(PrivilegeScope scope) {
        return this.supportedScope != null && this.supportedScope.contains(scope.name());
    }

    @Override
    public int compareTo(HivePrivilege privilege) {
        int compare;
        int n = this.columns != null ? (privilege.columns != null ? this.compare(this.columns, privilege.columns) : 1) : (compare = privilege.columns != null ? -1 : 0);
        if (compare == 0) {
            compare = this.name.compareTo(privilege.name);
        }
        return compare;
    }

    private int compare(List<String> o1, List<String> o2) {
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int compare = o1.get(i).compareTo(o2.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return o1.size() > o2.size() ? 1 : (o1.size() < o2.size() ? -1 : 0);
    }
}

