/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncASinDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncASinLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="asin", value="_FUNC_(x) - returns the arc sine of x if -1<=x<=1 or NULL otherwise", extended="Example:\n  > SELECT _FUNC_(0) FROM src LIMIT 1;\n  0\n  > SELECT _FUNC_(2) FROM src LIMIT 1;\n  NULL")
@VectorizedExpressions(value={FuncASinLongToDouble.class, FuncASinDoubleToDouble.class})
public class UDFAsin
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        this.result.set(Math.asin(a.get()));
        return this.result;
    }
}

