/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.CsvToStructs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.csv.CsvToStructsEvaluator;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(csvStr, schema[, options]) - Returns a struct value with the given `csvStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('1, 0.8', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('26/08/2015', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0005\tEf\u0001B\u001b7\u0001\u000eC\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tQ\u0002\u0011\t\u0012)A\u0005E\"A\u0011\u000e\u0001BK\u0002\u0013\u0005!\u000e\u0003\u0005w\u0001\tE\t\u0015!\u0003l\u0011!9\bA!f\u0001\n\u0003A\b\u0002\u0003?\u0001\u0005#\u0005\u000b\u0011B=\t\u0011u\u0004!Q3A\u0005\u0002yD\u0011\"!\u0002\u0001\u0005#\u0005\u000b\u0011B@\t\u0015\u0005\u001d\u0001A!f\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u000e\u0001\u0011\t\u0012)A\u0005\u0003\u0017Aq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005%\u0002\u0001\"\u0011\u0002\"!9\u0011q\u0002\u0001\u0005\u0002\u0005-\u0002bBA\b\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u001f\u0001A\u0011AA\u001d\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!a\u0013\u0001\t\u0003\ni\u0005C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d!A\u0011Q\r\u0001C\u0002\u0013%\u0011\rC\u0004\u0002h\u0001\u0001\u000b\u0011\u00022\t\u0013\u0005%\u0004A1A\u0005\n\u0005\r\u0004bBA6\u0001\u0001\u0006Ia\u001d\u0005\u000b\u0003k\u0002\u0001R1A\u0005\n\u0005]\u0004bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\t\u0019\f\u0001C)\u0003kC\u0011\"a/\u0001\u0003\u0003%\t!!0\t\u0013\u0005%\u0007!%A\u0005\u0002\u0005-\u0007\"CAq\u0001E\u0005I\u0011AAr\u0011%\t9\u000fAI\u0001\n\u0003\tI\u000fC\u0005\u0002n\u0002\t\n\u0011\"\u0001\u0002p\"I\u00111\u001f\u0001\u0012\u0002\u0013\u0005\u0011Q\u001f\u0005\n\u0003s\u0004\u0011\u0011!C!\u0003wD\u0011Ba\u0003\u0001\u0003\u0003%\tA!\u0004\t\u0013\tU\u0001!!A\u0005\u0002\t]\u0001\"\u0003B\u000f\u0001\u0005\u0005I\u0011\tB\u0010\u0011%\u0011i\u0003AA\u0001\n\u0003\u0011y\u0003C\u0005\u00034\u0001\t\t\u0011\"\u0011\u00036!I!\u0011\b\u0001\u0002\u0002\u0013\u0005#1H\u0004\n\u0005?2\u0014\u0011!E\u0001\u0005C2\u0001\"\u000e\u001c\u0002\u0002#\u0005!1\r\u0005\b\u0003\u001fYC\u0011\u0001B>\u0011%\u0011ihKA\u0001\n\u000b\u0012y\bC\u0005\u0003\u0002.\n\t\u0011\"!\u0003\u0004\"I!qR\u0016\u0012\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0005#[\u0013\u0013!C\u0001\u0003kD\u0011Ba%,\u0003\u0003%\tI!&\t\u0013\t\r6&%A\u0005\u0002\u0005=\b\"\u0003BSWE\u0005I\u0011AA{\u0011%\u00119kKA\u0001\n\u0013\u0011IK\u0001\u0007DgZ$vn\u0015;sk\u000e$8O\u0003\u00028q\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tI$(\u0001\u0005dCR\fG._:u\u0015\tYD(A\u0002tc2T!!\u0010 \u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\u0002\u0001'\u0019\u0001A\tS&O)B\u0011QIR\u0007\u0002m%\u0011qI\u000e\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011Q)S\u0005\u0003\u0015Z\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u0015c\u0015BA'7\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\b!J|G-^2u!\t)VL\u0004\u0002W7:\u0011qKW\u0007\u00021*\u0011\u0011LQ\u0001\u0007yI|w\u000e\u001e \n\u0003EK!\u0001\u0018)\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u00039B\u000baa]2iK6\fW#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015T\u0014!\u0002;za\u0016\u001c\u0018BA4e\u0005)\u0019FO];diRK\b/Z\u0001\bg\u000eDW-\\1!\u0003\u001dy\u0007\u000f^5p]N,\u0012a\u001b\t\u0005YB\u001c8O\u0004\u0002n]B\u0011q\u000bU\u0005\u0003_B\u000ba\u0001\u0015:fI\u00164\u0017BA9s\u0005\ri\u0015\r\u001d\u0006\u0003_B\u0003\"\u0001\u001c;\n\u0005U\u0014(AB*ue&tw-\u0001\u0005paRLwN\\:!\u0003\u0015\u0019\u0007.\u001b7e+\u0005I\bCA#{\u0013\tYhG\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\tq\u0010\u0005\u0003P\u0003\u0003\u0019\u0018bAA\u0002!\n1q\n\u001d;j_:\f1\u0002^5nKj{g.Z%eA\u0005q!/Z9vSJ,GmU2iK6\fWCAA\u0006!\u0011y\u0015\u0011\u00012\u0002\u001fI,\u0017/^5sK\u0012\u001c6\r[3nC\u0002\na\u0001P5oSRtD\u0003DA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0001CA#\u0001\u0011\u0015\u00017\u00021\u0001c\u0011\u0015I7\u00021\u0001l\u0011\u001598\u00021\u0001z\u0011\u001di8\u0002%AA\u0002}D\u0011\"a\u0002\f!\u0003\u0005\r!a\u0003\u0002\u00119,H\u000e\\1cY\u0016,\"!a\t\u0011\u0007=\u000b)#C\u0002\u0002(A\u0013qAQ8pY\u0016\fg.\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0015\u0011\u0005M\u0011QFA\u0018\u0003cAQa\u001e\bA\u0002eDQ\u0001\u0019\bA\u0002eDQ!\u001b\bA\u0002-$b!a\u0005\u00026\u0005]\u0002\"B<\u0010\u0001\u0004I\b\"\u00021\u0010\u0001\u0004IH\u0003CA\n\u0003w\ti$a\u0010\t\u000b]\u0004\u0002\u0019A=\t\u000b\u0001\u0004\u0002\u0019A=\t\u000b%\u0004\u0002\u0019A=\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0012\u0011\u0007\r\f9%C\u0002\u0002J\u0011\u0014\u0001\u0002R1uCRK\b/Z\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004\u0011\u0006=\u0003\"B?\u0013\u0001\u0004\u0019\u0018AC5oaV$H+\u001f9fgV\u0011\u0011Q\u000b\t\u0006+\u0006]\u00131L\u0005\u0004\u00033z&aA*fcB\u00191-!\u0018\n\u0007\u0005}CM\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003M\faB\\;mY\u0006\u0014G.Z*dQ\u0016l\u0017-A\bok2d\u0017M\u00197f'\u000eDW-\\1!\u0003Mq\u0017-\\3PM\u000e{'O];qiJ+7m\u001c:e\u0003Qq\u0017-\\3PM\u000e{'O];qiJ+7m\u001c:eA!\u001a\u0001$a\u001c\u0011\u0007=\u000b\t(C\u0002\u0002tA\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0013\u00154\u0018\r\\;bi>\u0014XCAA=!\u0011\tY(!!\u000e\u0005\u0005u$bAA@m\u0005\u00191m\u001d<\n\t\u0005\r\u0015Q\u0010\u0002\u0016\u0007N4Hk\\*ueV\u001cGo]#wC2,\u0018\r^8sQ\rI\u0012qN\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u0003\u0017\u000b\t\nE\u0002P\u0003\u001bK1!a$Q\u0005\r\te.\u001f\u0005\b\u0003'S\u0002\u0019AAF\u0003\u0015Ig\u000e];u\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u001a\u0006\u0015\u0016q\u0016\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014\u001c\u0002\u000f\r|G-Z4f]&!\u00111UAO\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBAT7\u0001\u0007\u0011\u0011V\u0001\u0004GRD\b\u0003BAN\u0003WKA!!,\u0002\u001e\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBAY7\u0001\u0007\u0011\u0011T\u0001\u0003KZ\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dG\u0003BA\n\u0003oCa!!/\u001d\u0001\u0004I\u0018\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\r\u0003'\ty,!1\u0002D\u0006\u0015\u0017q\u0019\u0005\bAv\u0001\n\u00111\u0001c\u0011\u001dIW\u0004%AA\u0002-Dqa^\u000f\u0011\u0002\u0003\u0007\u0011\u0010C\u0004~;A\u0005\t\u0019A@\t\u0013\u0005\u001dQ\u0004%AA\u0002\u0005-\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001bT3AYAhW\t\t\t\u000e\u0005\u0003\u0002T\u0006uWBAAk\u0015\u0011\t9.!7\u0002\u0013Ut7\r[3dW\u0016$'bAAn!\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0017Q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003KT3a[Ah\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a;+\u0007e\fy-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005E(fA@\u0002P\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA|U\u0011\tY!a4\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0010\u0005\u0003\u0002\u0000\n%QB\u0001B\u0001\u0015\u0011\u0011\u0019A!\u0002\u0002\t1\fgn\u001a\u0006\u0003\u0005\u000f\tAA[1wC&\u0019QO!\u0001\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t=\u0001cA(\u0003\u0012%\u0019!1\u0003)\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-%\u0011\u0004\u0005\n\u00057)\u0013\u0011!a\u0001\u0005\u001f\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0011!\u0019\u0011\u0019C!\u000b\u0002\f6\u0011!Q\u0005\u0006\u0004\u0005O\u0001\u0016AC2pY2,7\r^5p]&!!1\u0006B\u0013\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r\"\u0011\u0007\u0005\n\u000579\u0013\u0011!a\u0001\u0003\u0017\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011Q B\u001c\u0011%\u0011Y\u0002KA\u0001\u0002\u0004\u0011y!\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003G\u0011i\u0004C\u0005\u0003\u001c%\n\t\u00111\u0001\u0002\f\"\u001a\u0002A!\u0011\u0003H\t%#Q\nB(\u0005'\u0012)F!\u0017\u0003\\A\u0019QIa\u0011\n\u0007\t\u0015cGA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t-\u0013\u0001Y0G+:\u001bu\fK2tmN#(\u000f\f\u0011tG\",W.Y.-A=\u0004H/[8ogvK\u0003%\f\u0011SKR,(O\\:!C\u0002\u001aHO];di\u00022\u0018\r\\;fA]LG\u000f\u001b\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u00027m\u001d<TiJ\u0004\u0007%\u00198eA\u0001\u001c8\r[3nC\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tE\u0013!a/\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\nD\u0006\t\u0019/q\u001db\u0003eJ1!\u0013:#F\u0006\t2!\t>+&\tT#(SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#uEb#E\u0019\u0012;a9BTP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eYz\u0003\u0007O\u00183aE*t\u0005\f\u0011(i&lW\r\t+j[\u0016\u001cH/Y7qO1\u0002S.\u00199)OQLW.Z:uC6\u0004hi\u001c:nCR<C\u0006I\u0014eI>jUjL=zsf<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\"\u0018.\\3#uI\u0002\u0014'N\u00171q5\u0012d\u0007\t\u00191uA\u0002$\b\r\u0019~\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B,\u0003\u0015\u0019d\u0006\r\u00181\u0003\u00159'o\\;qC\t\u0011i&A\u0005dgZ|f-\u001e8dg\u0006a1i\u001d<U_N#(/^2ugB\u0011QiK\n\u0006W\t\u0015$\u0011\u000f\t\r\u0005O\u0012iGY6z\u007f\u0006-\u00111C\u0007\u0003\u0005SR1Aa\u001bQ\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u001c\u0003j\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\u0011\t\tM$\u0011P\u0007\u0003\u0005kRAAa\u001e\u0003\u0006\u0005\u0011\u0011n\\\u0005\u0004=\nUDC\u0001B1\u0003!!xn\u0015;sS:<GCAA\u007f\u0003\u0015\t\u0007\u000f\u001d7z)1\t\u0019B!\"\u0003\b\n%%1\u0012BG\u0011\u0015\u0001g\u00061\u0001c\u0011\u0015Ig\u00061\u0001l\u0011\u00159h\u00061\u0001z\u0011\u001dih\u0006%AA\u0002}D\u0011\"a\u0002/!\u0003\u0005\r!a\u0003\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Ja(\u0011\u000b=\u000b\tA!'\u0011\u0013=\u0013YJY6z\u007f\u0006-\u0011b\u0001BO!\n1A+\u001e9mKVB\u0011B!)2\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t-\u0006\u0003BA\u0000\u0005[KAAa,\u0003\u0002\t1qJ\u00196fGR\u0004")
public class CsvToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
ExpectsInputTypes,
Serializable {
    private transient CsvToStructsEvaluator evaluator;
    private final StructType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final Option<StructType> requiredSchema;
    private final StructType nullableSchema;
    private final transient String nameOfCorruptRecord;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<StructType> $lessinit$greater$default$5() {
        return CsvToStructs$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return CsvToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<StructType, Map<String, String>, Expression, Option<String>, Option<StructType>>> unapply(CsvToStructs x$0) {
        return CsvToStructs$.MODULE$.unapply(x$0);
    }

    public static Option<StructType> apply$default$5() {
        return CsvToStructs$.MODULE$.apply$default$5();
    }

    public static Option<String> apply$default$4() {
        return CsvToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<StructType, Map<String, String>, Expression, Option<String>, Option<StructType>>, CsvToStructs> tupled() {
        return CsvToStructs$.MODULE$.tupled();
    }

    public static Function1<StructType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, Function1<Option<StructType>, CsvToStructs>>>>> curried() {
        return CsvToStructs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public Option<StructType> requiredSchema() {
        return this.requiredSchema;
    }

    @Override
    public boolean nullable() {
        return this.child().nullable();
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return ((StructType)this.requiredSchema().getOrElse((Function0 & Serializable)() -> this.schema())).asNullable();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Option<StructType> x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1, x$5);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringTypeWithCollation stringTypeWithCollation = StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)stringTypeWithCollation);
    }

    @Override
    public String prettyName() {
        return "from_csv";
    }

    private StructType nullableSchema() {
        return this.nullableSchema;
    }

    private String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private CsvToStructsEvaluator evaluator$lzycompute() {
        CsvToStructs csvToStructs = this;
        synchronized (csvToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.evaluator = new CsvToStructsEvaluator(this.options(), this.nullableSchema(), this.nameOfCorruptRecord(), this.timeZoneId(), this.requiredSchema());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.evaluator;
    }

    private CsvToStructsEvaluator evaluator() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.evaluator$lzycompute();
        }
        return this.evaluator;
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.evaluator().evaluate((UTF8String)input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String refEvaluator = ctx.addReferenceObj("evaluator", this.evaluator(), ctx.addReferenceObj$default$3());
        ExprCode eval = this.child().genCode(ctx);
        String resultType = CodeGenerator$.MODULE$.boxedType(this.dataType());
        String resultTerm = ctx.freshName("result");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", " ", " = (", ") ", ".evaluate(", ");\n         |boolean ", " = ", " == null;\n         |", " ", " = ", ";\n         |if (!", ") {\n         |  ", " = ", ";\n         |}\n         |"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), resultType, resultTerm, resultType, refEvaluator, eval.value(), ev.isNull(), resultTerm, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), resultTerm})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public CsvToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        Option<StructType> x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$1, x$4, x$5);
    }

    public CsvToStructs copy(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, Option<StructType> requiredSchema) {
        return new CsvToStructs(schema, options, child, timeZoneId, requiredSchema);
    }

    public StructType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    public Option<StructType> copy$default$5() {
        return this.requiredSchema();
    }

    @Override
    public String productPrefix() {
        return "CsvToStructs";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.schema();
            }
            case 1: {
                return this.options();
            }
            case 2: {
                return this.child();
            }
            case 3: {
                return this.timeZoneId();
            }
            case 4: {
                return this.requiredSchema();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CsvToStructs;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "schema";
            }
            case 1: {
                return "options";
            }
            case 2: {
                return "child";
            }
            case 3: {
                return "timeZoneId";
            }
            case 4: {
                return "requiredSchema";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CsvToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        CsvToStructs csvToStructs = (CsvToStructs)x$1;
        StructType structType = this.schema();
        StructType structType2 = csvToStructs.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = csvToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = csvToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = csvToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<StructType> option3 = this.requiredSchema();
        Option<StructType> option4 = csvToStructs.requiredSchema();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!csvToStructs.canEqual(this)) return false;
        return true;
    }

    public CsvToStructs(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, Option<StructType> requiredSchema) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        this.requiredSchema = requiredSchema;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
        Statics.releaseFence();
    }

    public CsvToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$, CsvToStructs$.MODULE$.$lessinit$greater$default$5());
    }

    public CsvToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public CsvToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$, CsvToStructs$.MODULE$.$lessinit$greater$default$5());
    }
}

