/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateDiff$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(endDate, startDate) - Returns the number of days from `startDate` to `endDate`.", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-31', '2009-07-30');\n       1\n\n      > SELECT _FUNC_('2009-07-30', '2009-07-31');\n       -1\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\u0010!\u00016B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005O\u0001\tE\t\u0015!\u0003J\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015I\u0006\u0001\"\u0011I\u0011\u0015Q\u0006\u0001\"\u0011I\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015!\b\u0001\"\u0011v\u0011\u001d\t9\u0001\u0001C)\u0003\u0013A\u0011\"a\u0005\u0001\u0003\u0003%\t!!\u0006\t\u0013\u0005m\u0001!%A\u0005\u0002\u0005u\u0001\"CA\u001a\u0001E\u0005I\u0011AA\u000f\u0011%\t)\u0004AA\u0001\n\u0003\n9\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;B\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u000f%\ti\nIA\u0001\u0012\u0003\tyJ\u0002\u0005 A\u0005\u0005\t\u0012AAQ\u0011\u0019y\u0015\u0004\"\u0001\u0002:\"I\u00111X\r\u0002\u0002\u0013\u0015\u0013Q\u0018\u0005\n\u0003\u007fK\u0012\u0011!CA\u0003\u0003D\u0011\"a2\u001a\u0003\u0003%\t)!3\t\u0013\u0005m\u0017$!A\u0005\n\u0005u'\u0001\u0003#bi\u0016$\u0015N\u001a4\u000b\u0005\u0005\u0012\u0013aC3yaJ,7o]5p]NT!a\t\u0013\u0002\u0011\r\fG/\u00197zgRT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00183km\u0002\"a\f\u0019\u000e\u0003\u0001J!!\r\u0011\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00184\u0013\t!\u0004E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0010#\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!-\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002Do\u00059\u0001/Y2lC\u001e,\u0017BA#G\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0019u'A\u0004f]\u0012$\u0015\r^3\u0016\u0003%\u0003\"a\f&\n\u0005-\u0003#AC#yaJ,7o]5p]\u0006AQM\u001c3ECR,\u0007%A\u0005ti\u0006\u0014H\u000fR1uK\u0006Q1\u000f^1si\u0012\u000bG/\u001a\u0011\u0002\rqJg.\u001b;?)\r\t&k\u0015\t\u0003_\u0001AQaR\u0003A\u0002%CQ!T\u0003A\u0002%\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001W!\t1t+\u0003\u0002Yo\t9!i\\8mK\u0006t\u0017\u0001\u00027fMR\fQA]5hQR\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005i\u0006c\u0001\u001f_A&\u0011qL\u0012\u0002\u0004'\u0016\f\bCA1e\u001b\u0005\u0011'BA2%\u0003\u0015!\u0018\u0010]3t\u0013\t)'M\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001i!\t\t\u0017.\u0003\u0002kE\nAA)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002naJ\u0004\"A\u000e8\n\u0005=<$aA!os\")\u0011o\u0003a\u0001[\u0006\u0019QM\u001c3\t\u000bM\\\u0001\u0019A7\u0002\u000bM$\u0018M\u001d;\u0002\u0013\u0011|w)\u001a8D_\u0012,G\u0003\u0002<}\u0003\u0007\u0001\"a\u001e>\u000e\u0003aT!!\u001f\u0011\u0002\u000f\r|G-Z4f]&\u00111\u0010\u001f\u0002\t\u000bb\u0004(oQ8eK\")Q\u0010\u0004a\u0001}\u0006\u00191\r\u001e=\u0011\u0005]|\u0018bAA\u0001q\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bBBA\u0003\u0019\u0001\u0007a/\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006#\u0006-\u0011q\u0002\u0005\u0007\u0003\u001bi\u0001\u0019A%\u0002\u000f9,w\u000fT3gi\"1\u0011\u0011C\u0007A\u0002%\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003R\u0003/\tI\u0002C\u0004H\u001dA\u0005\t\u0019A%\t\u000f5s\u0001\u0013!a\u0001\u0013\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0010U\rI\u0015\u0011E\u0016\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#A\u0005v]\u000eDWmY6fI*\u0019\u0011QF\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0005\u001d\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002:A!\u00111HA#\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013\u0001\u00027b]\u001eT!!a\u0011\u0002\t)\fg/Y\u0005\u0005\u0003\u000f\niD\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u001b\u00022ANA(\u0013\r\t\tf\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004[\u0006]\u0003\"CA-'\u0005\u0005\t\u0019AA'\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\f\t\u0006\u0003C\n9'\\\u0007\u0003\u0003GR1!!\u001a8\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\n\u0019G\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001,\u0002p!A\u0011\u0011L\u000b\u0002\u0002\u0003\u0007Q.\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u001d\u0003kB\u0011\"!\u0017\u0017\u0003\u0003\u0005\r!!\u0014\u0002\r\u0015\fX/\u00197t)\r1\u00161\u0010\u0005\t\u00033:\u0012\u0011!a\u0001[\"\u001a\u0002!a \u0002\u0006\u0006\u001d\u00151RAG\u0003#\u000b\u0019*a&\u0002\u001aB\u0019q&!!\n\u0007\u0005\r\u0005EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005%\u0015AV0G+:\u001bu\fK3oI\u0012\u000bG/\u001a\u0017!gR\f'\u000f\u001e#bi\u0016L\u0003%\f\u0011SKR,(O\\:!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!I\u0006L8\u000f\t4s_6\u0004\u0003m\u001d;beR$\u0015\r^3aAQ|\u0007\u0005Y3oI\u0012\u000bG/\u001a1/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAH\u0003\u0005]!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aAJT\u0006M\u001c.gE:C\u0006I\u00143aAJT\u0006M\u001c.gA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112\u0015)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00191s5\u0002t'L\u001a1O1\u0002sE\r\u00191s5\u0002t'L\u001a2O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%L\u0019\u000bA\u0001\nQa\u001a:pkB\f#!!&\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u00111T\u0001\u0006c9*d\u0006M\u0001\t\t\u0006$X\rR5gMB\u0011q&G\n\u00063\u0005\r\u0016q\u0016\t\b\u0003K\u000bY+S%R\u001b\t\t9KC\u0002\u0002*^\nqA];oi&lW-\u0003\u0003\u0002.\u0006\u001d&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011\u0011WA\\\u001b\t\t\u0019L\u0003\u0003\u00026\u0006\u0005\u0013AA5p\u0013\r)\u00151\u0017\u000b\u0003\u0003?\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003s\tQ!\u00199qYf$R!UAb\u0003\u000bDQa\u0012\u000fA\u0002%CQ!\u0014\u000fA\u0002%\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002L\u0006]\u0007#\u0002\u001c\u0002N\u0006E\u0017bAAho\t1q\n\u001d;j_:\u0004RANAj\u0013&K1!!68\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\\\u000f\u0002\u0002\u0003\u0007\u0011+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a8\u0011\t\u0005m\u0012\u0011]\u0005\u0005\u0003G\fiD\u0001\u0004PE*,7\r\u001e")
public class DateDiff
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression endDate;
    private final Expression startDate;

    public static Option<Tuple2<Expression, Expression>> unapply(DateDiff x$0) {
        return DateDiff$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, DateDiff> tupled() {
        return DateDiff$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, DateDiff>> curried() {
        return DateDiff$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression endDate() {
        return this.endDate;
    }

    public Expression startDate() {
        return this.startDate;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.endDate();
    }

    @Override
    public Expression right() {
        return this.startDate();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)DateType$.MODULE$, (List)new .colon.colon((Object)DateType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object end, Object start) {
        return BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)end) - BoxesRunTime.unboxToInt((Object)start)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(end, start) -> end + " - " + start);
    }

    @Override
    public DateDiff withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public DateDiff copy(Expression endDate, Expression startDate) {
        return new DateDiff(endDate, startDate);
    }

    public Expression copy$default$1() {
        return this.endDate();
    }

    public Expression copy$default$2() {
        return this.startDate();
    }

    @Override
    public String productPrefix() {
        return "DateDiff";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.endDate();
            }
            case 1: {
                return this.startDate();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateDiff;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "endDate";
            }
            case 1: {
                return "startDate";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateDiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateDiff dateDiff = (DateDiff)x$1;
        Expression expression = this.endDate();
        Expression expression2 = dateDiff.endDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.startDate();
        Expression expression4 = dateDiff.startDate();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!dateDiff.canEqual(this)) return false;
        return true;
    }

    public DateDiff(Expression endDate, Expression startDate) {
        this.endDate = endDate;
        this.startDate = startDate;
        ExpectsInputTypes.$init$(this);
    }
}

