/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.evaluation.MultilabelMetrics;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction1;

public final class MultiLabelMetricsExample$ {
    public static final MultiLabelMetricsExample$ MODULE$ = new MultiLabelMetricsExample$();

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("MultiLabelMetricsExample");
        SparkContext sc = new SparkContext(conf);
        RDD scoreAndLabels = sc.parallelize((Seq)new .colon.colon((Object)new Tuple2((Object)new double[]{0.0, 1.0}, (Object)new double[]{0.0, 2.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{0.0, 2.0}, (Object)new double[]{0.0, 1.0}), (List)new .colon.colon((Object)new Tuple2(Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()), (Object)new double[]{0.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{2.0}, (Object)new double[]{2.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{2.0, 0.0}, (Object)new double[]{2.0, 0.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{0.0, 1.0, 2.0}, (Object)new double[]{0.0, 1.0}), (List)new .colon.colon((Object)new Tuple2((Object)new double[]{1.0}, (Object)new double[]{1.0, 2.0}), (List)Nil$.MODULE$))))))), 2, ClassTag$.MODULE$.apply(Tuple2.class));
        MultilabelMetrics metrics = new MultilabelMetrics(scoreAndLabels);
        Predef$.MODULE$.println((Object)("Recall = " + metrics.recall()));
        Predef$.MODULE$.println((Object)("Precision = " + metrics.precision()));
        Predef$.MODULE$.println((Object)("F1 measure = " + metrics.f1Measure()));
        Predef$.MODULE$.println((Object)("Accuracy = " + metrics.accuracy()));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(metrics.labels()), (Function1)(JFunction1.mcVD.sp & Serializable)label -> Predef$.MODULE$.println((Object)("Class " + label + " precision = " + metrics.precision(label))));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(metrics.labels()), (Function1)(JFunction1.mcVD.sp & Serializable)label -> Predef$.MODULE$.println((Object)("Class " + label + " recall = " + metrics.recall(label))));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(metrics.labels()), (Function1)(JFunction1.mcVD.sp & Serializable)label -> Predef$.MODULE$.println((Object)("Class " + label + " F1-score = " + metrics.f1Measure(label))));
        Predef$.MODULE$.println((Object)("Micro recall = " + metrics.microRecall()));
        Predef$.MODULE$.println((Object)("Micro precision = " + metrics.microPrecision()));
        Predef$.MODULE$.println((Object)("Micro F1 measure = " + metrics.microF1Measure()));
        Predef$.MODULE$.println((Object)("Hamming loss = " + metrics.hammingLoss()));
        Predef$.MODULE$.println((Object)("Subset accuracy = " + metrics.subsetAccuracy()));
        sc.stop();
    }

    private MultiLabelMetricsExample$() {
    }
}

