/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg.operators;

public final class DenseVectorSupportMethods {
    public static final int MAX_SMALL_DOT_PRODUCT_LENGTH = 8;
    public static final int UNROLL_LENGTH = 8;

    public static double smallDotProduct_Double(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        double d2 = 0.0;
        switch (n) {
            case 7: {
                d = dArray[6] * dArray2[6];
            }
            case 6: {
                d2 = dArray[5] * dArray2[5];
            }
            case 5: {
                d += dArray[4] * dArray2[4];
            }
            case 4: {
                d2 += dArray[3] * dArray2[3];
            }
            case 3: {
                d += dArray[2] * dArray2[2];
            }
            case 2: {
                d2 += dArray[1] * dArray2[1];
            }
            case 1: {
                d += dArray[0] * dArray2[0];
            }
        }
        return d + d2;
    }

    public static double dotProduct_Double(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4;
        int n5 = n3 % 8;
        int n6 = n3 / 8;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (n4 = 0; n4 < n5; ++n4) {
            d += dArray[n + n4] * dArray2[n2 + n4];
        }
        n += n5;
        n2 += n5;
        n4 = 0;
        while (n4 < n6) {
            d += dArray[n + 0] * dArray2[n2 + 0];
            d2 += dArray[n + 1] * dArray2[n2 + 1];
            d3 += dArray[n + 2] * dArray2[n2 + 2];
            d4 += dArray[n + 3] * dArray2[n2 + 3];
            d5 += dArray[n + 4] * dArray2[n2 + 4];
            d6 += dArray[n + 5] * dArray2[n2 + 5];
            d7 += dArray[n + 6] * dArray2[n2 + 6];
            d8 += dArray[n + 7] * dArray2[n2 + 7];
            ++n4;
            n += 8;
            n2 += 8;
        }
        return d + d2 + d3 + d4 + d5 + d6 + d7 + d8;
    }

    public static float smallDotProduct_Float(float[] fArray, float[] fArray2, int n) {
        float f = 0.0f;
        float f2 = 0.0f;
        switch (n) {
            case 7: {
                f = fArray[6] * fArray2[6];
            }
            case 6: {
                f2 = fArray[5] * fArray2[5];
            }
            case 5: {
                f += fArray[4] * fArray2[4];
            }
            case 4: {
                f2 += fArray[3] * fArray2[3];
            }
            case 3: {
                f += fArray[2] * fArray2[2];
            }
            case 2: {
                f2 += fArray[1] * fArray2[1];
            }
            case 1: {
                f += fArray[0] * fArray2[0];
            }
        }
        return f + f2;
    }

    public static float dotProduct_Float(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4;
        int n5 = n3 % 8;
        int n6 = n3 / 8;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        for (n4 = 0; n4 < n5; ++n4) {
            f += fArray[n + n4] * fArray2[n2 + n4];
        }
        n += n5;
        n2 += n5;
        n4 = 0;
        while (n4 < n6) {
            f += fArray[n + 0] * fArray2[n2 + 0];
            f2 += fArray[n + 1] * fArray2[n2 + 1];
            f3 += fArray[n + 2] * fArray2[n2 + 2];
            f4 += fArray[n + 3] * fArray2[n2 + 3];
            f5 += fArray[n + 4] * fArray2[n2 + 4];
            f6 += fArray[n + 5] * fArray2[n2 + 5];
            f7 += fArray[n + 6] * fArray2[n2 + 6];
            f8 += fArray[n + 7] * fArray2[n2 + 7];
            ++n4;
            n += 8;
            n2 += 8;
        }
        return f + f2 + f3 + f4 + f5 + f6 + f7 + f8;
    }
}

