/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.parquet.OpenedParquetFooter;

public class ParquetFooterReader {
    public static ParquetMetadataConverter.MetadataFilter buildFilter(Configuration hadoopConf, PartitionedFile file, boolean skipRowGroup) {
        if (skipRowGroup) {
            return ParquetMetadataConverter.SKIP_ROW_GROUPS;
        }
        long fileStart = file.start();
        return HadoopReadOptions.builder((Configuration)hadoopConf, (Path)file.toPath()).withRange(fileStart, fileStart + file.length()).build().getMetadataFilter();
    }

    public static ParquetMetadata readFooter(HadoopInputFile inputFile, ParquetMetadataConverter.MetadataFilter filter) throws IOException {
        ParquetReadOptions readOptions = HadoopReadOptions.builder((Configuration)inputFile.getConfiguration(), (Path)inputFile.getPath()).withMetadataFilter(filter).build();
        try (ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile, (ParquetReadOptions)readOptions);){
            ParquetMetadata parquetMetadata = fileReader.getFooter();
            return parquetMetadata;
        }
    }

    public static OpenedParquetFooter openFileAndReadFooter(Configuration hadoopConf, PartitionedFile file, boolean keepInputStreamOpen) throws IOException {
        ParquetReadOptions readOptions = HadoopReadOptions.builder((Configuration)hadoopConf, (Path)file.toPath()).withMetadataFilter(ParquetFooterReader.buildFilter(hadoopConf, file, !keepInputStreamOpen)).build();
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)file.toPath(), (Configuration)hadoopConf);
        SeekableInputStream inputStream = inputFile.newStream();
        try (ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile, (ParquetReadOptions)readOptions, (SeekableInputStream)inputStream);){
            ParquetMetadata footer = fileReader.getFooter();
            if (keepInputStreamOpen) {
                fileReader.detachFileInputStream();
                OpenedParquetFooter openedParquetFooter = new OpenedParquetFooter(footer, inputFile, Optional.of(inputStream));
                return openedParquetFooter;
            }
            OpenedParquetFooter openedParquetFooter = new OpenedParquetFooter(footer, inputFile, Optional.empty());
            return openedParquetFooter;
        }
    }
}

