/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.shade.com.google.common.collect.Multimap;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.state.KeyValueState;
import org.apache.storm.streams.Edge;
import org.apache.storm.streams.Node;
import org.apache.storm.streams.ProcessorBoltDelegate;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.StreamBolt;
import org.apache.storm.streams.processors.StatefulProcessor;
import org.apache.storm.streams.processors.UpdateStateByKeyProcessor;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseStatefulBolt;
import org.apache.storm.tuple.Tuple;

class StatefulProcessorBolt<K, V>
extends BaseStatefulBolt<KeyValueState<K, V>>
implements StreamBolt {
    private final ProcessorBoltDelegate delegate;
    private final Set<StatefulProcessor<K, V>> statefulProcessors;

    StatefulProcessorBolt(String boltId, DirectedGraph<Node, Edge> graph, List<ProcessorNode> nodes) {
        this.delegate = new ProcessorBoltDelegate(boltId, graph, nodes);
        this.statefulProcessors = this.getStatefulProcessors(nodes);
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this.delegate.prepare(topoConf, context, collector);
    }

    @Override
    public void execute(Tuple input) {
        this.delegate.processAndAck(input);
    }

    @Override
    public void initState(KeyValueState<K, V> state) {
        for (StatefulProcessor<K, V> statefulProcessor : this.statefulProcessors) {
            statefulProcessor.initState(state);
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.delegate.declareOutputFields(declarer);
    }

    @Override
    public void setTimestampField(String fieldName) {
        this.delegate.setTimestampField(fieldName);
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    void setStreamToInitialProcessors(Multimap<String, ProcessorNode> streamToInitialProcessors) {
        this.delegate.setStreamToInitialProcessors(streamToInitialProcessors);
    }

    public List<ProcessorNode> getNodes() {
        return this.delegate.getNodes();
    }

    void addStreamToInitialProcessors(Multimap<String, ProcessorNode> streamToInitialProcessors) {
        this.delegate.addStreamToInitialProcessors(streamToInitialProcessors);
    }

    void addNodes(List<ProcessorNode> nodes) {
        this.delegate.addNodes(nodes);
        this.statefulProcessors.addAll(this.getStatefulProcessors(nodes));
    }

    private Set<StatefulProcessor<K, V>> getStatefulProcessors(List<ProcessorNode> nodes) {
        HashSet<StatefulProcessor<K, V>> statefulProcessors = new HashSet<StatefulProcessor<K, V>>();
        int updateStateByKeyCount = 0;
        for (ProcessorNode node : nodes) {
            if (!(node.getProcessor() instanceof StatefulProcessor)) continue;
            statefulProcessors.add((StatefulProcessor)((Object)node.getProcessor()));
            if (!(node.getProcessor() instanceof UpdateStateByKeyProcessor) || ++updateStateByKeyCount <= 1) continue;
            throw new IllegalArgumentException("Cannot have more than one updateStateByKey processor in a StatefulProcessorBolt");
        }
        return statefulProcessors;
    }
}

