/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.coordination;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.coordination.BatchOutputCollectorImpl;
import org.apache.storm.coordination.CoordinatedBolt;
import org.apache.storm.coordination.IBatchBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.FailedException;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchBoltExecutor
implements IRichBolt,
CoordinatedBolt.FinishedCallback,
CoordinatedBolt.TimeoutCallback {
    public static final Logger LOG = LoggerFactory.getLogger(BatchBoltExecutor.class);
    private byte[] boltSer;
    private Map<Object, IBatchBolt> openTransactions;
    private Map conf;
    private TopologyContext context;
    private BatchOutputCollectorImpl collector;

    public BatchBoltExecutor(IBatchBolt bolt) {
        this.boltSer = Utils.javaSerialize(bolt);
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, OutputCollector collector) {
        this.conf = conf;
        this.context = context;
        this.collector = new BatchOutputCollectorImpl(collector);
        this.openTransactions = new HashMap<Object, IBatchBolt>();
    }

    @Override
    public void execute(Tuple input) {
        Object id = input.getValue(0);
        IBatchBolt bolt = this.getBatchBolt(id);
        try {
            bolt.execute(input);
            this.collector.ack(input);
        }
        catch (FailedException e) {
            LOG.error("Failed to process tuple in batch", (Throwable)e);
            this.collector.fail(input);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void finishedId(Object id) {
        IBatchBolt bolt = this.getBatchBolt(id);
        this.openTransactions.remove(id);
        bolt.finishBatch();
    }

    @Override
    public void timeoutId(Object attempt) {
        this.openTransactions.remove(attempt);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.newTransactionalBolt().declareOutputFields(declarer);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.newTransactionalBolt().getComponentConfiguration();
    }

    private IBatchBolt getBatchBolt(Object id) {
        IBatchBolt bolt = this.openTransactions.get(id);
        if (bolt == null) {
            bolt = this.newTransactionalBolt();
            bolt.prepare(this.conf, this.context, this.collector, id);
            this.openTransactions.put(id, bolt);
        }
        return bolt;
    }

    private IBatchBolt newTransactionalBolt() {
        return Utils.javaDeserialize(this.boltSer, IBatchBolt.class);
    }
}

