/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ImplementationTypesHolder;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.data.ImplementationDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ImplementationLogic
extends AbstractTransactionalLogic<ImplementationTO> {
    protected final ImplementationDataBinder binder;
    protected final ImplementationDAO implementationDAO;
    protected final ReportDAO reportDAO;
    protected final PolicyDAO policyDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final TaskDAO taskDAO;
    protected final RealmDAO realmDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final NotificationDAO notificationDAO;

    public ImplementationLogic(ImplementationDataBinder binder, ImplementationDAO implementationDAO, ReportDAO reportDAO, PolicyDAO policyDAO, ExternalResourceDAO resourceDAO, TaskDAO taskDAO, RealmDAO realmDAO, PlainSchemaDAO plainSchemaDAO, NotificationDAO notificationDAO) {
        this.binder = binder;
        this.implementationDAO = implementationDAO;
        this.reportDAO = reportDAO;
        this.policyDAO = policyDAO;
        this.resourceDAO = resourceDAO;
        this.taskDAO = taskDAO;
        this.realmDAO = realmDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.notificationDAO = notificationDAO;
    }

    protected void checkType(String type) {
        if (!ImplementationTypesHolder.getInstance().getValues().containsKey(type)) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidImplementationType);
            sce.getElements().add("Implementation type not found: ");
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_LIST')")
    @Transactional(readOnly=true)
    public List<ImplementationTO> list(String type) {
        this.checkType(type);
        return this.implementationDAO.findByType(type).stream().map(arg_0 -> ((ImplementationDataBinder)this.binder).getImplementationTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_READ')")
    @Transactional(readOnly=true)
    public ImplementationTO read(String type, String key) {
        this.checkType(type);
        Implementation implementation = this.implementationDAO.find(key);
        if (implementation == null) {
            LOG.error("Could not find implementation '" + key + "'");
            throw new NotFoundException(key);
        }
        if (!implementation.getType().equals(type)) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + implementation.getType());
            throw sce;
        }
        return this.binder.getImplementationTO(implementation);
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_CREATE')")
    public ImplementationTO create(ImplementationTO implementationTO) {
        if (StringUtils.isBlank((CharSequence)implementationTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("Implementation key");
            throw sce;
        }
        this.checkType(implementationTO.getType());
        Implementation implementation = this.implementationDAO.find(implementationTO.getKey());
        if (implementation != null) {
            throw new DuplicateException(implementationTO.getKey());
        }
        return this.binder.getImplementationTO(this.implementationDAO.save(this.binder.create(implementationTO)));
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_UPDATE')")
    public ImplementationTO update(ImplementationTO implementationTO) {
        Implementation implementation = this.implementationDAO.find(implementationTO.getKey());
        if (implementation == null) {
            LOG.error("Could not find implementation '" + implementationTO.getKey() + "'");
            throw new NotFoundException(implementationTO.getKey());
        }
        this.checkType(implementationTO.getType());
        this.binder.update(implementation, implementationTO);
        implementation = this.implementationDAO.save(implementation);
        return this.binder.getImplementationTO(implementation);
    }

    @PreAuthorize(value="hasRole('IMPLEMENTATION_DELETE')")
    public void delete(String type, String key) {
        Implementation implementation = this.implementationDAO.find(key);
        if (implementation == null) {
            LOG.error("Could not find implementation '" + key + "'");
            throw new NotFoundException(key);
        }
        if (!implementation.getType().equals(type)) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + implementation.getType());
            throw sce;
        }
        boolean inUse = false;
        switch (implementation.getType()) {
            case "ACCOUNT_RULE": {
                inUse = !this.policyDAO.findByAccountRule(implementation).isEmpty();
                break;
            }
            case "PASSWORD_RULE": {
                inUse = !this.policyDAO.findByPasswordRule(implementation).isEmpty();
                break;
            }
            case "ITEM_TRANSFORMER": {
                inUse = this.resourceDAO.anyItemHaving(implementation);
                break;
            }
            case "TASKJOB_DELEGATE": {
                inUse = !this.taskDAO.findByDelegate(implementation).isEmpty();
                break;
            }
            case "REPORT_DELEGATE": {
                inUse = !this.reportDAO.findByDelegate(implementation).isEmpty();
                break;
            }
            case "COMMAND": {
                inUse = !this.taskDAO.findByCommand(implementation).isEmpty();
                break;
            }
            case "RECON_FILTER_BUILDER": {
                inUse = !this.taskDAO.findByReconFilterBuilder(implementation).isEmpty();
                break;
            }
            case "LOGIC_ACTIONS": {
                inUse = !this.realmDAO.findByLogicActions(implementation).isEmpty();
                break;
            }
            case "PROVISION_SORTER": {
                inUse = !this.resourceDAO.findByProvisionSorter(implementation).isEmpty();
                break;
            }
            case "PROPAGATION_ACTIONS": {
                inUse = !this.resourceDAO.findByPropagationActions(implementation).isEmpty();
                break;
            }
            case "PULL_ACTIONS": {
                inUse = !this.taskDAO.findByPullActions(implementation).isEmpty();
                break;
            }
            case "PUSH_ACTIONS": {
                inUse = !this.taskDAO.findByPushActions(implementation).isEmpty();
                break;
            }
            case "PULL_CORRELATION_RULE": {
                inUse = !this.policyDAO.findByPullCorrelationRule(implementation).isEmpty();
                break;
            }
            case "PUSH_CORRELATION_RULE": {
                inUse = !this.policyDAO.findByPushCorrelationRule(implementation).isEmpty();
                break;
            }
            case "ATTR_VALUE_VALIDATOR": {
                inUse = !this.plainSchemaDAO.findByValidator(implementation).isEmpty();
                break;
            }
            case "RECIPIENTS_PROVIDER": {
                inUse = !this.notificationDAO.findByRecipientsProvider(implementation).isEmpty();
                break;
            }
        }
        if (inUse) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InUse);
            sce.getElements().add("This implementation is in use");
            throw sce;
        }
        this.implementationDAO.delete(key);
    }

    @Override
    protected ImplementationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ImplementationTO)) continue;
                key = ((ImplementationTO)args[i]).getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getImplementationTO(this.implementationDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

