/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.commons.IdRepoImplementationInfoProvider;
import org.apache.syncope.client.console.commons.ImplementationInfoProvider;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.common.lib.policy.PullCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PushCorrelationRuleConf;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.IdMImplementationType;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class IdMImplementationInfoProvider
extends IdRepoImplementationInfoProvider {
    private static final long serialVersionUID = -5385695412826366167L;

    public IdMImplementationInfoProvider(ClassPathScanImplementationLookup lookup, ImplementationRestClient implementationRestClient) {
        super(lookup, implementationRestClient);
    }

    public ImplementationInfoProvider.ViewMode getViewMode(ImplementationTO implementation) {
        return "PULL_CORRELATION_RULE".equals(implementation.getType()) || "PUSH_CORRELATION_RULE".equals(implementation.getType()) ? ImplementationInfoProvider.ViewMode.JSON_BODY : super.getViewMode(implementation);
    }

    public List<String> getClasses(ImplementationTO implementation, ImplementationInfoProvider.ViewMode viewMode) {
        List<Object> classes = new ArrayList();
        if (viewMode == ImplementationInfoProvider.ViewMode.JSON_BODY && IdMImplementationType.values().containsKey(implementation.getType())) {
            switch (implementation.getType()) {
                case "PULL_CORRELATION_RULE": {
                    classes = this.lookup.getClasses(PullCorrelationRuleConf.class).stream().map(Class::getName).collect(Collectors.toList());
                    break;
                }
                case "PUSH_CORRELATION_RULE": {
                    classes = this.lookup.getClasses(PushCorrelationRuleConf.class).stream().map(Class::getName).collect(Collectors.toList());
                    break;
                }
            }
            Collections.sort(classes);
        } else {
            classes = super.getClasses(implementation, viewMode);
        }
        return classes;
    }

    public String getGroovyTemplateClassName(String implementationType) {
        String templateClassName;
        switch (implementationType) {
            case "RECON_FILTER_BUILDER": {
                templateClassName = "MyReconFilterBuilder";
                break;
            }
            case "PROPAGATION_ACTIONS": {
                templateClassName = "MyPropagationActions";
                break;
            }
            case "PULL_ACTIONS": {
                templateClassName = "MyPullActions";
                break;
            }
            case "PUSH_ACTIONS": {
                templateClassName = "MyPushActions";
                break;
            }
            case "PULL_CORRELATION_RULE": {
                templateClassName = "MyPullCorrelationRule";
                break;
            }
            case "PUSH_CORRELATION_RULE": {
                templateClassName = "MyPushCorrelationRule";
                break;
            }
            case "PROVISION_SORTER": {
                templateClassName = "MyProvisionSorter";
                break;
            }
            default: {
                templateClassName = super.getGroovyTemplateClassName(implementationType);
            }
        }
        return templateClassName;
    }

    public Class<?> getClass(String implementationType, String name) {
        Class clazz;
        switch (implementationType) {
            case "PULL_CORRELATION_RULE": {
                clazz = this.lookup.getClasses(PullCorrelationRuleConf.class).stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
                break;
            }
            case "PUSH_CORRELATION_RULE": {
                clazz = this.lookup.getClasses(PushCorrelationRuleConf.class).stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
                break;
            }
            default: {
                clazz = super.getClass(implementationType, name);
            }
        }
        return clazz;
    }

    public IModel<List<String>> getReconFilterBuilders() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdMImplementationInfoProvider.this.implementationRestClient.list("RECON_FILTER_BUILDER").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }

    public IModel<List<String>> getPullActions() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdMImplementationInfoProvider.this.implementationRestClient.list("PULL_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }

    public IModel<List<String>> getPushActions() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return IdMImplementationInfoProvider.this.implementationRestClient.list("PUSH_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
    }
}

