/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.surrogate;

import java.util.Collection;
import java.util.Optional;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;

@FunctionalInterface
public interface SurrogateAuthenticationService {
    public static final String WILDCARD_ACCOUNT = "*";
    public static final String BEAN_NAME = "surrogateAuthenticationService";
    public static final String AUTHENTICATION_ATTR_SURROGATE_USER = "surrogateUser";
    public static final String AUTHENTICATION_ATTR_SURROGATE_PRINCIPAL = "surrogatePrincipal";
    public static final String AUTHENTICATION_ATTR_SURROGATE_ENABLED = "surrogateEnabled";

    default public boolean canImpersonate(String surrogate, Principal principal, Optional<Service> service) {
        return false;
    }

    public Collection<String> getImpersonationAccounts(String var1);

    default public boolean isWildcardedAccount(String surrogate, Principal principal) {
        Collection<String> accounts = this.getImpersonationAccounts(principal.getId());
        return this.isWildcardedAccount(accounts);
    }

    default public boolean isWildcardedAccount(Collection<String> accounts) {
        return accounts.size() == 1 && accounts.contains(WILDCARD_ACCOUNT);
    }
}

