/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.datastore;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.datastore.DataStoreHttpSessionProperties;
import org.apache.wicket.Application;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.wicketstuff.shiro.wicket.page.store.SessionPageStore;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.datastore.httpsession", value={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={DataStoreHttpSessionProperties.class})
public class DataStoreHttpSessionConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private DataStoreHttpSessionProperties props;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(final WebApplication webApplication) {
        webApplication.setPageManagerProvider((IPageManagerProvider)new DefaultPageManagerProvider((Application)webApplication){

            protected IPageStore newPersistentStore() {
                return new SessionPageStore(webApplication.getName(), DataStoreHttpSessionConfig.this.props.getPagesNumber());
            }
        });
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }
}

