/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.yubico.u2f.U2fPrimitives;
import com.yubico.u2f.crypto.ChallengeGenerator;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.RegisterRequest;
import com.yubico.u2f.data.messages.RegisterResponse;
import com.yubico.u2f.data.messages.RegisteredKey;
import com.yubico.u2f.data.messages.json.JsonSerializable;
import com.yubico.u2f.data.messages.json.Persistable;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.util.List;
import lombok.Generated;

@Deprecated
public class RegisterRequestData
extends JsonSerializable
implements Persistable {
    private static final long serialVersionUID = 60855174227617680L;
    @JsonProperty
    private final String appId;
    @JsonProperty
    private final List<RegisteredKey> registeredKeys;
    @JsonProperty
    private final List<RegisterRequest> registerRequests;

    public RegisterRequestData(@JsonProperty(value="appId") String appId, @JsonProperty(value="registeredKeys") List<RegisteredKey> registeredKeys, @JsonProperty(value="registerRequests") List<RegisterRequest> registerRequests) {
        this.appId = appId;
        this.registeredKeys = registeredKeys;
        this.registerRequests = registerRequests;
    }

    public RegisterRequestData(String appId, Iterable<? extends DeviceRegistration> devices, U2fPrimitives u2f, ChallengeGenerator challengeGenerator) {
        this.appId = appId;
        ImmutableList.Builder registeredKeys = ImmutableList.builder();
        for (DeviceRegistration deviceRegistration : devices) {
            if (deviceRegistration.isCompromised()) continue;
            registeredKeys.add((Object)new RegisteredKey(deviceRegistration.getKeyHandle()));
        }
        this.registeredKeys = registeredKeys.build();
        this.registerRequests = ImmutableList.of((Object)u2f.startRegistration(appId, challengeGenerator.generateChallenge()));
    }

    public List<RegisteredKey> getRegisteredKeys() {
        return ImmutableList.copyOf(this.registeredKeys);
    }

    public List<RegisterRequest> getRegisterRequests() {
        return ImmutableList.copyOf(this.registerRequests);
    }

    public RegisterRequest getRegisterRequest(RegisterResponse response) {
        return (RegisterRequest)Iterables.getOnlyElement(this.registerRequests);
    }

    @Override
    public String getRequestId() {
        return ((RegisterRequest)Iterables.getOnlyElement(this.registerRequests)).getChallenge();
    }

    public static RegisterRequestData fromJson(String json) throws U2fBadInputException {
        return RegisterRequestData.fromJson(json, RegisterRequestData.class);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterRequestData)) {
            return false;
        }
        RegisterRequestData other = (RegisterRequestData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appId = this.appId;
        String other$appId = other.appId;
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        List<RegisteredKey> this$registeredKeys = this.getRegisteredKeys();
        List<RegisteredKey> other$registeredKeys = other.getRegisteredKeys();
        if (this$registeredKeys == null ? other$registeredKeys != null : !((Object)this$registeredKeys).equals(other$registeredKeys)) {
            return false;
        }
        List<RegisterRequest> this$registerRequests = this.getRegisterRequests();
        List<RegisterRequest> other$registerRequests = other.getRegisterRequests();
        return !(this$registerRequests == null ? other$registerRequests != null : !((Object)this$registerRequests).equals(other$registerRequests));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisterRequestData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.appId;
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        List<RegisteredKey> $registeredKeys = this.getRegisteredKeys();
        result = result * 59 + ($registeredKeys == null ? 43 : ((Object)$registeredKeys).hashCode());
        List<RegisterRequest> $registerRequests = this.getRegisterRequests();
        result = result * 59 + ($registerRequests == null ? 43 : ((Object)$registerRequests).hashCode());
        return result;
    }
}

