/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.Refill;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class Bandwidth
implements ComparableByContent<Bandwidth> {
    public static final String UNDEFINED_ID = null;
    final long capacity;
    final long initialTokens;
    final long refillPeriodNanos;
    final long refillTokens;
    final boolean refillIntervally;
    final long timeOfFirstRefillMillis;
    final boolean useAdaptiveInitialTokens;
    final String id;
    public static final SerializationHandle<Bandwidth> SERIALIZATION_HANDLE = new SerializationHandle<Bandwidth>(){

        @Override
        public <S> Bandwidth deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long capacity = adapter.readLong(input);
            long initialTokens = adapter.readLong(input);
            long refillPeriodNanos = adapter.readLong(input);
            long refillTokens = adapter.readLong(input);
            boolean refillIntervally = adapter.readBoolean(input);
            long timeOfFirstRefillMillis = adapter.readLong(input);
            boolean useAdaptiveInitialTokens = adapter.readBoolean(input);
            boolean hasId = adapter.readBoolean(input);
            String id = hasId ? adapter.readString(input) : UNDEFINED_ID;
            return new Bandwidth(capacity, refillPeriodNanos, refillTokens, initialTokens, refillIntervally, timeOfFirstRefillMillis, useAdaptiveInitialTokens, id);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, Bandwidth bandwidth, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeLong(output, bandwidth.capacity);
            adapter.writeLong(output, bandwidth.initialTokens);
            adapter.writeLong(output, bandwidth.refillPeriodNanos);
            adapter.writeLong(output, bandwidth.refillTokens);
            adapter.writeBoolean(output, bandwidth.refillIntervally);
            adapter.writeLong(output, bandwidth.timeOfFirstRefillMillis);
            adapter.writeBoolean(output, bandwidth.useAdaptiveInitialTokens);
            adapter.writeBoolean(output, bandwidth.id != null);
            if (bandwidth.hasId()) {
                adapter.writeString(output, bandwidth.id);
            }
        }

        @Override
        public int getTypeId() {
            return 1;
        }

        @Override
        public Class<Bandwidth> getSerializedType() {
            return Bandwidth.class;
        }

        @Override
        public Bandwidth fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long capacity = this.readLongValue(snapshot, "capacity");
            long initialTokens = this.readLongValue(snapshot, "initialTokens");
            long refillPeriodNanos = this.readLongValue(snapshot, "refillPeriodNanos");
            long refillTokens = this.readLongValue(snapshot, "refillTokens");
            boolean refillIntervally = (Boolean)snapshot.get("refillIntervally");
            long timeOfFirstRefillMillis = this.readLongValue(snapshot, "timeOfFirstRefillMillis");
            boolean useAdaptiveInitialTokens = (Boolean)snapshot.get("useAdaptiveInitialTokens");
            String id = (String)snapshot.get("id");
            return new Bandwidth(capacity, refillPeriodNanos, refillTokens, initialTokens, refillIntervally, timeOfFirstRefillMillis, useAdaptiveInitialTokens, id);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(Bandwidth bandwidth, Version backwardCompatibilityVersion) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("capacity", bandwidth.capacity);
            result.put("initialTokens", bandwidth.initialTokens);
            result.put("refillPeriodNanos", bandwidth.refillPeriodNanos);
            result.put("refillTokens", bandwidth.refillTokens);
            result.put("refillIntervally", bandwidth.refillIntervally);
            result.put("timeOfFirstRefillMillis", bandwidth.timeOfFirstRefillMillis);
            result.put("useAdaptiveInitialTokens", bandwidth.useAdaptiveInitialTokens);
            if (bandwidth.id != null) {
                result.put("id", bandwidth.id);
            }
            return result;
        }

        @Override
        public String getTypeName() {
            return "Bandwidth";
        }
    };

    private Bandwidth(long capacity, long refillPeriodNanos, long refillTokens, long initialTokens, boolean refillIntervally, long timeOfFirstRefillMillis, boolean useAdaptiveInitialTokens, String id) {
        this.capacity = capacity;
        this.initialTokens = initialTokens;
        this.refillPeriodNanos = refillPeriodNanos;
        this.refillTokens = refillTokens;
        this.refillIntervally = refillIntervally;
        this.timeOfFirstRefillMillis = timeOfFirstRefillMillis;
        this.useAdaptiveInitialTokens = useAdaptiveInitialTokens;
        this.id = id;
    }

    public static Bandwidth simple(long capacity, Duration period) {
        Refill refill = Refill.greedy(capacity, period);
        return Bandwidth.classic(capacity, refill);
    }

    public static Bandwidth classic(long capacity, Refill refill) {
        if (capacity <= 0L) {
            throw BucketExceptions.nonPositiveCapacity(capacity);
        }
        if (refill == null) {
            throw BucketExceptions.nullBandwidthRefill();
        }
        return new Bandwidth(capacity, refill.periodNanos, refill.tokens, capacity, refill.refillIntervally, refill.timeOfFirstRefillMillis, refill.useAdaptiveInitialTokens, UNDEFINED_ID);
    }

    public Bandwidth withInitialTokens(long initialTokens) {
        if (initialTokens < 0L) {
            throw BucketExceptions.nonPositiveInitialTokens(initialTokens);
        }
        if (this.isIntervallyAligned() && this.useAdaptiveInitialTokens) {
            throw BucketExceptions.intervallyAlignedRefillWithAdaptiveInitialTokensIncompatipleWithManualSpecifiedInitialTokens();
        }
        return new Bandwidth(this.capacity, this.refillPeriodNanos, this.refillTokens, initialTokens, this.refillIntervally, this.timeOfFirstRefillMillis, this.useAdaptiveInitialTokens, UNDEFINED_ID);
    }

    public Bandwidth withId(String id) {
        return new Bandwidth(this.capacity, this.refillPeriodNanos, this.refillTokens, this.initialTokens, this.refillIntervally, this.timeOfFirstRefillMillis, this.useAdaptiveInitialTokens, id);
    }

    public boolean isIntervallyAligned() {
        return this.timeOfFirstRefillMillis != Long.MIN_VALUE;
    }

    public long getTimeOfFirstRefillMillis() {
        return this.timeOfFirstRefillMillis;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getInitialTokens() {
        return this.initialTokens;
    }

    public long getRefillPeriodNanos() {
        return this.refillPeriodNanos;
    }

    public long getRefillTokens() {
        return this.refillTokens;
    }

    public boolean isUseAdaptiveInitialTokens() {
        return this.useAdaptiveInitialTokens;
    }

    public boolean isRefillIntervally() {
        return this.refillIntervally;
    }

    public boolean isGready() {
        return !this.refillIntervally;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bandwidth bandwidth = (Bandwidth)o;
        if (this.capacity != bandwidth.capacity) {
            return false;
        }
        if (this.initialTokens != bandwidth.initialTokens) {
            return false;
        }
        if (this.refillPeriodNanos != bandwidth.refillPeriodNanos) {
            return false;
        }
        if (this.refillTokens != bandwidth.refillTokens) {
            return false;
        }
        if (this.refillIntervally != bandwidth.refillIntervally) {
            return false;
        }
        if (this.timeOfFirstRefillMillis != bandwidth.timeOfFirstRefillMillis) {
            return false;
        }
        return this.useAdaptiveInitialTokens == bandwidth.useAdaptiveInitialTokens;
    }

    public int hashCode() {
        int result = (int)(this.capacity ^ this.capacity >>> 32);
        result = 31 * result + (int)(this.initialTokens ^ this.initialTokens >>> 32);
        result = 31 * result + (int)(this.refillPeriodNanos ^ this.refillPeriodNanos >>> 32);
        result = 31 * result + (int)(this.refillTokens ^ this.refillTokens >>> 32);
        result = 31 * result + (this.refillIntervally ? 1 : 0);
        result = 31 * result + (int)(this.timeOfFirstRefillMillis ^ this.timeOfFirstRefillMillis >>> 32);
        result = 31 * result + (this.useAdaptiveInitialTokens ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Bandwidth{");
        sb.append("capacity=").append(this.capacity);
        sb.append(", initialTokens=").append(this.initialTokens);
        sb.append(", refillPeriodNanos=").append(this.refillPeriodNanos);
        sb.append(", refillTokens=").append(this.refillTokens);
        sb.append(", refillIntervally=").append(this.refillIntervally);
        sb.append(", timeOfFirstRefillMillis=").append(this.timeOfFirstRefillMillis);
        sb.append(", useAdaptiveInitialTokens=").append(this.useAdaptiveInitialTokens);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equalsByContent(Bandwidth other) {
        return this.capacity == other.capacity && this.initialTokens == other.initialTokens && this.refillPeriodNanos == other.refillPeriodNanos && this.refillTokens == other.refillTokens && this.refillIntervally == other.refillIntervally && this.timeOfFirstRefillMillis == other.timeOfFirstRefillMillis && this.useAdaptiveInitialTokens == other.useAdaptiveInitialTokens;
    }
}

