/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest;
import com.google.api.services.directory.Directory;
import com.google.api.services.licensing.Licensing;
import com.google.api.services.licensing.model.Empty;
import java.io.IOException;
import net.tirasa.connid.bundles.googleapps.GoogleApiExecutor;
import net.tirasa.connid.bundles.googleapps.GoogleAppsConfiguration;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import net.tirasa.connid.bundles.googleapps.LicenseAssignmentsHandler;
import net.tirasa.connid.bundles.googleapps.RequestResultHandler;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public class GoogleAppsDelete {
    private static final Log LOG = Log.getLog(GoogleAppsDelete.class);
    private final GoogleAppsConfiguration configuration;
    private final ObjectClass objectClass;
    private final Uid uid;

    public GoogleAppsDelete(GoogleAppsConfiguration configuration, ObjectClass objectClass, Uid uid) {
        this.configuration = configuration;
        this.objectClass = objectClass;
        this.uid = uid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        Directory.Users.Delete directoryRequest = null;
        Licensing.LicenseAssignments.Delete licesingRequest = null;
        try {
            if (ObjectClass.ACCOUNT.equals((Object)this.objectClass)) {
                directoryRequest = this.configuration.getDirectory().users().delete(this.uid.getUidValue());
            } else if (ObjectClass.GROUP.equals((Object)this.objectClass)) {
                directoryRequest = this.configuration.getDirectory().groups().delete(this.uid.getUidValue());
            } else if (GoogleAppsUtil.MEMBER.equals((Object)this.objectClass)) {
                String[] ids = this.uid.getUidValue().split("/");
                if (ids.length != 2) throw new UnknownUidException("Invalid ID format");
                directoryRequest = this.configuration.getDirectory().members().delete(ids[0], ids[1]);
            } else if (GoogleAppsUtil.ORG_UNIT.equals((Object)this.objectClass)) {
                directoryRequest = this.configuration.getDirectory().orgunits().delete("my_customer", this.uid.getUidValue());
            } else if (GoogleAppsUtil.LICENSE_ASSIGNMENT.equals((Object)this.objectClass)) {
                licesingRequest = LicenseAssignmentsHandler.delete(this.configuration.getLicensing().licenseAssignments(), this.uid.getUidValue());
            }
        }
        catch (IOException e) {
            throw ConnectorException.wrap((Throwable)e);
        }
        if (null == directoryRequest && null == licesingRequest) {
            LOG.warn("Delete of type {0} is not supported", new Object[]{this.configuration.getConnectorMessages().format(this.objectClass.getDisplayNameKey(), this.objectClass.getObjectClassValue(), new Object[0])});
            throw new UnsupportedOperationException("Delete of type" + this.objectClass.getObjectClassValue() + " is not supported");
        }
        if (directoryRequest != null) {
            GoogleApiExecutor.execute(directoryRequest, new RequestResultHandler<AbstractGoogleJsonClientRequest<Void>, Void, Void>(){

                @Override
                public Void handleResult(AbstractGoogleJsonClientRequest<Void> request, Void value) {
                    return null;
                }

                @Override
                public Void handleNotFound(IOException e) {
                    throw new UnknownUidException(GoogleAppsDelete.this.uid, GoogleAppsDelete.this.objectClass);
                }
            });
        }
        if (licesingRequest == null) return;
        GoogleApiExecutor.execute(licesingRequest, new RequestResultHandler<AbstractGoogleJsonClientRequest<Empty>, Empty, Empty>(){

            @Override
            public Empty handleResult(AbstractGoogleJsonClientRequest<Empty> request, Empty value) {
                return null;
            }

            @Override
            public Empty handleNotFound(IOException e) {
                throw new UnknownUidException(GoogleAppsDelete.this.uid, GoogleAppsDelete.this.objectClass);
            }
        });
    }
}

