/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.ok;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Token;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.ok.OkConfiguration;
import org.pac4j.oauth.profile.ok.OkProfile;

public class OkProfileDefinition
extends OAuthProfileDefinition {
    public static final String UID = "uid";
    public static final String BIRTHDAY = "birthday";
    public static final String AGE = "age";
    public static final String NAME = "name";
    public static final String LOCATION_CITY = "location.city";
    public static final String LOCATION_COUNTRY = "location.country";
    public static final String LOCATION_COUNTRY_CODE = "location.countryCode";
    public static final String LOCATION_COUNTRY_NAME = "location.countryName";
    public static final String ONLINE = "online";
    public static final String LAST_NAME = "last_name";
    public static final String HAS_EMAIL = "has_email";
    public static final String CURRENT_STATUS = "current_status";
    public static final String CURRENT_STATUS_ID = "current_status_id";
    public static final String CURRENT_STATUS_DATE = "current_status_date";
    public static final String PIC_1 = "pic_1";
    public static final String PIC_2 = "pic_2";
    private static final String API_BASE_URL = "http://api.ok.ru/fb.do?";

    public OkProfileDefinition() {
        super(x -> new OkProfile());
        Arrays.stream(new String[]{UID, BIRTHDAY, AGE, NAME, LOCATION_CITY, LOCATION_COUNTRY, LOCATION_COUNTRY_CODE, LOCATION_COUNTRY_NAME, ONLINE, LAST_NAME, HAS_EMAIL, CURRENT_STATUS, CURRENT_STATUS_ID, CURRENT_STATUS_DATE}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(PIC_1, (AttributeConverter)Converters.URL);
        this.primary(PIC_2, (AttributeConverter)Converters.URL);
    }

    @Override
    public String getProfileUrl(Token token, OAuthConfiguration configuration) {
        String finalSign;
        String accessToken = ((OAuth2AccessToken)token).getAccessToken();
        String baseParams = "application_key=" + ((OkConfiguration)configuration).getPublicKey() + "&format=json&method=users.getCurrentUser";
        try {
            String preSign = this.getMD5SignAsHexString(accessToken + configuration.getSecret());
            finalSign = this.getMD5SignAsHexString(baseParams.replaceAll("&", "") + preSign);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return null;
        }
        return API_BASE_URL + baseParams + "&access_token=" + accessToken + "&sig=" + finalSign;
    }

    protected String getMD5SignAsHexString(String strForEncoding) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        StringBuilder result = new StringBuilder();
        for (byte aByte : md.digest(strForEncoding.getBytes(StandardCharsets.UTF_8))) {
            if ((0xFF & aByte) < 16) {
                result.append("0").append(Integer.toHexString(0xFF & aByte));
                continue;
            }
            result.append(Integer.toHexString(0xFF & aByte));
        }
        return result.toString();
    }

    @Override
    public OkProfile extractUserProfile(String body) {
        OkProfile profile = (OkProfile)this.newProfile(new Object[0]);
        JsonNode userNode = JsonHelper.getFirstNode(body);
        if (userNode != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(userNode, UID)));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(userNode, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

