/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.wordpress;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.Token;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.wordpress.WordPressLinks;
import org.pac4j.oauth.profile.wordpress.WordPressProfile;

public class WordPressProfileDefinition
extends OAuthProfileDefinition {
    public static final String PRIMARY_BLOG = "primary_blog";
    public static final String AVATAR_URL = "avatar_URL";
    public static final String PROFILE_URL = "profile_URL";
    public static final String LINKS = "links";

    public WordPressProfileDefinition() {
        super(x -> new WordPressProfile());
        this.primary("username", (AttributeConverter)Converters.STRING);
        this.primary(PRIMARY_BLOG, (AttributeConverter)Converters.INTEGER);
        this.primary(AVATAR_URL, (AttributeConverter)Converters.URL);
        this.primary(PROFILE_URL, (AttributeConverter)Converters.URL);
        this.secondary(LINKS, new JsonConverter(WordPressLinks.class));
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return "https://public-api.wordpress.com/rest/v1/me/?pretty=1";
    }

    @Override
    public WordPressProfile extractUserProfile(String body) {
        WordPressProfile profile = (WordPressProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json, "ID")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
            if ((json = json.get("meta")) != null) {
                String attribute = LINKS;
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, LINKS, JsonHelper.getElement(json, LINKS));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

