/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.Login;
import org.apache.syncope.client.console.pages.SAML2SPBeforeLogout;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2SPLogin
extends WebPage {
    private static final long serialVersionUID = -245801838574917258L;
    private static final Logger LOG = LoggerFactory.getLogger(SAML2SPLogin.class);
    private static final String SAML_ACCESS_ERROR = "SAML 2.0 access error";

    public SAML2SPLogin(PageParameters parameters) {
        super(parameters);
        String token = parameters.get("saml2sp4ui.jwt").toOptionalString();
        if (StringUtils.isBlank((CharSequence)token)) {
            LOG.error("No JWT found, redirecting to default greeter");
            PageParameters params = new PageParameters();
            params.add("errorMessage", (Object)SAML_ACCESS_ERROR);
            this.setResponsePage(Login.class, params);
        }
        IAuthenticationStrategy strategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy();
        if (SyncopeConsoleSession.get().authenticate(token)) {
            if (parameters.get("saml2sp4ui.sloSupported").toBoolean(false)) {
                SyncopeConsoleSession.get().setAttribute("beforeLogoutPage", SAML2SPBeforeLogout.class);
            }
            this.continueToOriginalDestination();
            this.setResponsePage(this.getApplication().getHomePage());
        } else {
            PageParameters params = new PageParameters();
            params.add("errorMessage", (Object)SAML_ACCESS_ERROR);
            this.setResponsePage(Login.class, params);
        }
        strategy.remove();
    }
}

