/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata.locator;

import com.github.benmanes.caffeine.cache.Cache;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.locator.AbstractSamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FileSystemSamlIdPMetadataLocator
extends AbstractSamlIdPMetadataLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemSamlIdPMetadataLocator.class);
    private final File metadataLocation;

    public FileSystemSamlIdPMetadataLocator(Resource resource, Cache<String, SamlIdPMetadataDocument> metadataCache) throws Exception {
        this(resource.getFile(), metadataCache);
    }

    public FileSystemSamlIdPMetadataLocator(File resource, Cache<String, SamlIdPMetadataDocument> metadataCache) {
        super((CipherExecutor<String, String>)CipherExecutor.noOpOfStringToString(), metadataCache);
        this.metadataLocation = resource;
    }

    @Override
    public Resource resolveSigningCertificate(Optional<SamlRegisteredService> registeredService) {
        return this.getMetadataArtifact(registeredService, "idp-signing.crt");
    }

    @Override
    public Resource resolveSigningKey(Optional<SamlRegisteredService> registeredService) {
        return this.getMetadataArtifact(registeredService, "idp-signing.key");
    }

    @Override
    public Resource resolveMetadata(Optional<SamlRegisteredService> registeredService) {
        return this.getMetadataArtifact(registeredService, "idp-metadata.xml");
    }

    @Override
    public Resource getEncryptionCertificate(Optional<SamlRegisteredService> registeredService) {
        return this.getMetadataArtifact(registeredService, "idp-encryption.crt");
    }

    @Override
    public Resource resolveEncryptionKey(Optional<SamlRegisteredService> registeredService) {
        return this.getMetadataArtifact(registeredService, "idp-encryption.key");
    }

    @Override
    public boolean exists(Optional<SamlRegisteredService> registeredService) {
        return this.resolveMetadata(registeredService).exists();
    }

    @Override
    public void initialize() {
        this.initializeMetadataDirectory();
        LOGGER.info("Metadata directory location is at [{}]", (Object)this.metadataLocation);
    }

    @Override
    protected SamlIdPMetadataDocument fetchInternal(Optional<SamlRegisteredService> registeredService) throws Exception {
        return (SamlIdPMetadataDocument)FunctionUtils.doUnchecked(() -> {
            SamlIdPMetadataDocument doc = new SamlIdPMetadataDocument();
            doc.setMetadata(IOUtils.toString((InputStream)this.resolveMetadata(registeredService).getInputStream(), (Charset)StandardCharsets.UTF_8));
            doc.setEncryptionCertificate(IOUtils.toString((InputStream)this.getEncryptionCertificate(registeredService).getInputStream(), (Charset)StandardCharsets.UTF_8));
            doc.setEncryptionKey(IOUtils.toString((InputStream)this.resolveEncryptionKey(registeredService).getInputStream(), (Charset)StandardCharsets.UTF_8));
            doc.setSigningCertificate(IOUtils.toString((InputStream)this.resolveSigningCertificate(registeredService).getInputStream(), (Charset)StandardCharsets.UTF_8));
            doc.setSigningKey(IOUtils.toString((InputStream)this.resolveSigningKey(registeredService).getInputStream(), (Charset)StandardCharsets.UTF_8));
            doc.setAppliesTo(SamlIdPMetadataGenerator.getAppliesToFor(registeredService));
            return doc;
        });
    }

    protected Resource getMetadataArtifact(Optional<SamlRegisteredService> result, String artifactName) {
        if (result.isPresent()) {
            File serviceDirectory = new File(this.metadataLocation, SamlIdPMetadataGenerator.getAppliesToFor(result));
            LOGGER.trace("Metadata directory location for [{}] is [{}]", (Object)result.get().getName(), (Object)serviceDirectory);
            if (serviceDirectory.exists()) {
                File artifact = new File(serviceDirectory, artifactName);
                LOGGER.trace("Artifact location for [{}] and [{}] is [{}]", new Object[]{artifactName, result.get().getName(), artifact});
                if (artifact.exists()) {
                    LOGGER.debug("Using metadata artifact [{}] at [{}]", (Object)artifactName, (Object)artifact);
                    return new FileSystemResource(artifact);
                }
            }
        }
        this.initializeMetadataDirectory();
        return new FileSystemResource(new File(this.metadataLocation, artifactName));
    }

    private void initializeMetadataDirectory() {
        if (!this.metadataLocation.exists()) {
            LOGGER.debug("Metadata directory [{}] does not exist. Creating...", (Object)this.metadataLocation);
            if (!this.metadataLocation.mkdir()) {
                throw new IllegalArgumentException("Metadata directory location " + this.metadataLocation + " cannot be located/created");
            }
        }
    }

    @Generated
    public File getMetadataLocation() {
        return this.metadataLocation;
    }
}

