/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome5IconType;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.UserRequests;
import org.apache.syncope.client.console.rest.UserRequestRestClient;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.widgets.ExtAlertWidget;
import org.apache.syncope.client.ui.commons.annotations.ExtWidget;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

@ExtWidget(priority=10)
public class UserRequestFormsWidget
extends ExtAlertWidget<UserRequestForm> {
    private static final long serialVersionUID = 7667120094526529934L;
    @SpringBean
    protected UserRequestRestClient userRequestRestClient;
    protected final List<UserRequestForm> lastForms = new ArrayList<UserRequestForm>();

    public UserRequestFormsWidget(String id, PageReference pageRef) {
        super(id, pageRef);
        this.setOutputMarkupId(true);
        this.latestAlertsList.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.of(30L, ChronoUnit.SECONDS)){
            private static final long serialVersionUID = 7298597675929755960L;

            protected void onTimer(AjaxRequestTarget target) {
                if (!((List)UserRequestFormsWidget.this.latestAlerts.getObject()).equals(UserRequestFormsWidget.this.lastForms)) {
                    UserRequestFormsWidget.this.refreshLatestAlerts(target);
                }
            }
        }});
    }

    public final void refreshLatestAlerts(AjaxRequestTarget target) {
        ((List)this.latestAlerts.getObject()).clear();
        ((List)this.latestAlerts.getObject()).addAll(this.lastForms);
        int latestAlertSize = this.getLatestAlertsSize();
        this.linkAlertsNumber.setDefaultModelObject((Object)latestAlertSize);
        target.add(new Component[]{this.linkAlertsNumber});
        this.headerAlertsNumber.setDefaultModelObject((Object)latestAlertSize);
        target.add(new Component[]{this.headerAlertsNumber});
        target.add(new Component[]{this.latestAlertsList});
        this.lastForms.clear();
        this.lastForms.addAll((Collection)this.latestAlerts.getObject());
    }

    protected int getLatestAlertsSize() {
        return SyncopeConsoleSession.get().owns("USER_REQUEST_FORM_LIST", new String[0]) ? this.userRequestRestClient.countForms(null) : 0;
    }

    protected IModel<List<UserRequestForm>> getLatestAlerts() {
        return new ListModel<UserRequestForm>(){
            private static final long serialVersionUID = -2583290457773357445L;

            public List<UserRequestForm> getObject() {
                List<UserRequestForm> updatedForms = SyncopeConsoleSession.get().owns("USER_REQUEST_FORM_LIST", new String[0]) ? UserRequestFormsWidget.this.userRequestRestClient.listForms(null, 1, 5, (SortParam<String>)new SortParam((Object)"createTime", true)) : Collections.emptyList();
                return updatedForms;
            }
        };
    }

    protected AbstractLink getEventsLink(String linkid) {
        BookmarkablePageLink userRequests = BookmarkablePageLinkBuilder.build((String)linkid, UserRequests.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)userRequests, (Action)WebPage.ENABLE, (String)"USER_REQUEST_FORM_LIST");
        return userRequests;
    }

    protected Icon getIcon(String iconid) {
        return new Icon(iconid, (IconType)FontAwesome5IconType.handshake_r);
    }
}

