/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.button;

import com.googlecode.wicket.jquery.core.IJsonFactory;
import com.googlecode.wicket.kendo.ui.KendoIcon;
import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractButton
implements IJsonFactory,
IClusterable {
    private static final long serialVersionUID = 1L;
    private static short sequence = 0;
    public static final String CSS_ICON_ONLY = "w-icon-only";
    public static final String CSS_STATE_DISABLED = "k-state-disabled";
    public static final String EDIT = "edit";
    public static final String SAVE = "save";
    public static final String CREATE = "create";
    public static final String CANCEL = "cancel";
    public static final String DESTROY = "destroy";
    private final int id = AbstractButton.nextSequence();
    private final String name;
    private final IModel<String> textModel;
    private final String property;

    public AbstractButton(String name) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)name)), null);
    }

    public AbstractButton(String name, IModel<String> text) {
        this(name, text, null);
    }

    public AbstractButton(String name, String property) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)name)), property);
    }

    public AbstractButton(String name, IModel<String> text, String property) {
        this.name = name;
        this.textModel = text;
        this.property = property;
    }

    public String getName() {
        return this.name;
    }

    public IModel<String> getTextModel() {
        return this.textModel;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public String getCSSClass() {
        StringBuilder builder = new StringBuilder();
        String text = (String)this.getTextModel().getObject();
        if (!this.isEnabled()) {
            builder.append(CSS_STATE_DISABLED);
        }
        if (Strings.isEmpty((String)text)) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(CSS_ICON_ONLY);
        }
        return builder.toString();
    }

    public String getIcon() {
        return "";
    }

    public String getIconClass() {
        String icon = this.getIcon();
        if (!KendoIcon.isNone(icon)) {
            return KendoIcon.getCssClass(icon);
        }
        return "";
    }

    public int hashCode() {
        return this.id;
    }

    public abstract boolean isBuiltIn();

    public boolean equals(Object object) {
        if (object instanceof AbstractButton) {
            return this.match(((AbstractButton)object).getName());
        }
        return super.equals(object);
    }

    public boolean match(String name) {
        return Strings.isEqual((String)name, (String)this.name);
    }

    private static synchronized int nextSequence() {
        short s = sequence;
        sequence = (short)(s + 1);
        return s % Short.MAX_VALUE;
    }
}

